/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteOutputStreamClient;", "Ljava/io/OutputStream;", "remote", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getRemote", "()Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "write", "", "data", "", "offset", "", "length", "byte", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nRemoteOutputStreamClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteOutputStreamClient.kt\norg/jetbrains/kotlin/daemon/RemoteOutputStreamClient\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,38:1\n44#2,4:39\n44#2,4:43\n44#2,4:47\n*S KotlinDebug\n*F\n+ 1 RemoteOutputStreamClient.kt\norg/jetbrains/kotlin/daemon/RemoteOutputStreamClient\n*L\n27#1:39,4\n31#1:43,4\n35#1:47,4\n*E\n"})
public final class RemoteOutputStreamClient
extends OutputStream {
    @NotNull
    private final RemoteOutputStream remote;
    @NotNull
    private final Profiler profiler;

    public RemoteOutputStreamClient(@NotNull RemoteOutputStream remote, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        this.remote = remote;
        this.profiler = profiler;
    }

    public /* synthetic */ RemoteOutputStreamClient(RemoteOutputStream remoteOutputStream, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profiler = new DummyProfiler();
        }
        this(remoteOutputStream, profiler);
    }

    @NotNull
    public final RemoteOutputStream getRemote() {
        return this.remote;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public void write(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.remote.write(data, 0, data.length);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    @Override
    public void write(@NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.remote.write(data, offset, length);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }

    @Override
    public void write(int n) {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.remote.write(n);
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }
}

