/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaOverrideWithWrongNullabilityOverrideChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "typePreparatorUnwrappingEnhancement", "Lorg/jetbrains/kotlin/types/checker/KotlinTypePreparator;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class JavaOverrideWithWrongNullabilityOverrideChecker
implements DeclarationChecker {
    @NotNull
    public static final JavaOverrideWithWrongNullabilityOverrideChecker INSTANCE = new JavaOverrideWithWrongNullabilityOverrideChecker();
    @NotNull
    private static final KotlinTypePreparator typePreparatorUnwrappingEnhancement = new KotlinTypePreparator(){

        public UnwrappedType prepareType(KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    };

    private JavaOverrideWithWrongNullabilityOverrideChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        boolean hasOverrideNode;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor instanceof CallableMemberDescriptor)) {
            return;
        }
        if (((CallableMemberDescriptor)descriptor).getOverriddenDescriptors().isEmpty()) {
            return;
        }
        KtModifierList modifierList2 = declaration.getModifierList();
        boolean bl = hasOverrideNode = modifierList2 != null && modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (!hasOverrideNode) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor).getOverriddenDescriptors()) {
            FunctionDescriptor unwrappedOverridden2;
            OverridingUtil overridingUtilWithEnhancementUnwrapped;
            if (!(callableMemberDescriptor instanceof JavaMethodDescriptor)) continue;
            Set relatedTypeParameters = new LinkedHashSet();
            Intrinsics.checkNotNullExpressionValue(OverridingUtil.createWithTypePreparatorAndCustomSubtype(typePreparatorUnwrappingEnhancement, (arg_0, arg_1) -> JavaOverrideWithWrongNullabilityOverrideChecker.check$lambda$1(relatedTypeParameters, arg_0, arg_1)), "createWithTypePreparatorAndCustomSubtype(...)");
            if (overridingUtilWithEnhancementUnwrapped.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor, containingClass, true).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.DEFAULT.isOverridableBy(callableMemberDescriptor, (CallableDescriptor)descriptor, containingClass, true).getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
            FunctionDescriptor functionDescriptor = ((JavaMethodDescriptor)callableMemberDescriptor).substitute(TypeSubstitutor.create(new TypeSubstitution(){

                public TypeProjection get(KotlinType key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return null;
                }

                public KotlinType prepareTopLevelType(KotlinType topLevelType, Variance position) {
                    Intrinsics.checkNotNullParameter(topLevelType, "topLevelType");
                    Intrinsics.checkNotNullParameter((Object)((Object)position), "position");
                    KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(topLevelType);
                    if (kotlinType == null) {
                        kotlinType = topLevelType;
                    }
                    return kotlinType;
                }
            }));
            if (functionDescriptor == null) {
                functionDescriptor = unwrappedOverridden2 = (FunctionDescriptor)callableMemberDescriptor;
            }
            if (!((Collection)relatedTypeParameters).isEmpty()) {
                context.getTrace().report(ErrorsJvm.WRONG_TYPE_PARAMETER_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration), (TypeParameterDescriptor)kotlin.collections.CollectionsKt.first(relatedTypeParameters)));
                break;
            }
            context.getTrace().report(ErrorsJvm.WRONG_NULLABILITY_FOR_JAVA_OVERRIDE.on((KtModifierListOwner)((PsiElement)declaration), (CallableMemberDescriptor)descriptor, unwrappedOverridden2));
            break;
        }
    }

    private static final Boolean check$lambda$1(Set $relatedTypeParameters, KotlinType subtype, KotlinType supertype) {
        boolean bl;
        Intrinsics.checkNotNull(subtype);
        Intrinsics.checkNotNull(supertype);
        boolean it = bl = JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter(subtype, supertype);
        boolean bl2 = false;
        if (it) {
            ClassifierDescriptor classifierDescriptor = subtype.getConstructor().getDeclarationDescriptor();
            CollectionsKt.addIfNotNull($relatedTypeParameters, classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
        }
        return !bl;
    }
}

