/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TerminalCommandHistoryManager", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public final class TerminalCommandHistoryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(TerminalCommandHistoryManager.class);
    private static final AtomicBoolean PRUNE_SCHEDULED = new AtomicBoolean(false);
    private final Map<String, CommandHistoryFileInfo> myMap = new ConcurrentHashMap<String, CommandHistoryFileInfo>();

    @Nullable
    public Path getOrCreateCommandHistoryFile(@Nullable String commandHistoryFileName, @NotNull Project project) {
        CommandHistoryFileInfo info;
        Path historyDir;
        if (project == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(0);
        }
        if ((historyDir = TerminalCommandHistoryManager.getCommandHistoryDir()) == null) {
            return null;
        }
        String projectPath = Objects.requireNonNull(project.getBasePath());
        if (commandHistoryFileName != null && (info = this.myMap.get(commandHistoryFileName)) != null && projectPath.equals(info.myProjectPath)) {
            Path path = historyDir.resolve(commandHistoryFileName);
            if (Files.exists(path, new LinkOption[0])) {
                info.myAccessTime = TerminalCommandHistoryManager.now();
                return path;
            }
            this.myMap.remove(commandHistoryFileName);
        }
        try {
            File tmpFile = FileUtil.createTempFile((File)historyDir.toFile(), (String)(project.getName() + "-history"), null, (boolean)true, (boolean)false);
            Path filePath = tmpFile.toPath();
            String filename = TerminalCommandHistoryManager.getFilename(filePath);
            this.myMap.put(filename, TerminalCommandHistoryManager.createFileInfo(filename, projectPath));
            return filePath;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static CommandHistoryFileInfo createFileInfo(@NotNull String filename, @NotNull String projectPath) {
        if (filename == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(2);
        }
        CommandHistoryFileInfo info = new CommandHistoryFileInfo();
        info.myFilename = filename;
        info.myProjectPath = projectPath;
        info.myAccessTime = TerminalCommandHistoryManager.now();
        CommandHistoryFileInfo commandHistoryFileInfo = info;
        if (commandHistoryFileInfo == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(3);
        }
        return commandHistoryFileInfo;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    @Nullable
    private static Path getCommandHistoryDir() {
        Path dir = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("terminal/history");
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return dir;
        }
        if (Files.exists(dir, new LinkOption[0])) {
            LOG.warn("Not a directory " + String.valueOf(dir));
            return null;
        }
        TerminalCommandHistoryManager.deleteOldHistoryDir();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            return dir;
        }
        catch (IOException e) {
            LOG.warn("Cannot create " + String.valueOf(dir), (Throwable)e);
            return null;
        }
    }

    private static void deleteOldHistoryDir() {
        Path parentDir;
        Path dir = PathManager.getConfigDir().resolve("terminal/history");
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try {
                FileUtil.delete((Path)dir);
                LOG.info("Old config/terminal/history/ deleted: " + String.valueOf(dir));
            }
            catch (IOException e) {
                LOG.warn("Cannot delete old terminal/history/", (Throwable)e);
            }
        }
        if (!Files.isDirectory(parentDir = dir.getParent(), new LinkOption[0])) {
            LOG.info("Old terminal/ directory does not exist or not a directory: " + String.valueOf(parentDir));
            return;
        }
        boolean empty = false;
        try (Stream<Path> s = Files.list(parentDir);){
            empty = s.findAny().isEmpty();
        }
        catch (IOException e) {
            LOG.warn("Cannot list files in " + String.valueOf(parentDir), (Throwable)e);
        }
        if (empty) {
            try {
                FileUtil.delete((Path)parentDir);
                LOG.info("Old terminal/ deleted: " + String.valueOf(dir));
            }
            catch (IOException e) {
                LOG.warn("Cannot delete old terminal/", (Throwable)e);
            }
        }
    }

    public void retainCommandHistoryFiles(@NotNull List<String> historyFileNamesToKeep, @NotNull Project project) {
        if (historyFileNamesToKeep == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(5);
        }
        String projectPath = Objects.requireNonNull(project.getBasePath());
        ArrayList<String> toRemove = new ArrayList<String>();
        for (CommandHistoryFileInfo info : this.myMap.values()) {
            if (!projectPath.equals(info.myProjectPath) || historyFileNamesToKeep.contains(info.myFilename)) continue;
            toRemove.add(info.myFilename);
        }
        this.deleteHistoryFiles(toRemove, "closed sessions");
    }

    private void deleteHistoryFiles(@NotNull List<String> historyFileNamesToRemove, @NotNull String reason) {
        Path historyDir;
        if (historyFileNamesToRemove == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(6);
        }
        if (reason == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(7);
        }
        Path path = historyDir = historyFileNamesToRemove.isEmpty() ? null : TerminalCommandHistoryManager.getCommandHistoryDir();
        if (historyDir == null) {
            return;
        }
        LOG.info("Deleting " + String.valueOf(historyFileNamesToRemove) + " (" + reason + ")");
        for (String historyFileName : historyFileNamesToRemove) {
            this.myMap.remove(historyFileName);
            Path file = historyDir.resolve(historyFileName);
            if (!Files.exists(file, new LinkOption[0])) continue;
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                LOG.warn("Cannot delete " + historyFileName, (Throwable)e);
            }
        }
    }

    @NotNull
    public State getState() {
        State state = new State();
        state.myHistoryFileInfoList = (List)ContainerUtil.nullize(new ArrayList<CommandHistoryFileInfo>(this.myMap.values()));
        State state2 = state;
        if (state2 == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(8);
        }
        return state2;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(9);
        }
        this.myMap.clear();
        for (CommandHistoryFileInfo info : state.myHistoryFileInfoList) {
            this.myMap.put(info.myFilename, info);
        }
    }

    @NotNull
    public static TerminalCommandHistoryManager getInstance() {
        if (PRUNE_SCHEDULED.compareAndSet(false, true)) {
            JobScheduler.getScheduler().schedule(() -> TerminalCommandHistoryManager.pruneOutdated(), 4L, TimeUnit.MINUTES);
        }
        TerminalCommandHistoryManager terminalCommandHistoryManager = (TerminalCommandHistoryManager)ApplicationManager.getApplication().getService(TerminalCommandHistoryManager.class);
        if (terminalCommandHistoryManager == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(10);
        }
        return terminalCommandHistoryManager;
    }

    private static void pruneOutdated() {
        Path historyDir = TerminalCommandHistoryManager.getCommandHistoryDir();
        if (historyDir != null) {
            try (Stream<Path> s = Files.list(historyDir);){
                TerminalCommandHistoryManager.getInstance().doPruneOutdated(s.collect(Collectors.toList()));
            }
            catch (IOException e) {
                LOG.warn("Cannot list files in " + String.valueOf(historyDir), (Throwable)e);
            }
        }
    }

    private void doPruneOutdated(@NotNull List<Path> existingHistoryFiles) {
        if (existingHistoryFiles == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(11);
        }
        Set existingHistoryFilenames = ContainerUtil.map2Set(existingHistoryFiles, TerminalCommandHistoryManager::getFilename);
        long allowed = TerminalCommandHistoryManager.now() - TimeUnit.DAYS.toMillis(30L);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (CommandHistoryFileInfo info : this.myMap.values()) {
            if (info.myAccessTime > allowed && existingHistoryFilenames.contains(info.myFilename)) continue;
            toRemove.add(info.myFilename);
        }
        for (String filename : existingHistoryFilenames) {
            if (this.myMap.containsKey(filename)) continue;
            toRemove.add(filename);
        }
        this.deleteHistoryFiles(toRemove, "outdated sessions");
    }

    @NotNull
    private static String getFilename(@NotNull Path path) {
        if (path == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(12);
        }
        String string = PathUtil.getFileName((String)path.toString());
        if (string == null) {
            TerminalCommandHistoryManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static String getFilename(@Nullable String path) {
        return path == null ? null : PathUtil.getFileName((String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/arrangement/TerminalCommandHistoryManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyFileNamesToKeep";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyFileNamesToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingHistoryFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/arrangement/TerminalCommandHistoryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCommandHistoryFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "retainCommandHistoryFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteHistoryFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doPruneOutdated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 10, 13 -> new IllegalStateException(string);
        };
    }

    @Tag(value="command-history-file")
    public static final class CommandHistoryFileInfo {
        @Attribute(value="filename")
        private volatile String myFilename;
        @Attribute(value="project-path")
        private String myProjectPath;
        @Attribute(value="last-access-time")
        private volatile long myAccessTime;
    }

    public static final class State {
        @XCollection(propertyElementName="command-history-files")
        private List<CommandHistoryFileInfo> myHistoryFileInfoList;
    }
}

