/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.routing.PathSegmentConstantRouteSelector;
import io.ktor.server.routing.PathSegmentOptionalParameterRouteSelector;
import io.ktor.server.routing.PathSegmentParameterRouteSelector;
import io.ktor.server.routing.PathSegmentTailcardRouteSelector;
import io.ktor.server.routing.PathSegmentWildcardRouteSelector;
import io.ktor.server.routing.RouteSelector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/routing/PathSegmentSelectorBuilder;", "", "<init>", "()V", "", "value", "Lio/ktor/server/routing/RouteSelector;", "parseParameter", "(Ljava/lang/String;)Lio/ktor/server/routing/RouteSelector;", "parseConstant", "parseName", "(Ljava/lang/String;)Ljava/lang/String;", "ktor-server-core"})
public final class PathSegmentSelectorBuilder {
    @NotNull
    public static final PathSegmentSelectorBuilder INSTANCE = new PathSegmentSelectorBuilder();

    private PathSegmentSelectorBuilder() {
    }

    @NotNull
    public final RouteSelector parseParameter(@NotNull String value) {
        RouteSelector routeSelector;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int prefixIndex = StringsKt.indexOf$default((CharSequence)value, (char)'{', (int)0, (boolean)false, (int)6, null);
        int suffixIndex = StringsKt.lastIndexOf$default((CharSequence)value, (char)'}', (int)0, (boolean)false, (int)6, null);
        if (prefixIndex == 0) {
            string2 = null;
        } else {
            String string3 = value.substring(0, prefixIndex);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String prefix = string2;
        if (suffixIndex == value.length() - 1) {
            string = null;
        } else {
            String string4 = value.substring(suffixIndex + 1);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        String suffix = string;
        String string5 = value.substring(prefixIndex + 1, suffixIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String signature = string5;
        if (StringsKt.endsWith$default((String)signature, (String)"?", (boolean)false, (int)2, null)) {
            routeSelector = new PathSegmentOptionalParameterRouteSelector(StringsKt.dropLast((String)signature, (int)1), prefix, suffix);
        } else if (StringsKt.endsWith$default((String)signature, (String)"...", (boolean)false, (int)2, null)) {
            CharSequence charSequence = suffix;
            if (!(charSequence == null || charSequence.length() == 0)) {
                throw new IllegalArgumentException("Suffix after tailcard is not supported");
            }
            String string6 = StringsKt.dropLast((String)signature, (int)3);
            String string7 = prefix;
            if (string7 == null) {
                string7 = "";
            }
            routeSelector = new PathSegmentTailcardRouteSelector(string6, string7);
        } else {
            routeSelector = new PathSegmentParameterRouteSelector(signature, prefix, suffix);
        }
        return routeSelector;
    }

    @NotNull
    public final RouteSelector parseConstant(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)value, (Object)"*") ? (RouteSelector)PathSegmentWildcardRouteSelector.INSTANCE : (RouteSelector)new PathSegmentConstantRouteSelector(value);
    }

    @NotNull
    public final String parseName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String prefix = StringsKt.substringBefore((String)value, (char)'{', (String)"");
        String suffix = StringsKt.substringAfterLast((String)value, (char)'}', (String)"");
        String string = value.substring(prefix.length() + 1, value.length() - suffix.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String signature = string;
        return StringsKt.endsWith$default((String)signature, (String)"?", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)signature, (int)1) : (StringsKt.endsWith$default((String)signature, (String)"...", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)signature, (int)3) : signature);
    }
}

