/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModelWithInjections;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridListModel
extends GridListModelBase<GridRow, GridColumn>
implements GridModelWithInjections<GridRow, GridColumn> {
    private final BiFunction<Object, Object, Boolean> myValuesEquals;

    public DataGridListModel(@NotNull BiFunction<Object, Object, Boolean> valuesEquals) {
        if (valuesEquals == null) {
            DataGridListModel.$$$reportNull$$$0(0);
        }
        this.myValuesEquals = valuesEquals;
    }

    @Override
    @Nullable
    protected Object getValueAt(@NotNull GridRow row, @NotNull GridColumn column) {
        if (row == null) {
            DataGridListModel.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DataGridListModel.$$$reportNull$$$0(2);
        }
        return column.getValue(row);
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<GridRow> rowIndices, @NotNull ModelIndexSet<GridColumn> columnIndices, @Nullable Object what) {
        if (rowIndices == null) {
            DataGridListModel.$$$reportNull$$$0(3);
        }
        if (columnIndices == null) {
            DataGridListModel.$$$reportNull$$$0(4);
        }
        for (ModelIndex rowIdx : rowIndices.asIterable()) {
            for (ModelIndex colIdx : columnIndices.asIterable()) {
                if (GridUtilCore.isRowId((GridColumn)this.getColumn(colIdx)) || this.myValuesEquals.apply(what, ((GridListModelBase)this).getValueAt(rowIdx, colIdx)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            DataGridListModel.$$$reportNull$$$0(5);
        }
        for (CellMutation mutation : mutations) {
            ModelIndex<GridRow> row = mutation.getRow();
            ModelIndex<GridColumn> column = mutation.getColumn();
            Object value = mutation.getValue();
            Object oldValue = ((GridListModelBase)this).getValueAt(row, column);
            if (GridUtilCore.isRowId(this.getColumn(column)) || this.myValuesEquals.apply(value, oldValue).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void injectValue(@NotNull ModelIndex<GridRow> rowIndex, @NotNull ModelIndex<GridColumn> columnIndex, @NotNull Object value) {
        GridRow row;
        if (rowIndex == null) {
            DataGridListModel.$$$reportNull$$$0(6);
        }
        if (columnIndex == null) {
            DataGridListModel.$$$reportNull$$$0(7);
        }
        if (value == null) {
            DataGridListModel.$$$reportNull$$$0(8);
        }
        if ((row = this.getRow(rowIndex)) != null) {
            row.setValue(columnIndex.value, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEquals";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/DataGridListModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAt";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "allValuesEqualTo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "injectValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

