/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelAction;

import com.intellij.gradle.toolingExtension.impl.model.utilTurnOffDefaultTasksModel.TurnOffDefaultTasks;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleDaemonModelHolder;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelHolderState;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.ToolingSerializerConverter;
import com.intellij.gradle.toolingExtension.impl.telemetry.GradleOpenTelemetry;
import com.intellij.gradle.toolingExtension.impl.util.GradleExecutorServiceUtil;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.util.ReflectionUtilRt;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

@ApiStatus.Internal
public class GradleModelFetchAction
implements BuildAction<GradleModelHolderState>,
Serializable {
    @NotNull
    private final String myGradleVersion;
    private final NavigableSet<GradleModelFetchPhase> myModelFetchPhases;
    private final Map<GradleModelFetchPhase, Set<ProjectImportModelProvider>> myModelProviders;
    private final Set<Class<?>> myTargetTypes;
    private boolean myUseProjectsLoadedPhase;
    private boolean myUseStreamedValues;
    private transient boolean myProjectLoadedAction;
    @Nullable
    private transient GradleDaemonModelHolder myModels;

    public GradleModelFetchAction(@NotNull GradleVersion version) {
        if (version == null) {
            GradleModelFetchAction.$$$reportNull$$$0(0);
        }
        this.myModelFetchPhases = new TreeSet<GradleModelFetchPhase>(Arrays.asList(GradleModelFetchPhase.values()));
        this.myModelProviders = new LinkedHashMap<GradleModelFetchPhase, Set<ProjectImportModelProvider>>();
        this.myTargetTypes = new LinkedHashSet();
        this.myUseProjectsLoadedPhase = false;
        this.myUseStreamedValues = false;
        this.myProjectLoadedAction = false;
        this.myModels = null;
        this.myGradleVersion = version.getVersion();
    }

    @NotNull
    private GradleVersion getGradleVersion() {
        GradleVersion gradleVersion = GradleVersion.version((String)this.myGradleVersion);
        if (gradleVersion == null) {
            GradleModelFetchAction.$$$reportNull$$$0(1);
        }
        return gradleVersion;
    }

    public GradleModelFetchAction addProjectImportModelProviders(@NotNull Collection<? extends ProjectImportModelProvider> providers) {
        if (providers == null) {
            GradleModelFetchAction.$$$reportNull$$$0(2);
        }
        for (ProjectImportModelProvider projectImportModelProvider : providers) {
            GradleModelFetchPhase phase = projectImportModelProvider.getPhase();
            Set modelProviders = this.myModelProviders.computeIfAbsent(phase, __ -> new LinkedHashSet());
            modelProviders.add(projectImportModelProvider);
        }
        return this;
    }

    public Set<Class<?>> getModelProvidersClasses() {
        LinkedHashSet result = new LinkedHashSet();
        for (Set<ProjectImportModelProvider> modelProviders : this.myModelProviders.values()) {
            for (ProjectImportModelProvider provider : modelProviders) {
                result.add(provider.getClass());
            }
        }
        return result;
    }

    public void addTargetTypes(@NotNull Set<Class<?>> targetTypes) {
        if (targetTypes == null) {
            GradleModelFetchAction.$$$reportNull$$$0(3);
        }
        this.myTargetTypes.addAll(targetTypes);
    }

    public boolean isUseProjectsLoadedPhase() {
        return this.myUseProjectsLoadedPhase;
    }

    public void setUseProjectsLoadedPhase(boolean useProjectsLoadedPhase) {
        this.myUseProjectsLoadedPhase = useProjectsLoadedPhase;
    }

    public boolean isUseStreamedValues() {
        return this.myUseStreamedValues;
    }

    public void setUseStreamedValues(boolean useStreamedValues) {
        this.myUseStreamedValues = useStreamedValues;
    }

    @NotNull
    public GradleModelHolderState execute(@NotNull BuildController controller) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(4);
        }
        this.configureAdditionalTypes(controller);
        GradleModelHolderState gradleModelHolderState = GradleExecutorServiceUtil.withSingleThreadExecutor("idea-tooling-model-converter", converterExecutor -> GradleModelFetchAction.withOpenTelemetry(telemetry -> telemetry.callWithSpan("ProjectImportAction", __ -> this.doExecute(controller, (ExecutorService)converterExecutor, (GradleOpenTelemetry)telemetry))));
        if (gradleModelHolderState == null) {
            GradleModelFetchAction.$$$reportNull$$$0(5);
        }
        return gradleModelHolderState;
    }

    @NotNull
    private GradleModelHolderState doExecute(@NotNull BuildController controller, @NotNull ExecutorService converterExecutor, @NotNull GradleOpenTelemetry telemetry) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(6);
        }
        if (converterExecutor == null) {
            GradleModelFetchAction.$$$reportNull$$$0(7);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(8);
        }
        boolean bl = this.myProjectLoadedAction = this.myModels == null && this.myUseProjectsLoadedPhase;
        if (this.myProjectLoadedAction || !this.myUseProjectsLoadedPhase) {
            this.myModels = telemetry.callWithSpan("InitAction", __ -> GradleModelFetchAction.initAction(controller, converterExecutor, telemetry, this.getGradleVersion()));
        }
        assert (this.myModels != null);
        telemetry.runWithSpan("ExecuteAction", __ -> this.executeAction(controller, converterExecutor, telemetry, this.myModels));
        if (this.myProjectLoadedAction) {
            telemetry.runWithSpan("TurnOffDefaultTasks", __ -> controller.getModel(TurnOffDefaultTasks.class));
        }
        GradleModelHolderState gradleModelHolderState = this.myModels.pollPendingState();
        if (gradleModelHolderState == null) {
            GradleModelFetchAction.$$$reportNull$$$0(9);
        }
        return gradleModelHolderState;
    }

    private void configureAdditionalTypes(BuildController controller) {
        if (this.myTargetTypes.isEmpty()) {
            return;
        }
        try {
            ProtocolToModelAdapter modelAdapter = (ProtocolToModelAdapter)ReflectionUtilRt.getField(controller.getClass(), (Object)controller, ProtocolToModelAdapter.class, (String)"adapter");
            if (modelAdapter == null) {
                return;
            }
            TargetTypeProvider typeProvider = (TargetTypeProvider)ReflectionUtilRt.getField(ProtocolToModelAdapter.class, (Object)modelAdapter, TargetTypeProvider.class, (String)"targetTypeProvider");
            if (typeProvider == null) {
                return;
            }
            Map targetTypes = (Map)ReflectionUtilRt.getField(typeProvider.getClass(), (Object)typeProvider, Map.class, (String)"configuredTargetTypes");
            if (targetTypes == null) {
                return;
            }
            for (Class<?> targetType : this.myTargetTypes) {
                targetTypes.put(targetType.getCanonicalName(), targetType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private static GradleDaemonModelHolder initAction(@NotNull BuildController controller, @NotNull ExecutorService converterExecutor, @NotNull GradleOpenTelemetry telemetry, @NotNull GradleVersion gradleVersion) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(10);
        }
        if (converterExecutor == null) {
            GradleModelFetchAction.$$$reportNull$$$0(11);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(12);
        }
        if (gradleVersion == null) {
            GradleModelFetchAction.$$$reportNull$$$0(13);
        }
        GradleBuild mainGradleBuild = telemetry.callWithSpan("GetMainGradleBuild", __ -> controller.getBuildModel());
        Collection nestedGradleBuilds = telemetry.callWithSpan("GetNestedGradleBuilds", __ -> GradleModelFetchAction.getNestedBuilds(mainGradleBuild, gradleVersion));
        ToolingSerializerConverter serializer = telemetry.callWithSpan("GetToolingModelConverter", __ -> new ToolingSerializerConverter(controller, telemetry));
        GradleDaemonModelHolder gradleDaemonModelHolder = telemetry.callWithSpan("InitModelConsumer", __ -> new GradleDaemonModelHolder(converterExecutor, serializer, mainGradleBuild, nestedGradleBuilds, gradleVersion));
        if (gradleDaemonModelHolder == null) {
            GradleModelFetchAction.$$$reportNull$$$0(14);
        }
        return gradleDaemonModelHolder;
    }

    private static Collection<? extends GradleBuild> getNestedBuilds(@NotNull GradleBuild build, @NotNull GradleVersion gradleVersion) {
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(15);
        }
        if (gradleVersion == null) {
            GradleModelFetchAction.$$$reportNull$$$0(16);
        }
        HashSet<String> processedBuildsPaths = new HashSet<String>();
        LinkedHashSet<GradleBuild> nestedBuilds = new LinkedHashSet<GradleBuild>();
        String rootBuildPath = build.getBuildIdentifier().getRootDir().getPath();
        processedBuildsPaths.add(rootBuildPath);
        ArrayDeque<? extends GradleBuild> queue = new ArrayDeque<GradleBuild>((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(build, gradleVersion));
        while (!queue.isEmpty()) {
            GradleBuild includedBuild = (GradleBuild)queue.remove();
            String includedBuildPath = includedBuild.getBuildIdentifier().getRootDir().getPath();
            if (!processedBuildsPaths.add(includedBuildPath)) continue;
            nestedBuilds.add(includedBuild);
            queue.addAll((Collection<? extends GradleBuild>)GradleModelFetchAction.getEditableBuilds(includedBuild, gradleVersion));
        }
        return nestedBuilds;
    }

    private static DomainObjectSet<? extends GradleBuild> getEditableBuilds(@NotNull GradleBuild build, @NotNull GradleVersion version) {
        if (build == null) {
            GradleModelFetchAction.$$$reportNull$$$0(17);
        }
        if (version == null) {
            GradleModelFetchAction.$$$reportNull$$$0(18);
        }
        if (GradleVersionUtil.isGradleOlderThan((GradleVersion)version, (String)"8.0")) {
            return build.getIncludedBuilds();
        }
        DomainObjectSet builds = build.getEditableBuilds();
        if (builds.isEmpty()) {
            return build.getIncludedBuilds();
        }
        return builds;
    }

    private void executeAction(@NotNull BuildController controller, @NotNull ExecutorService converterExecutor, @NotNull GradleOpenTelemetry telemetry, @NotNull GradleDaemonModelHolder models) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(19);
        }
        if (converterExecutor == null) {
            GradleModelFetchAction.$$$reportNull$$$0(20);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(21);
        }
        if (models == null) {
            GradleModelFetchAction.$$$reportNull$$$0(22);
        }
        BuildController buildController = models.createBuildController(controller);
        ProjectImportModelProvider.GradleModelConsumer modelConsumer = models.createModelConsumer(converterExecutor);
        Collection<? extends GradleBuild> gradleBuilds = models.getGradleBuilds();
        try {
            this.getModelFetchPhases().forEach(phase -> telemetry.runWithSpan(phase.name(), __ -> {
                Set<ProjectImportModelProvider> modelProviders = this.myModelProviders.getOrDefault(phase, Collections.emptySet());
                GradleModelFetchAction.populateModels(buildController, telemetry, modelConsumer, gradleBuilds, modelProviders);
                this.sendPendingState(buildController, telemetry, models, (GradleModelFetchPhase)phase);
            }));
        }
        catch (Exception e) {
            throw new ExternalSystemException((Throwable)e);
        }
    }

    private static void populateModels(@NotNull BuildController controller, @NotNull GradleOpenTelemetry telemetry, @NotNull ProjectImportModelProvider.GradleModelConsumer modelConsumer, @NotNull Collection<? extends GradleBuild> gradleBuilds, @NotNull Collection<ProjectImportModelProvider> modelProviders) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(23);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(24);
        }
        if (modelConsumer == null) {
            GradleModelFetchAction.$$$reportNull$$$0(25);
        }
        if (gradleBuilds == null) {
            GradleModelFetchAction.$$$reportNull$$$0(26);
        }
        if (modelProviders == null) {
            GradleModelFetchAction.$$$reportNull$$$0(27);
        }
        for (ProjectImportModelProvider modelProvider : modelProviders) {
            telemetry.runWithSpan(modelProvider.getName(), __ -> modelProvider.populateModels(controller, gradleBuilds, modelConsumer));
        }
    }

    private void sendPendingState(@NotNull BuildController controller, @NotNull GradleOpenTelemetry telemetry, @NotNull GradleDaemonModelHolder models, @NotNull GradleModelFetchPhase phase) {
        if (controller == null) {
            GradleModelFetchAction.$$$reportNull$$$0(28);
        }
        if (telemetry == null) {
            GradleModelFetchAction.$$$reportNull$$$0(29);
        }
        if (models == null) {
            GradleModelFetchAction.$$$reportNull$$$0(30);
        }
        if (phase == null) {
            GradleModelFetchAction.$$$reportNull$$$0(31);
        }
        telemetry.runWithSpan("SendPendingState", span -> {
            span.setAttribute("use-streamed-values", this.myUseStreamedValues);
            if (this.myUseStreamedValues) {
                GradleModelHolderState state = models.pollPendingState();
                GradleModelHolderState phasedState = state.withPhase(phase);
                controller.send((Object)phasedState);
            }
        });
    }

    @NotNull
    private SortedSet<GradleModelFetchPhase> getModelFetchPhases() {
        if (!this.myUseProjectsLoadedPhase) {
            NavigableSet<GradleModelFetchPhase> navigableSet = this.myModelFetchPhases;
            if (navigableSet == null) {
                GradleModelFetchAction.$$$reportNull$$$0(32);
            }
            return navigableSet;
        }
        if (this.myProjectLoadedAction) {
            SortedSet<GradleModelFetchPhase> sortedSet = this.getProjectLoadedModelFetchPhases();
            if (sortedSet == null) {
                GradleModelFetchAction.$$$reportNull$$$0(33);
            }
            return sortedSet;
        }
        SortedSet<GradleModelFetchPhase> sortedSet = this.getBuildFinishedModelFetchPhases();
        if (sortedSet == null) {
            GradleModelFetchAction.$$$reportNull$$$0(34);
        }
        return sortedSet;
    }

    @NotNull
    public SortedSet<GradleModelFetchPhase> getProjectLoadedModelFetchPhases() {
        NavigableSet<GradleModelFetchPhase> navigableSet = this.myModelFetchPhases.headSet(GradleModelFetchPhase.PROJECT_LOADED_PHASE, true);
        if (navigableSet == null) {
            GradleModelFetchAction.$$$reportNull$$$0(35);
        }
        return navigableSet;
    }

    @NotNull
    public SortedSet<GradleModelFetchPhase> getBuildFinishedModelFetchPhases() {
        NavigableSet<GradleModelFetchPhase> navigableSet = this.myModelFetchPhases.tailSet(GradleModelFetchPhase.PROJECT_LOADED_PHASE, false);
        if (navigableSet == null) {
            GradleModelFetchAction.$$$reportNull$$$0(36);
        }
        return navigableSet;
    }

    @NotNull
    private static GradleModelHolderState withOpenTelemetry(@NotNull Function<GradleOpenTelemetry, GradleModelHolderState> action) {
        GradleModelHolderState gradleModelHolderState;
        if (action == null) {
            GradleModelFetchAction.$$$reportNull$$$0(37);
        }
        GradleOpenTelemetry telemetry = new GradleOpenTelemetry();
        try {
            gradleModelHolderState = action.apply(telemetry);
        }
        catch (Throwable exception) {
            telemetry.shutdown();
            throw exception;
        }
        if (gradleModelHolderState == null) {
            GradleModelFetchAction.$$$reportNull$$$0(38);
        }
        return gradleModelHolderState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelFetchAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 7: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterExecutor";
                break;
            }
            case 8: 
            case 12: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuilds";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProviders";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelFetchAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initAction";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelFetchPhases";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLoadedModelFetchPhases";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFinishedModelFetchPhases";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "withOpenTelemetry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addProjectImportModelProviders";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTargetTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initAction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNestedBuilds";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEditableBuilds";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "populateModels";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sendPendingState";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "withOpenTelemetry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

