/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "<init>", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createFixes", "", "Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "", "versions", "SetVersionQuickFix", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nDifferentMavenStdlibVersionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DifferentMavenStdlibVersionInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n1563#2:95\n1634#2,3:96\n774#2:99\n865#2,2:100\n1869#2:102\n1870#2:107\n774#2:108\n865#2,2:109\n1869#2:111\n1870#2:116\n1999#2,14:117\n774#2:131\n865#2,2:132\n1563#2:134\n1634#2,3:135\n1563#2:138\n1634#2,3:139\n37#3:103\n36#3,3:104\n37#3:112\n36#3,3:113\n*S KotlinDebug\n*F\n+ 1 DifferentMavenStdlibVersionInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection\n*L\n31#1:95\n31#1:96,3\n39#1:99\n39#1:100,2\n39#1:102\n39#1:107\n53#1:108\n53#1:109,2\n54#1:111\n54#1:116\n69#1:117,14\n74#1:131\n74#1:132,2\n74#1:134\n74#1:135,3\n76#1:138\n76#1:139,3\n48#1:103\n48#1:104,3\n63#1:112\n63#1:113,3\n*E\n"})
public final class DifferentMavenStdlibVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public DifferentMavenStdlibVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        Iterable $this$forEach$iv;
        Iterable $this$filterTo$iv$iv;
        String pluginVersion;
        Iterator it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile file = xmlFile;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        MavenProject project = mavenProject;
        Iterable $this$map$iv = project.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVersion());
        }
        List stdlibVersion = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        MavenPlugin mavenPlugin = MavenProject.findPlugin$default((MavenProject)project, (String)"org.jetbrains.kotlin", (String)"kotlin-maven-plugin", (boolean)false, (int)4, null);
        String string = pluginVersion = mavenPlugin != null ? mavenPlugin.getVersion() : null;
        if (pluginVersion == null || stdlibVersion.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)stdlibVersion), (Object)pluginVersion)) {
            return;
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull(file);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        Iterable $this$filter$iv = pomFile2.findKotlinPlugins();
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        it = $this$filterTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            MavenDomPlugin it2 = (MavenDomPlugin)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it2.getVersion().getStringValue(), (Object)CollectionsKt.singleOrNull((List)stdlibVersion)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            MavenDomPlugin plugin;
            block17: {
                block16: {
                    plugin = (MavenDomPlugin)element$iv;
                    boolean bl = false;
                    object = plugin.getVersion().getStringValue();
                    if (object == null) break block16;
                    String version = object;
                    boolean bl2 = false;
                    GenericDomValue genericDomValue = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"getVersion(...)");
                    List<SetVersionQuickFix> list2 = this.createFixes(project, (GenericDomValue<String>)genericDomValue, CollectionsKt.plus((Collection)stdlibVersion, (Object)version));
                    object = list2;
                    if (list2 != null) break block17;
                }
                object = CollectionsKt.emptyList();
            }
            List<SetVersionQuickFix> fixes = object;
            DomElement domElement = (DomElement)plugin.getVersion();
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)plugin.getVersion(), (String)"getVersion(...)");
            objectArray[1] = CollectionsKt.joinToString$default((Iterable)stdlibVersion, (CharSequence)",", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
            String string2 = KotlinMavenBundle.message("version.different.plugin.library", objectArray);
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new SetVersionQuickFix[0]);
            holder2.createProblem(domElement, HighlightSeverity.WARNING, string2, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
        $this$forEach$iv = PomFile.findDependencies$default(pomFile2, new MavenId("org.jetbrains.kotlin", "kotlin-stdlib", null), null, 2, null);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            MavenDomDependency it3 = (MavenDomDependency)element$iv$iv;
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual((Object)it3.getVersion().getStringValue(), (Object)pluginVersion))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            MavenDomDependency dependency;
            block19: {
                block18: {
                    dependency = (MavenDomDependency)element$iv;
                    boolean bl4 = false;
                    object = dependency.getVersion().getStringValue();
                    if (object == null) break block18;
                    String version = object;
                    boolean bl5 = false;
                    GenericDomValue genericDomValue = dependency.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"getVersion(...)");
                    Object[] objectArray = new String[]{version, pluginVersion};
                    List<SetVersionQuickFix> list3 = this.createFixes(project, (GenericDomValue<String>)genericDomValue, CollectionsKt.listOf((Object[])objectArray));
                    object = list3;
                    if (list3 != null) break block19;
                }
                object = CollectionsKt.emptyList();
            }
            List<SetVersionQuickFix> fixes = object;
            DomElement domElement = (DomElement)dependency.getVersion();
            Object[] objectArray = new Object[2];
            objectArray[0] = pluginVersion;
            Intrinsics.checkNotNullExpressionValue((Object)dependency.getVersion(), (String)"getVersion(...)");
            String string3 = KotlinMavenBundle.message("version.different.plugin.library", objectArray);
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new SetVersionQuickFix[0]);
            holder2.createProblem(domElement, HighlightSeverity.WARNING, string3, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SetVersionQuickFix> createFixes(MavenProject project, GenericDomValue<String> versionElement, List<String> versions) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Object maxElem$iv;
        Object v0;
        Iterable $this$maxByOrNull$iv = versions;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                String p0 = (String)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)new MavenVersionComparable(p0);
                do {
                    Object e$iv = iterator$iv.next();
                    String p02 = (String)e$iv;
                    $i$a$-maxByOrNull-DifferentMavenStdlibVersionInspection$createFixes$bestVersion$1 = false;
                    Comparable v$iv = (Comparable)new MavenVersionComparable(p02);
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        String bestVersion = v0;
        if (Intrinsics.areEqual((Object)bestVersion, (Object)versionElement.getStringValue())) {
            return CollectionsKt.emptyList();
        }
        Set<Map.Entry<Object, Object>> set = project.getProperties().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        maxElem$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)bestVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("${" + it.getKey() + "}");
        }
        List properties = (List)destination$iv$iv;
        $this$map$iv = properties;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SetVersionQuickFix(versionElement, (String)it, bestVersion));
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new SetVersionQuickFix(versionElement, bestVersion, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "", "newVersion", "versionResolved", "<init>", "(Lcom/intellij/util/xml/GenericDomValue;Ljava/lang/String;Ljava/lang/String;)V", "getVersionElement", "()Lcom/intellij/util/xml/GenericDomValue;", "getNewVersion", "()Ljava/lang/String;", "getVersionResolved", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.maven"})
    private static final class SetVersionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final GenericDomValue<String> versionElement;
        @NotNull
        private final String newVersion;
        @Nullable
        private final String versionResolved;

        public SetVersionQuickFix(@NotNull GenericDomValue<String> versionElement, @NotNull String newVersion, @Nullable String versionResolved) {
            Intrinsics.checkNotNullParameter(versionElement, (String)"versionElement");
            Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
            this.versionElement = versionElement;
            this.newVersion = newVersion;
            this.versionResolved = versionResolved;
        }

        @NotNull
        public final GenericDomValue<String> getVersionElement() {
            return this.versionElement;
        }

        @NotNull
        public final String getNewVersion() {
            return this.newVersion;
        }

        @Nullable
        public final String getVersionResolved() {
            return this.versionResolved;
        }

        @NotNull
        public String getName() {
            String string;
            if (this.versionResolved == null) {
                Object[] objectArray = new Object[]{this.newVersion};
                string = KotlinMavenBundle.message("fix.set.version.name", objectArray);
            } else {
                Object[] objectArray = new Object[]{this.newVersion, this.versionResolved};
                string = KotlinMavenBundle.message("fix.set.version.name1", objectArray);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.set.version.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.versionElement.setValue((Object)this.newVersion);
        }
    }
}

