/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryBridgesKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceScope;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@K1ModeProjectStructureApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\b\u0010.\u001a\u00020\u000bH\u0016J\t\u0010/\u001a\u00020\u0004H\u00c6\u0003J\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\u0011\u00102\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c2\u0003J\u0011\u00103\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u00c2\u0003JK\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u00c6\u0001J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibrarySourceInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "binariesModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "topPackageNames", "", "", "entriesVirtualFileSystems", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;Ljava/util/Set;Ljava/util/Set;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "getBinariesModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "source", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getSource", "()Lcom/intellij/platform/workspace/storage/EntitySource;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "displayedName", "getDisplayedName", "()Ljava/lang/String;", "sourceScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "modulesWhoseInternalsAreVisible", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "kotlin.base.project-structure"})
public final class LibrarySourceInfo
implements IdeaModuleInfo,
SourceForBinaryModuleInfo {
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;
    @NotNull
    private final BinaryModuleInfo binariesModuleInfo;
    @Nullable
    private final Set<String> topPackageNames;
    @Nullable
    private final Set<NewVirtualFileSystem> entriesVirtualFileSystems;
    @Nullable
    private final EntitySource source;
    @NotNull
    private final Name name;

    public LibrarySourceInfo(@NotNull Project project, @NotNull Library library, @NotNull BinaryModuleInfo binariesModuleInfo, @Nullable Set<String> topPackageNames, @Nullable Set<? extends NewVirtualFileSystem> entriesVirtualFileSystems) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        this.project = project;
        this.library = library;
        this.binariesModuleInfo = binariesModuleInfo;
        this.topPackageNames = topPackageNames;
        this.entriesVirtualFileSystems = entriesVirtualFileSystems;
        LibraryEntity libraryEntity = LibraryBridgesKt.findLibraryEntity((Library)this.library, (EntityStorage)((EntityStorage)WorkspaceModelKt.getWorkspaceModel((Project)this.getProject()).getCurrentSnapshot()));
        this.source = libraryEntity != null ? libraryEntity.getEntitySource() : null;
        Name name2 = Name.special((String)("<sources for library " + this.library.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        this.name = name2;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public BinaryModuleInfo getBinariesModuleInfo() {
        return this.binariesModuleInfo;
    }

    @Nullable
    public final EntitySource getSource() {
        return this.source;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.library.getPresentableName(), (String)"getPresentableName(...)");
        return KotlinBaseProjectStructureBundle.message("sources.for.library.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope sourceScope() {
        return KotlinSourceFilterScope.Companion.librarySources((GlobalSearchScope)new LibrarySourceScope(this.getProject(), null, this.entriesVirtualFileSystems, this.library), this.getProject());
    }

    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return LibraryInfoCache.Companion.getInstance(this.getProject()).get(this.library);
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.getBinariesModuleInfo().getPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getBinariesModuleInfo().getAnalyzerServices();
    }

    @NotNull
    public String toString() {
        return "LibrarySourceInfo(libraryName=" + this.library.getName() + ")";
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Library component2() {
        return this.library;
    }

    @NotNull
    public final BinaryModuleInfo component3() {
        return this.binariesModuleInfo;
    }

    private final Set<String> component4() {
        return this.topPackageNames;
    }

    private final Set<NewVirtualFileSystem> component5() {
        return this.entriesVirtualFileSystems;
    }

    @NotNull
    public final LibrarySourceInfo copy(@NotNull Project project, @NotNull Library library, @NotNull BinaryModuleInfo binariesModuleInfo, @Nullable Set<String> topPackageNames, @Nullable Set<? extends NewVirtualFileSystem> entriesVirtualFileSystems) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        return new LibrarySourceInfo(project, library, binariesModuleInfo, topPackageNames, entriesVirtualFileSystems);
    }

    public static /* synthetic */ LibrarySourceInfo copy$default(LibrarySourceInfo librarySourceInfo, Project project, Library library, BinaryModuleInfo binaryModuleInfo, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            project = librarySourceInfo.project;
        }
        if ((n & 2) != 0) {
            library = librarySourceInfo.library;
        }
        if ((n & 4) != 0) {
            binaryModuleInfo = librarySourceInfo.binariesModuleInfo;
        }
        if ((n & 8) != 0) {
            set = librarySourceInfo.topPackageNames;
        }
        if ((n & 0x10) != 0) {
            set2 = librarySourceInfo.entriesVirtualFileSystems;
        }
        return librarySourceInfo.copy(project, library, binaryModuleInfo, set, set2);
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.library.hashCode();
        result2 = result2 * 31 + this.binariesModuleInfo.hashCode();
        result2 = result2 * 31 + (this.topPackageNames == null ? 0 : ((Object)this.topPackageNames).hashCode());
        result2 = result2 * 31 + (this.entriesVirtualFileSystems == null ? 0 : ((Object)this.entriesVirtualFileSystems).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibrarySourceInfo)) {
            return false;
        }
        LibrarySourceInfo librarySourceInfo = (LibrarySourceInfo)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)librarySourceInfo.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.library, (Object)librarySourceInfo.library)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.binariesModuleInfo, (Object)librarySourceInfo.binariesModuleInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.topPackageNames, librarySourceInfo.topPackageNames)) {
            return false;
        }
        return Intrinsics.areEqual(this.entriesVirtualFileSystems, librarySourceInfo.entriesVirtualFileSystems);
    }
}

