/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.scripting.shared.importing.KotlinDslScriptModelResolver;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"scriptConfigurationsNeedToBeUpdatedBalloon", "", "getScriptConfigurationsNeedToBeUpdatedBalloon", "()Z", "runPartialGradleImport", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "getGradleVersion", "", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "kotlin.gradle.scripting.shared"})
@SourceDebugExtension(value={"SMAP\nGradleImportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleImportHelper.kt\norg/jetbrains/kotlin/gradle/scripting/shared/GradleImportHelperKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,103:1\n40#2,3:104\n*S KotlinDebug\n*F\n+ 1 GradleImportHelper.kt\norg/jetbrains/kotlin/gradle/scripting/shared/GradleImportHelperKt\n*L\n100#1:104,3\n*E\n"})
public final class GradleImportHelperKt {
    public static final boolean getScriptConfigurationsNeedToBeUpdatedBalloon() {
        return Registry.Companion.is("kotlin.gradle.scripts.scriptConfigurationsNeedToBeUpdatedFloatingNotification", true);
    }

    public static final void runPartialGradleImport(@NotNull Project project, @NotNull GradleBuildRoot root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.isImportingInProgress()) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)root.getPathPrefix(), (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).withVmOptions("-Dorg.gradle.kotlin.dsl.provider.mode=classpath").projectResolverPolicy((ProjectResolverPolicy)new GradlePartialResolverPolicy(GradleImportHelperKt::runPartialGradleImport$lambda$0)));
    }

    @NotNull
    public static final String getGradleVersion(@NotNull Project project, @NotNull GradleProjectSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        boolean $i$f$service = false;
        Class<GradleInstallationManager> serviceClass$iv = GradleInstallationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)object;
        String string = settings2.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
        Path gradleHome = gradleInstallationManager.getGradleHomePath(project, string);
        String string2 = GradleInstallationManager.Companion.getGradleVersion(gradleHome);
        if (string2 == null) {
            String string3 = GradleVersion.current().getVersion();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
        }
        return string2;
    }

    private static final boolean runPartialGradleImport$lambda$0(GradleProjectResolverExtension it) {
        return it instanceof KotlinDslScriptModelResolver;
    }
}

