/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.ReadForCertificates;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.server.ssl.State;
import org.jetbrains.idea.maven.server.ssl.WaitEndAndExecute;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/server/ssl/ReadNextCertificate;", "Lorg/jetbrains/idea/maven/server/ssl/State;", "machine", "Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "key", "", "len", "toRead", "authType", "", "certificates", "Ljava/util/ArrayList;", "Ljava/security/cert/X509Certificate;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;IIILjava/lang/String;Ljava/util/ArrayList;Ljava/lang/StringBuilder;)V", "getMachine", "()Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "getKey", "()I", "getLen", "getToRead", "getAuthType", "()Ljava/lang/String;", "getCertificates", "()Ljava/util/ArrayList;", "getStringBuilder", "()Ljava/lang/StringBuilder;", "addLine", "text", "intellij.maven"})
public final class ReadNextCertificate
extends State {
    @NotNull
    private final SslDelegateHandlerStateMachine machine;
    private final int key;
    private final int len;
    private final int toRead;
    @NotNull
    private final String authType;
    @NotNull
    private final ArrayList<X509Certificate> certificates;
    @NotNull
    private final StringBuilder stringBuilder;

    public ReadNextCertificate(@NotNull SslDelegateHandlerStateMachine machine, int key, int len, int toRead, @NotNull String authType, @NotNull ArrayList<X509Certificate> certificates, @NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        super(null);
        this.machine = machine;
        this.key = key;
        this.len = len;
        this.toRead = toRead;
        this.authType = authType;
        this.certificates = certificates;
        this.stringBuilder = stringBuilder;
    }

    @NotNull
    public final SslDelegateHandlerStateMachine getMachine() {
        return this.machine;
    }

    public final int getKey() {
        return this.key;
    }

    public final int getLen() {
        return this.len;
    }

    public final int getToRead() {
        return this.toRead;
    }

    @NotNull
    public final String getAuthType() {
        return this.authType;
    }

    @NotNull
    public final ArrayList<X509Certificate> getCertificates() {
        return this.certificates;
    }

    @NotNull
    public final StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    @Override
    @NotNull
    public State addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)text, (Object)"-----END CERTIFICATE-----")) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Intrinsics.checkNotNullExpressionValue((Object)certificateFactory, (String)"getInstance(...)");
            CertificateFactory certificateFactory2 = certificateFactory;
            byte[] byArray = Base64.getMimeDecoder().decode(this.stringBuilder.toString());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] certificateBuffer = byArray;
            Certificate certificate = certificateFactory2.generateCertificate(new ByteArrayInputStream(certificateBuffer));
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate certificate2 = (X509Certificate)certificate;
            this.certificates.add(certificate2);
            if (this.toRead == 1) {
                return new WaitEndAndExecute(this.machine, this.key, this.authType, this.certificates);
            }
            return new ReadForCertificates(this.machine, this.key, this.len, this.toRead - 1, this.authType, this.certificates);
        }
        this.stringBuilder.append(text);
        return this;
    }
}

