/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.AnnotationHint;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.DiamondResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.processors.FindFirstProcessor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ClassProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/FindFirstProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "annotationResolve", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiType;Z)V", "[Lcom/intellij/psi/PsiType;", "result", "element", "state", "Lcom/intellij/psi/ResolveState;", "Companion", "intellij.groovy.psi"})
public class ClassProcessor
extends FindFirstProcessor<GroovyResolveResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement place;
    @Nullable
    private final PsiType[] typeArguments;

    public ClassProcessor(@NotNull String name, @NotNull PsiElement place, @Nullable PsiType[] typeArguments, boolean annotationResolve) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.name = name;
        this.place = place;
        this.typeArguments = typeArguments;
        this.nameHint(this.name);
        this.elementClassHint(ElementClassHint.DeclarationKind.CLASS);
        if (annotationResolve) {
            this.hint(AnnotationHint.HINT_KEY, AnnotationHint.ANNOTATION_RESOLVE);
        }
    }

    public /* synthetic */ ClassProcessor(String string, PsiElement psiElement, PsiType[] psiTypeArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            psiTypeArray = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, psiElement, psiTypeArray, bl);
    }

    @Override
    @Nullable
    protected GroovyResolveResult result(@NotNull PsiElement element, @NotNull ResolveState state) {
        String elementName;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PsiClass psiClass = element instanceof PsiClass ? (PsiClass)element : null;
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        if (clazz instanceof PsiTypeParameter) {
            return null;
        }
        String string = (String)state.get(GroovyImports.getImportedNameKey());
        if (string == null) {
            string = clazz.getName();
        }
        if (!Intrinsics.areEqual((Object)(elementName = string), (Object)this.name)) {
            return null;
        }
        return Companion.createResult(clazz, this.place, state, this.typeArguments);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ClassProcessor$Companion;", "", "<init>", "()V", "createResult", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "clazz", "Lcom/intellij/psi/PsiClass;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "typeArguments", "", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/ResolveState;[Lcom/intellij/psi/PsiType;)Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GroovyResolveResult createResult(@NotNull PsiClass clazz, @NotNull PsiElement place, @NotNull ResolveState state, @Nullable PsiType[] typeArguments) {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (typeArguments == null || !(typeArguments.length == 0)) {
                PsiSubstitutor psiSubstitutor = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).putAll(clazz, typeArguments);
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"putAll(...)");
                PsiSubstitutor newSubstitutor = psiSubstitutor;
                ResolveState resolveState = state.put(PsiSubstitutor.KEY, (Object)newSubstitutor);
                Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"put(...)");
                ResolveState newState = resolveState;
                return new BaseGroovyResolveResult<PsiElement>((PsiElement)clazz, place, newState);
            }
            return new DiamondResolveResult(clazz, place, state);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

