/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public final class GroovyUnnecessaryReturnInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.ref.is.unnecessary.as.last.statement.in.method.with.no.return.value", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyUnnecessaryReturnInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryReturnFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryReturnInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(returnStatement);
            GrExpression returnValue = returnStatement.getReturnValue();
            if (returnValue != null) {
                return;
            }
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrMethod.class);
            if (method == null) {
                return;
            }
            GrOpenBlock body = method.getBlock();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.openBlockCompletesWithStatement(body, returnStatement)) {
                this.registerStatementError(returnStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryReturnInspection$Visitor", "visitReturnStatement"));
        }
    }

    private static class UnnecessaryReturnFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryReturnFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.remove.unnecessary.return", new Object[0]);
            if (string == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement returnKeywordElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(1);
            }
            if (returnKeywordElement == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(3);
            }
            GrReturnStatement returnStatement = (GrReturnStatement)returnKeywordElement.getParent();
            assert (returnStatement != null);
            returnStatement.removeStatement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryReturnInspection$UnnecessaryReturnFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnKeywordElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryReturnInspection$UnnecessaryReturnFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

