/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GroovyConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = GroovyBundle.message("inspection.message.ref.statement.can.be.simplified", new Object[0]);
        if (string == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(1);
        }
        return new ConstantIfStatementFix();
    }

    private static boolean isFalse(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                ConstantIfStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (GroovyConstantIfStatementInspection.isTrue(condition) || GroovyConstantIfStatementInspection.isFalse(condition)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementVisitor", "visitIfStatement"));
        }
    }

    private static class ConstantIfStatementFix
    extends PsiUpdateModCommandQuickFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.simplify", new Object[0]);
            if (string == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(3);
            }
            GrIfStatement ifStatement = (GrIfStatement)element.getParent();
            assert (ifStatement != null);
            GrStatement thenBranch = ifStatement.getThenBranch();
            GrStatement elseBranch = ifStatement.getElseBranch();
            GrExpression condition = ifStatement.getCondition();
            if (GroovyConstantIfStatementInspection.isFalse(condition)) {
                if (elseBranch != null) {
                    GroovyFix.replaceStatement((GrStatement)ifStatement, (GrStatement)elseBranch.copy());
                } else {
                    ifStatement.delete();
                }
            } else {
                GroovyFix.replaceStatement((GrStatement)ifStatement, (GrStatement)thenBranch.copy());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

