---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Upgrade a GitLab instance
description: Upgrade steps for all installation methods.
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

Upgrade a single-node GitLab instance to take advantage of new features and bug fixes. You can also upgrade multi-node
GitLab instances with or without downtime.

{{< cards >}}

- [Single-node Linux package instances](package/_index.md)
- [Single-node Docker instances](docker/_index.md)
- [Single-node self-compiled instances](upgrading_from_source.md)
- [GitLab Helm chart instances](https://docs.gitlab.com/charts/installation/upgrade/ "Upgrade GitLab Helm chart instance.")
- [GitLab Operator instances](https://docs.gitlab.com/operator/gitlab_upgrades/ "Upgrade GitLab instance with GitLab Operator.")
- [Multi-node GitLab instance with downtime](with_downtime.md)
- [Multi-node GitLab instance with zero downtime](zero_downtime.md)

{{< /cards >}}
