---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabで利用できるコミットのスカッシュオプションについて理解し、設定します。
title: スカッシュとマージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

スカッシュとマージを行うと、複数の小さなコミットが1つの意味のあるコミットに結合されます。この方法により、リポジトリの履歴がクリーンに保たれ、変更の追跡やリバートが容易になります。複数の機能の作業を同時に行う場合でも、スカッシュを使用すると、各機能の変更を明確で論理的な単位に分けることができます。

- 小さなコミットが結合されるため、[すべての変更箇所をリバート](revert_changes.md)するが簡単になります。
- 単一のコミットがターゲットブランチにマージされる際には、完全なコミット履歴が保持されます。
- ベースブランチはクリーンな状態に保たれ、意味のあるコミットメッセージが含まれています。

## スカッシュとマージのワークフロー {#squash-and-merge-workflow}

ブランチがベースブランチにマージされるたびに、最大2つのコミットが追加されます:

- ブランチからコミットをスカッシュすることによって作成された単一のコミット。
- マージコミット。ただし、プロジェクトで[早送りマージ](methods/_index.md#fast-forward-merge)を有効にしている場合は除きます。早送りマージでは追加のマージコミットの作成を防ぎますが、それでもブランチからコミットをスカッシュして単一のコミットにすることができます。

デフォルトでは、スカッシュされたコミットには次のメタデータが含まれています:

- メッセージ: スカッシュコミットの説明、またはカスタマイズされたメッセージ
- 作成者: マージリクエストを作成したユーザー
- コミッター: スカッシュを開始したユーザー

プロジェクトオーナーは、すべてのスカッシュコミットおよびマージコミットの[新しいデフォルトメッセージを作成](commit_templates.md)できます。

## マージリクエストのデフォルトのスカッシュオプションを設定する {#set-default-squash-options-for-a-merge-request}

マージリクエストを作成または編集する権限を持つユーザーは、マージリクエストのデフォルトのスカッシュオプションを設定できます。

前提要件:

- プロジェクトがスカッシュを許可または推奨するように[設定されている](#configure-squash-options-for-a-project)必要があります。

これを行うには、以下を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. **編集**を選択します。
1. **Squash commits when merge request is accepted**（マージリクエストが承認されたときにコミットをスカッシュする）のチェックボックスをオンまたはオフにします。
1. **変更を保存**を選択します。

## マージリクエスト内でコミットをスカッシュする {#squash-commits-in-a-merge-request}

プロジェクトでマージリクエストのスカッシュオプションを選択できる場合、マージプロセスの一部としてコミットをスカッシュするには、以下を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストウィジェットで、**コミットをスカッシュ**チェックボックスが選択されていることを確認してください。プロジェクトのスカッシュオプションが**許可しない**または**必須**のいずれかに設定されている場合、このチェックボックスは表示されません。
1. オプション。スカッシュコミットメッセージまたはマージコミットメッセージ（プロジェクトの設定によって異なります）を変更するには、**コミットメッセージを修正**を選択します。
1. マージリクエストをマージする準備ができたら、**マージ**を選択します。

## プロジェクトのスカッシュオプションを設定する {#configure-squash-options-for-a-project}

前提要件:

- このプロジェクトでのメンテナー以上のロールが必要です。

プロジェクト内のすべてのマージリクエストのデフォルトのスカッシュ動作を設定するには、以下を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージ時にコミットをスカッシュする**セクションで、次の選択肢から動作を選択します:
   - **許可しない**: スカッシュは実行されず、オプションは表示されません。
   - **許可**: スカッシュは許可されていますが、デフォルトではオフになっています。
   - **推奨**: スカッシュは許可され、デフォルトで選択されていますが、無効にすることができます。
   - **必須**: スカッシュは常に実行されます。マージリクエストにはスカッシュのオプションが表示されますが、ユーザーは変更できません。
1. **変更を保存**を選択します。

## 関連トピック {#related-topics}

- [コミットメッセージテンプレート](commit_templates.md)
- [マージ方法](methods/_index.md)
