---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 非推奨用語
---

## 非推奨 {#deprecation}

- 機能のサポートを終了したり、機能を削除したりする前に必要です。
- 機能の使用は推奨されません。
- 開発は、優先度1 / 重大度1のバグ修正に制限されています。
- 将来のメジャーリリースで削除されます。
- サポート終了日または削除日を概説する非推奨の発表後に開始されます。
- サポート終了日または削除日が過ぎると終了します。

## サポート終了 {#end-of-support}

- 削除前のオプションのステップ。
- 機能の使用は強く推奨されません。
- サポートや修正は提供されません。
- 社内でのテストは行われなくなりました。
- 将来のメジャーリリースで削除されます。
- サポート終了日が過ぎると開始されます。

サポート終了期間の発表は、特別な状況でのみ使用する必要があり、一般的な使用はお勧めしません。ほとんどの機能は非推奨にしてから削除する必要があります。

## 削除 {#removal}

- 機能の使用は不可能です。
- 機能はサポートされなくなりました（サポート終了期間がまだ発表されていない場合）。
- 当社の[セマンティックバージョニングポリシー](../policy/maintenance.md)に沿って、メジャーリリースで発生します。
- 削除日が過ぎると開始されます。

## 破壊的な変更 {#breaking-change}

顧客がGitLabのワークフローが中断されないようにするために行動を起こす必要がある場合、どのような変更も破壊的な変更と見なされます。

破壊的な変更は、次のような原因から発生する可能性があります:

- 意図的な製品の変更
- 設定の更新
- サードパーティの非推奨

デフォルトでは、破壊的な変更の実装計画がリーダーシップによって承認されない限り、破壊的な変更は許可されません。

## サードパーティの依存関係 {#third-party-dependencies}

このセクションは、上記のすべての用語に適用されます。

サードパーティの依存関係の変更（非推奨、サポート終了、削除、または破壊的な変更）は、GitLab自体の機能の変更とは別に処理されます:

- これらの変更は、依存関係独自のライフサイクルに従い、GitLabの機能プロセスとタイムラインの要件の対象にはなりません。
- GitLabは、当社の製品に影響を与えるサードパーティの依存関係の変更の影響を最小限に抑え、スムーズな移行エクスペリエンスを提供するよう努めます。
- 依存関係のセキュリティアップデートは、脆弱性解決のSLA内で深刻な脆弱性に対処するために必要な場合、標準の非推奨プロセスに従わずに適用される場合があります。詳細については、GitLabのハンドブックを参照してください。
- 依存関係が当社の管理またはタイムライン外で変更される場合、GitLabは、当社の機能、互換性、またはセキュリティを維持するために、通常プロセスおよびタイムライン外で独自のソフトウェアに変更を実装する必要がある場合があります。
- GitLabは、重要なサードパーティの依存関係の変更を伝えるために合理的な努力を払います。
- GitLabは、GitLab製品で直接使用されていないサードパーティの依存関係機能の変更については責任を負いません。
- GitLabの利用パターンを超えてこれらのサードパーティの依存関係を利用する顧客は、自己責任で行う必要があり、次のことを行う必要があります:
  - サードパーティのリリースノートを個別に監視します。
  - 新しい依存関係バージョンに対してカスタム実装をテストします。
  - サードパーティの変更に対する独自の移行戦略を計画します。
