# frozen_string_literal: true

class QueueUpdateOwaspTop10DefaultOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  MIGRATION = "UpdateOwaspTop10DefaultOfVulnerabilityReads"
  DELAY_INTERVAL = 120.seconds
  BATCH_SIZE = 10000
  SUB_BATCH_SIZE = 50

  def up
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      queue_batched_background_migration(
        MIGRATION,
        :vulnerability_reads,
        :vulnerability_id,
        job_interval: DELAY_INTERVAL,
        batch_size: BATCH_SIZE,
        sub_batch_size: SUB_BATCH_SIZE
      )
    end
  end

  def down
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      delete_batched_background_migration(MIGRATION, :vulnerability_reads, :vulnerability_id, [])
    end
  end
end
