# frozen_string_literal: true

class DropIndexFromVulnerabilityArchivedRecordsOnArchiveId < Gitlab::Database::Migration[2.2]
  INDEX_NAME = 'index_vulnerability_archived_records_on_archive_id'

  disable_ddl_transaction!
  milestone '17.10'

  def up
    remove_concurrent_index_by_name :vulnerability_archived_records, INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerability_archived_records, :archive_id, name: INDEX_NAME
  end
end
