/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import io.sf.carte.echosvg.util.ParsedURL;
import io.sf.carte.echosvg.util.ParsedURLData;
import io.sf.carte.echosvg.util.ParsedURLDefaultProtocolHandler;
import java.net.MalformedURLException;
import java.net.URL;

public class ParsedURLJarProtocolHandler
extends ParsedURLDefaultProtocolHandler {
    public static final String JAR = "jar";

    public ParsedURLJarProtocolHandler() {
        super(JAR);
    }

    @Override
    public ParsedURLData parseURL(ParsedURL baseURL, String urlStr) {
        if (this.startsWithJarColon(urlStr)) {
            return this.parseURL(urlStr);
        }
        try {
            URL context = new URL(baseURL.toString());
            URL url = new URL(context, urlStr);
            return this.constructParsedURLData(url);
        }
        catch (MalformedURLException mue) {
            return super.parseURL(baseURL, urlStr);
        }
    }

    private boolean startsWithJarColon(String url) {
        char c;
        return !(url.length() <= 3 || (c = url.charAt(0)) != 'j' && c != 'J' || (c = url.charAt(1)) != 'a' && c != 'A' || (c = url.charAt(2)) != 'r' && c != 'R' || url.charAt(3) != ':');
    }
}

