/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.time.format.DateTimeFormatter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.data.OracleTimestampConverter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCTemporalAccessorValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleTemporalAccessorValueHandler
extends JDBCTemporalAccessorValueHandler {
    private static final DateTimeFormatter DEFAULT_DATETIME_FORMAT = DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.nnnnnn''");
    private static final DateTimeFormatter DEFAULT_DATETIME_TZ_FORMAT = DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.nnnnnn X''");
    private static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFormatter.ofPattern("'DATE '''yyyy-MM-dd''");
    private static final DateTimeFormatter DEFAULT_TIME_FORMAT = DateTimeFormatter.ofPattern("'TIME '''HH:mm:ss.SSS''");

    public OracleTemporalAccessorValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null && object.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            try {
                return OracleTimestampConverter.toTimestamp(object, ((JDBCSession)session).getOriginal());
            }
            catch (Exception e) {
                throw new DBCException("Error extracting Oracle TIMESTAMP value", (Throwable)e);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (format == DBDDisplayFormat.NATIVE && value instanceof String) {
            if (!((String)value).startsWith("TIMESTAMP")) {
                return "TIMESTAMP'" + String.valueOf(value) + "'";
            }
            return (String)value;
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Nullable
    public DateTimeFormatter getNativeValueFormat(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 93: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 101: 
            case 102: 
            case 2014: {
                return DEFAULT_DATETIME_TZ_FORMAT;
            }
            case 92: {
                return DEFAULT_TIME_FORMAT;
            }
            case 2013: {
                return DEFAULT_TIME_TZ_FORMAT;
            }
            case 91: {
                return DEFAULT_DATE_FORMAT;
            }
        }
        return super.getNativeValueFormat(type);
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeID()) {
            case 101: 
            case 102: {
                return "timestamptz";
            }
        }
        return super.getFormatterId(column);
    }

    protected boolean isZonedType(DBSTypedObject type) {
        if (type.getTypeID() == 101) {
            return true;
        }
        return super.isZonedType(type);
    }
}

