/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreRoleReference
implements Comparable<PostgreRoleReference> {
    @NotNull
    private final PostgreDatabase database;
    @NotNull
    private final String roleName;
    @Nullable
    private final String roleType;

    public PostgreRoleReference(@NotNull PostgreDatabase database, @NotNull String roleName, @Nullable String roleType) {
        this.database = database;
        this.roleName = roleName;
        this.roleType = roleType;
    }

    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public String getRoleName() {
        return this.roleName;
    }

    @Nullable
    public String getRoleType() {
        return this.roleType;
    }

    @NotNull
    public String getDisplayString() {
        return (CommonUtils.isEmpty((String)this.roleType) ? "" : this.roleType) + DBUtils.getQuotedIdentifier((DBPDataSource)this.database.getDataSource(), (String)this.roleName);
    }

    @Override
    public int compareTo(PostgreRoleReference other) {
        int rc;
        int n = rc = this.database.equals(other.database) ? 0 : this.database.getName().compareTo(other.database.getName());
        if (rc == 0) {
            rc = this.roleName.compareTo(other.roleName);
        }
        if (rc == 0) {
            rc = Objects.compare(this.roleType, other.roleType, String::compareToIgnoreCase);
        }
        return rc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PostgreRoleReference) {
            PostgreRoleReference other = (PostgreRoleReference)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.database, this.roleName, this.roleType);
    }

    public String toString() {
        return "PostgreRoleReference[" + DBUtils.getFullQualifiedName((DBPDataSource)this.database.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.database}) + ": " + (String)(CommonUtils.isEmpty((String)this.roleType) ? "" : this.roleType + " ") + this.roleName + "]";
    }
}

