# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._key_vault_client_operations import (
    build_backup_key_request,
    build_backup_secret_request,
    build_create_certificate_request,
    build_create_key_request,
    build_decrypt_request,
    build_delete_certificate_contacts_request,
    build_delete_certificate_issuer_request,
    build_delete_certificate_operation_request,
    build_delete_certificate_request,
    build_delete_key_request,
    build_delete_sas_definition_request,
    build_delete_secret_request,
    build_delete_storage_account_request,
    build_encrypt_request,
    build_get_certificate_contacts_request,
    build_get_certificate_issuer_request,
    build_get_certificate_issuers_request,
    build_get_certificate_operation_request,
    build_get_certificate_policy_request,
    build_get_certificate_request,
    build_get_certificate_versions_request,
    build_get_certificates_request,
    build_get_deleted_certificate_request,
    build_get_deleted_certificates_request,
    build_get_deleted_key_request,
    build_get_deleted_keys_request,
    build_get_deleted_secret_request,
    build_get_deleted_secrets_request,
    build_get_key_request,
    build_get_key_versions_request,
    build_get_keys_request,
    build_get_sas_definition_request,
    build_get_sas_definitions_request,
    build_get_secret_request,
    build_get_secret_versions_request,
    build_get_secrets_request,
    build_get_storage_account_request,
    build_get_storage_accounts_request,
    build_import_certificate_request,
    build_import_key_request,
    build_merge_certificate_request,
    build_purge_deleted_certificate_request,
    build_purge_deleted_key_request,
    build_purge_deleted_secret_request,
    build_recover_deleted_certificate_request,
    build_recover_deleted_key_request,
    build_recover_deleted_secret_request,
    build_regenerate_storage_account_key_request,
    build_restore_key_request,
    build_restore_secret_request,
    build_set_certificate_contacts_request,
    build_set_certificate_issuer_request,
    build_set_sas_definition_request,
    build_set_secret_request,
    build_set_storage_account_request,
    build_sign_request,
    build_unwrap_key_request,
    build_update_certificate_issuer_request,
    build_update_certificate_operation_request,
    build_update_certificate_policy_request,
    build_update_certificate_request,
    build_update_key_request,
    build_update_sas_definition_request,
    build_update_secret_request,
    build_update_storage_account_request,
    build_verify_request,
    build_wrap_key_request,
)
from .._vendor import KeyVaultClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class KeyVaultClientOperationsMixin(KeyVaultClientMixinABC):  # pylint: disable=too-many-public-methods
    @overload
    async def create_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: _models.KeyCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_key(
        self, vault_base_url: str, key_name: str, parameters: Union[_models.KeyCreateParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key. Required.
        :type key_name: str
        :param parameters: The parameters to create a key. Is either a KeyCreateParameters type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyCreateParameters")

        request = build_create_key_request(
            key_name=key_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_key.metadata = {"url": "/keys/{key-name}/create"}

    @overload
    async def import_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: _models.KeyImportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyImportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def import_key(
        self,
        vault_base_url: str,
        key_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def import_key(
        self, vault_base_url: str, key_name: str, parameters: Union[_models.KeyImportParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Imports an externally created key, stores it, and returns key parameters and attributes to the
        client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: Name for the imported key. Required.
        :type key_name: str
        :param parameters: The parameters to import a key. Is either a KeyImportParameters type or a IO
         type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyImportParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyImportParameters")

        request = build_import_key_request(
            key_name=key_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.import_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    import_key.metadata = {"url": "/keys/{key-name}"}

    @distributed_trace_async
    async def delete_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.DeletedKeyBundle:
        """Deletes a key of any type from storage in Azure Key Vault.

        The delete key operation cannot be used to remove individual versions of a key. This operation
        removes the cryptographic material associated with the key, which means the key is not usable
        for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the
        keys/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key to delete. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedKeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedKeyBundle] = kwargs.pop("cls", None)

        request = build_delete_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.delete_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedKeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_key.metadata = {"url": "/keys/{key-name}"}

    @overload
    async def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.KeyBundle:
        """The update key operation changes specified attributes of a stored key and can be applied to any
        key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of key to update. Required.
        :type key_name: str
        :param key_version: The version of the key to update. Required.
        :type key_version: str
        :param parameters: The parameters of the key to update. Is either a KeyUpdateParameters type or
         a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyUpdateParameters")

        request = build_update_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_key.metadata = {"url": "/keys/{key-name}/{key-version}"}

    @distributed_trace_async
    async def get_key(self, vault_base_url: str, key_name: str, key_version: str, **kwargs: Any) -> _models.KeyBundle:
        """Gets the public part of a stored key.

        The get key operation is applicable to all key types. If the requested key is symmetric, then
        no key material is released in the response. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key to get. Required.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific version of a key.
         Required.
        :type key_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        request = build_get_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            template_url=self.get_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_key.metadata = {"url": "/keys/{key-name}/{key-version}"}

    @distributed_trace
    def get_key_versions(
        self, vault_base_url: str, key_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.KeyItem"]:
        """Retrieves a list of individual key versions with the same key name.

        The full key identifier, attributes, and tags are provided in the response. This operation
        requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.KeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.KeyListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_key_versions_request(
                    key_name=key_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_key_versions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_key_versions.metadata = {"url": "/keys/{key-name}/versions"}

    @distributed_trace
    def get_keys(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.KeyItem"]:
        """List keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a stored key. The LIST operation is applicable to all key types, however only
        the base key identifier, attributes, and tags are provided in the response. Individual versions
        of a key are not listed in the response. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.KeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.KeyListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_keys_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("KeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_keys.metadata = {"url": "/keys"}

    @distributed_trace_async
    async def backup_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.BackupKeyResult:
        """Requests that a backup of the specified key be downloaded to the client.

        The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this
        operation does NOT return key material in a form that can be used outside the Azure Key Vault
        system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key
        Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure
        Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance.
        The BACKUP operation may be used to export, in protected form, any key type from Azure Key
        Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed
        within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be
        restored to another geographical area. For example, a backup from the US geographical area
        cannot be restored in an EU geographical area. This operation requires the key/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupKeyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.BackupKeyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.BackupKeyResult] = kwargs.pop("cls", None)

        request = build_backup_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.backup_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("BackupKeyResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup_key.metadata = {"url": "/keys/{key-name}/backup"}

    @overload
    async def restore_key(
        self,
        vault_base_url: str,
        parameters: _models.KeyRestoreParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyRestoreParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def restore_key(
        self, vault_base_url: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def restore_key(
        self, vault_base_url: str, parameters: Union[_models.KeyRestoreParameters, IO], **kwargs: Any
    ) -> _models.KeyBundle:
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key. Is either a KeyRestoreParameters type or
         a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyRestoreParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyRestoreParameters")

        request = build_restore_key_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.restore_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    restore_key.metadata = {"url": "/keys/restore"}

    @overload
    async def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def encrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a
        key-reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the encryption operation. Is either a
         KeyOperationsParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyOperationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_encrypt_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.encrypt.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    encrypt.metadata = {"url": "/keys/{key-name}/{key-version}/encrypt"}

    @overload
    async def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def decrypt(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the decryption operation. Is either a
         KeyOperationsParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyOperationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_decrypt_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.decrypt.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    decrypt.metadata = {"url": "/keys/{key-name}/{key-version}/decrypt"}

    @overload
    async def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeySignParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeySignParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def sign(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeySignParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the signing operation. Is either a KeySignParameters type
         or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeySignParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyOperationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeySignParameters")

        request = build_sign_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.sign.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    sign.metadata = {"url": "/keys/{key-name}/{key-version}/sign"}

    @overload
    async def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyVerifyParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyVerifyParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def verify(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyVerifyParameters, IO],
        **kwargs: Any
    ) -> _models.KeyVerifyResult:
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for verify operations. Is either a KeyVerifyParameters type
         or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyVerifyParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyVerifyResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyVerifyResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyVerifyParameters")

        request = build_verify_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.verify.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyVerifyResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    verify.metadata = {"url": "/keys/{key-name}/{key-version}/verify"}

    @overload
    async def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def wrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for wrap operation. Is either a KeyOperationsParameters type
         or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyOperationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_wrap_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.wrap_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    wrap_key.metadata = {"url": "/keys/{key-name}/{key-version}/wrapkey"}

    @overload
    async def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: _models.KeyOperationsParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def unwrap_key(
        self,
        vault_base_url: str,
        key_name: str,
        key_version: str,
        parameters: Union[_models.KeyOperationsParameters, IO],
        **kwargs: Any
    ) -> _models.KeyOperationResult:
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key_version: The version of the key. Required.
        :type key_version: str
        :param parameters: The parameters for the key operation. Is either a KeyOperationsParameters
         type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.KeyOperationsParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyOperationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyOperationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "KeyOperationsParameters")

        request = build_unwrap_key_request(
            key_name=key_name,
            key_version=key_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.unwrap_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyOperationResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    unwrap_key.metadata = {"url": "/keys/{key-name}/{key-version}/unwrapkey"}

    @distributed_trace
    def get_deleted_keys(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.DeletedKeyItem"]:
        """Lists the deleted keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a deleted key. This operation includes deletion-specific information. The Get
        Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedKeyItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.DeletedKeyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedKeyListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_deleted_keys_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_deleted_keys.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeletedKeyListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_deleted_keys.metadata = {"url": "/deletedkeys"}

    @distributed_trace_async
    async def get_deleted_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.DeletedKeyBundle:
        """Gets the public part of a deleted key.

        The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedKeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedKeyBundle] = kwargs.pop("cls", None)

        request = build_get_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.get_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedKeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deleted_key.metadata = {"url": "/deletedkeys/{key-name}"}

    @distributed_trace_async
    async def purge_deleted_key(  # pylint: disable=inconsistent-return-statements
        self, vault_base_url: str, key_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified key.

        The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the
        operation can be invoked on any vault, it will return an error if invoked on a non soft-delete
        enabled vault. This operation requires the keys/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_purge_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.purge_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_key.metadata = {"url": "/deletedkeys/{key-name}"}

    @distributed_trace_async
    async def recover_deleted_key(self, vault_base_url: str, key_name: str, **kwargs: Any) -> _models.KeyBundle:
        """Recovers the deleted key to its latest version.

        The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults.
        It recovers the deleted key back to its latest version under /keys. An attempt to recover an
        non-deleted key will return an error. Consider this the inverse of the delete operation on
        soft-delete enabled vaults. This operation requires the keys/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param key_name: The name of the deleted key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.KeyBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.KeyBundle] = kwargs.pop("cls", None)

        request = build_recover_deleted_key_request(
            key_name=key_name,
            api_version=api_version,
            template_url=self.recover_deleted_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("KeyBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    recover_deleted_key.metadata = {"url": "/deletedkeys/{key-name}/recover"}

    @overload
    async def set_secret(
        self,
        vault_base_url: str,
        secret_name: str,
        parameters: _models.SecretSetParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Sets a secret in a specified key vault.

        The SET operation adds a secret to the Azure Key Vault. If the named secret already exists,
        Azure Key Vault creates a new version of that secret. This operation requires the secrets/set
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param parameters: The parameters for setting the secret. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretSetParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_secret(
        self,
        vault_base_url: str,
        secret_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Sets a secret in a specified key vault.

        The SET operation adds a secret to the Azure Key Vault. If the named secret already exists,
        Azure Key Vault creates a new version of that secret. This operation requires the secrets/set
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param parameters: The parameters for setting the secret. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_secret(
        self, vault_base_url: str, secret_name: str, parameters: Union[_models.SecretSetParameters, IO], **kwargs: Any
    ) -> _models.SecretBundle:
        """Sets a secret in a specified key vault.

        The SET operation adds a secret to the Azure Key Vault. If the named secret already exists,
        Azure Key Vault creates a new version of that secret. This operation requires the secrets/set
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param parameters: The parameters for setting the secret. Is either a SecretSetParameters type
         or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretSetParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecretBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SecretSetParameters")

        request = build_set_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_secret.metadata = {"url": "/secrets/{secret-name}"}

    @distributed_trace_async
    async def delete_secret(self, vault_base_url: str, secret_name: str, **kwargs: Any) -> _models.DeletedSecretBundle:
        """Deletes a secret from a specified key vault.

        The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied
        to an individual version of a secret. This operation requires the secrets/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedSecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedSecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedSecretBundle] = kwargs.pop("cls", None)

        request = build_delete_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            template_url=self.delete_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedSecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_secret.metadata = {"url": "/secrets/{secret-name}"}

    @overload
    async def update_secret(
        self,
        vault_base_url: str,
        secret_name: str,
        secret_version: str,
        parameters: _models.SecretUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Updates the attributes associated with a specified secret in a given key vault.

        The UPDATE operation changes specified attributes of an existing stored secret. Attributes that
        are not specified in the request are left unchanged. The value of a secret itself cannot be
        changed. This operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param secret_version: The version of the secret. Required.
        :type secret_version: str
        :param parameters: The parameters for update secret operation. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_secret(
        self,
        vault_base_url: str,
        secret_name: str,
        secret_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Updates the attributes associated with a specified secret in a given key vault.

        The UPDATE operation changes specified attributes of an existing stored secret. Attributes that
        are not specified in the request are left unchanged. The value of a secret itself cannot be
        changed. This operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param secret_version: The version of the secret. Required.
        :type secret_version: str
        :param parameters: The parameters for update secret operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_secret(
        self,
        vault_base_url: str,
        secret_name: str,
        secret_version: str,
        parameters: Union[_models.SecretUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Updates the attributes associated with a specified secret in a given key vault.

        The UPDATE operation changes specified attributes of an existing stored secret. Attributes that
        are not specified in the request are left unchanged. The value of a secret itself cannot be
        changed. This operation requires the secrets/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param secret_version: The version of the secret. Required.
        :type secret_version: str
        :param parameters: The parameters for update secret operation. Is either a
         SecretUpdateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecretBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SecretUpdateParameters")

        request = build_update_secret_request(
            secret_name=secret_name,
            secret_version=secret_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_secret.metadata = {"url": "/secrets/{secret-name}/{secret-version}"}

    @distributed_trace_async
    async def get_secret(
        self, vault_base_url: str, secret_name: str, secret_version: str, **kwargs: Any
    ) -> _models.SecretBundle:
        """Get a specified secret from a given key vault.

        The GET operation is applicable to any secret stored in Azure Key Vault. This operation
        requires the secrets/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param secret_version: The version of the secret. Required.
        :type secret_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SecretBundle] = kwargs.pop("cls", None)

        request = build_get_secret_request(
            secret_name=secret_name,
            secret_version=secret_version,
            api_version=api_version,
            template_url=self.get_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_secret.metadata = {"url": "/secrets/{secret-name}/{secret-version}"}

    @distributed_trace
    def get_secrets(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.SecretItem"]:
        """List secrets in a specified key vault.

        The Get Secrets operation is applicable to the entire vault. However, only the base secret
        identifier and its attributes are provided in the response. Individual secret versions are not
        listed in the response. This operation requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SecretItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.SecretItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SecretListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_secrets_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_secrets.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SecretListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_secrets.metadata = {"url": "/secrets"}

    @distributed_trace
    def get_secret_versions(
        self, vault_base_url: str, secret_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.SecretItem"]:
        """List all versions of the specified secret.

        The full secret identifier and attributes are provided in the response. No values are returned
        for the secrets. This operations requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SecretItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.SecretItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SecretListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_secret_versions_request(
                    secret_name=secret_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_secret_versions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SecretListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_secret_versions.metadata = {"url": "/secrets/{secret-name}/versions"}

    @distributed_trace
    def get_deleted_secrets(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.DeletedSecretItem"]:
        """Lists deleted secrets for the specified vault.

        The Get Deleted Secrets operation returns the secrets that have been deleted for a vault
        enabled for soft-delete. This operation requires the secrets/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedSecretItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.DeletedSecretItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedSecretListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_deleted_secrets_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_deleted_secrets.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeletedSecretListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_deleted_secrets.metadata = {"url": "/deletedsecrets"}

    @distributed_trace_async
    async def get_deleted_secret(
        self, vault_base_url: str, secret_name: str, **kwargs: Any
    ) -> _models.DeletedSecretBundle:
        """Gets the specified deleted secret.

        The Get Deleted Secret operation returns the specified deleted secret along with its
        attributes. This operation requires the secrets/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedSecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedSecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedSecretBundle] = kwargs.pop("cls", None)

        request = build_get_deleted_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            template_url=self.get_deleted_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedSecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deleted_secret.metadata = {"url": "/deletedsecrets/{secret-name}"}

    @distributed_trace_async
    async def purge_deleted_secret(  # pylint: disable=inconsistent-return-statements
        self, vault_base_url: str, secret_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified secret.

        The purge deleted secret operation removes the secret permanently, without the possibility of
        recovery. This operation can only be enabled on a soft-delete enabled vault. This operation
        requires the secrets/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_purge_deleted_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            template_url=self.purge_deleted_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_secret.metadata = {"url": "/deletedsecrets/{secret-name}"}

    @distributed_trace_async
    async def recover_deleted_secret(
        self, vault_base_url: str, secret_name: str, **kwargs: Any
    ) -> _models.SecretBundle:
        """Recovers the deleted secret to the latest version.

        Recovers the deleted secret in the specified vault. This operation can only be performed on a
        soft-delete enabled vault. This operation requires the secrets/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the deleted secret. Required.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SecretBundle] = kwargs.pop("cls", None)

        request = build_recover_deleted_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            template_url=self.recover_deleted_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    recover_deleted_secret.metadata = {"url": "/deletedsecrets/{secret-name}/recover"}

    @distributed_trace_async
    async def backup_secret(self, vault_base_url: str, secret_name: str, **kwargs: Any) -> _models.BackupSecretResult:
        """Backs up the specified secret.

        Requests that a backup of the specified secret be downloaded to the client. All versions of the
        secret will be downloaded. This operation requires the secrets/backup permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param secret_name: The name of the secret. Required.
        :type secret_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupSecretResult or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.BackupSecretResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.BackupSecretResult] = kwargs.pop("cls", None)

        request = build_backup_secret_request(
            secret_name=secret_name,
            api_version=api_version,
            template_url=self.backup_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("BackupSecretResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup_secret.metadata = {"url": "/secrets/{secret-name}/backup"}

    @overload
    async def restore_secret(
        self,
        vault_base_url: str,
        parameters: _models.SecretRestoreParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SecretBundle:
        """Restores a backed up secret to a vault.

        Restores a backed up secret, and all its versions, to a vault. This operation requires the
        secrets/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the secret. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretRestoreParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def restore_secret(
        self, vault_base_url: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SecretBundle:
        """Restores a backed up secret to a vault.

        Restores a backed up secret, and all its versions, to a vault. This operation requires the
        secrets/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the secret. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def restore_secret(
        self, vault_base_url: str, parameters: Union[_models.SecretRestoreParameters, IO], **kwargs: Any
    ) -> _models.SecretBundle:
        """Restores a backed up secret to a vault.

        Restores a backed up secret, and all its versions, to a vault. This operation requires the
        secrets/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param parameters: The parameters to restore the secret. Is either a SecretRestoreParameters
         type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SecretRestoreParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SecretBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SecretBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecretBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SecretRestoreParameters")

        request = build_restore_secret_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.restore_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SecretBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    restore_secret.metadata = {"url": "/secrets/restore"}

    @distributed_trace
    def get_certificates(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CertificateItem"]:
        """List certificates in a specified key vault.

        The GetCertificates operation returns the set of certificates resources in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificates_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_certificates.metadata = {"url": "/certificates"}

    @distributed_trace_async
    async def delete_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.DeletedCertificateBundle:
        """Deletes a certificate from a specified key vault.

        Deletes all versions of a certificate object along with its associated policy. Delete
        certificate cannot be used to remove individual versions of a certificate object. This
        operation requires the certificates/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedCertificateBundle] = kwargs.pop("cls", None)

        request = build_delete_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.delete_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedCertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate.metadata = {"url": "/certificates/{certificate-name}"}

    @overload
    async def set_certificate_contacts(
        self, vault_base_url: str, contacts: _models.Contacts, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: ~azure.keyvault.v2016_10_01.models.Contacts
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_certificate_contacts(
        self, vault_base_url: str, contacts: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Required.
        :type contacts: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_certificate_contacts(
        self, vault_base_url: str, contacts: Union[_models.Contacts, IO], **kwargs: Any
    ) -> _models.Contacts:
        """Sets the certificate contacts for the specified key vault.

        Sets the certificate contacts for the specified key vault. This operation requires the
        certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param contacts: The contacts for the key vault certificate. Is either a Contacts type or a IO
         type. Required.
        :type contacts: ~azure.keyvault.v2016_10_01.models.Contacts or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(contacts, (IO, bytes)):
            _content = contacts
        else:
            _json = self._serialize.body(contacts, "Contacts")

        request = build_set_certificate_contacts_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_certificate_contacts.metadata = {"url": "/certificates/contacts"}

    @distributed_trace_async
    async def get_certificate_contacts(self, vault_base_url: str, **kwargs: Any) -> _models.Contacts:
        """Lists the certificate contacts for a specified key vault.

        The GetCertificateContacts operation returns the set of certificate contact resources in the
        specified key vault. This operation requires the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        request = build_get_certificate_contacts_request(
            api_version=api_version,
            template_url=self.get_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_contacts.metadata = {"url": "/certificates/contacts"}

    @distributed_trace_async
    async def delete_certificate_contacts(self, vault_base_url: str, **kwargs: Any) -> _models.Contacts:
        """Deletes the certificate contacts for a specified key vault.

        Deletes the certificate contacts for a specified key vault certificate. This operation requires
        the certificates/managecontacts permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Contacts or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.Contacts
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.Contacts] = kwargs.pop("cls", None)

        request = build_delete_certificate_contacts_request(
            api_version=api_version,
            template_url=self.delete_certificate_contacts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Contacts", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_contacts.metadata = {"url": "/certificates/contacts"}

    @distributed_trace
    def get_certificate_issuers(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CertificateIssuerItem"]:
        """List certificate issuers for a specified key vault.

        The GetCertificateIssuers operation returns the set of certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateIssuerItem or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.CertificateIssuerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateIssuerListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificate_issuers_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_certificate_issuers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateIssuerListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_certificate_issuers.metadata = {"url": "/certificates/issuers"}

    @overload
    async def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: _models.CertificateIssuerSetParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerSetParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Required.
        :type parameter: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: Union[_models.CertificateIssuerSetParameters, IO],
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Sets the specified certificate issuer.

        The SetCertificateIssuer operation adds or updates the specified certificate issuer. This
        operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer set parameter. Is either a CertificateIssuerSetParameters
         type or a IO type. Required.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerSetParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameter, (IO, bytes)):
            _content = parameter
        else:
            _json = self._serialize.body(parameter, "CertificateIssuerSetParameters")

        request = build_set_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}

    @overload
    async def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: _models.CertificateIssuerUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Required.
        :type parameter: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_certificate_issuer(
        self,
        vault_base_url: str,
        issuer_name: str,
        parameter: Union[_models.CertificateIssuerUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.IssuerBundle:
        """Updates the specified certificate issuer.

        The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
        entity. This operation requires the certificates/setissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :param parameter: Certificate issuer update parameter. Is either a
         CertificateIssuerUpdateParameters type or a IO type. Required.
        :type parameter: ~azure.keyvault.v2016_10_01.models.CertificateIssuerUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameter, (IO, bytes)):
            _content = parameter
        else:
            _json = self._serialize.body(parameter, "CertificateIssuerUpdateParameters")

        request = build_update_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}

    @distributed_trace_async
    async def get_certificate_issuer(
        self, vault_base_url: str, issuer_name: str, **kwargs: Any
    ) -> _models.IssuerBundle:
        """Lists the specified certificate issuer.

        The GetCertificateIssuer operation returns the specified certificate issuer resources in the
        specified key vault. This operation requires the certificates/manageissuers/getissuers
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        request = build_get_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            template_url=self.get_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}

    @distributed_trace_async
    async def delete_certificate_issuer(
        self, vault_base_url: str, issuer_name: str, **kwargs: Any
    ) -> _models.IssuerBundle:
        """Deletes the specified certificate issuer.

        The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
        the vault. This operation requires the certificates/manageissuers/deleteissuers permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param issuer_name: The name of the issuer. Required.
        :type issuer_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IssuerBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.IssuerBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.IssuerBundle] = kwargs.pop("cls", None)

        request = build_delete_certificate_issuer_request(
            issuer_name=issuer_name,
            api_version=api_version,
            template_url=self.delete_certificate_issuer.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("IssuerBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_issuer.metadata = {"url": "/certificates/issuers/{issuer-name}"}

    @overload
    async def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateCreateParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Creates a new certificate.

        If this is the first version, the certificate resource is created. This operation requires the
        certificates/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to create a certificate. Is either a
         CertificateCreateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateCreateParameters")

        request = build_create_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_certificate.metadata = {"url": "/certificates/{certificate-name}/create"}

    @overload
    async def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateImportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. The
        certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM
        format the PEM file must contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateImportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. The
        certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM
        format the PEM file must contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def import_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateImportParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Imports a certificate into a specified key vault.

        Imports an existing valid certificate, containing a private key, into Azure Key Vault. The
        certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM
        format the PEM file must contain the key as well as x509 certificates. This operation requires
        the certificates/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to import the certificate. Is either a
         CertificateImportParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateImportParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateImportParameters")

        request = build_import_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.import_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    import_certificate.metadata = {"url": "/certificates/{certificate-name}/import"}

    @distributed_trace
    def get_certificate_versions(
        self, vault_base_url: str, certificate_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CertificateItem"]:
        """List the versions of a certificate.

        The GetCertificateVersions operation returns the versions of a certificate in the specified key
        vault. This operation requires the certificates/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CertificateItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.CertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_certificate_versions_request(
                    certificate_name=certificate_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_certificate_versions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_certificate_versions.metadata = {"url": "/certificates/{certificate-name}/versions"}

    @distributed_trace_async
    async def get_certificate_policy(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Lists the policy for a certificate.

        The GetCertificatePolicy operation returns the specified certificate policy resources in the
        specified key vault. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in a given key vault. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificatePolicy] = kwargs.pop("cls", None)

        request = build_get_certificate_policy_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_certificate_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificatePolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_policy.metadata = {"url": "/certificates/{certificate-name}/policy"}

    @overload
    async def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: _models.CertificatePolicy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Required.
        :type certificate_policy: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_certificate_policy(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_policy: Union[_models.CertificatePolicy, IO],
        **kwargs: Any
    ) -> _models.CertificatePolicy:
        """Updates the policy for a certificate.

        Set specified members in the certificate policy. Leave others as null. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_policy: The policy for the certificate. Is either a CertificatePolicy type
         or a IO type. Required.
        :type certificate_policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificatePolicy or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificatePolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_policy, (IO, bytes)):
            _content = certificate_policy
        else:
            _json = self._serialize.body(certificate_policy, "CertificatePolicy")

        request = build_update_certificate_policy_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificatePolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_policy.metadata = {"url": "/certificates/{certificate-name}/policy"}

    @overload
    async def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: _models.CertificateUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_version: str,
        parameters: Union[_models.CertificateUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Updates the specified attributes associated with the given certificate.

        The UpdateCertificate operation applies the specified update on the given certificate; the only
        elements updated are the certificate's attributes. This operation requires the
        certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given key vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :param parameters: The parameters for certificate update. Is either a
         CertificateUpdateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateUpdateParameters")

        request = build_update_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate.metadata = {"url": "/certificates/{certificate-name}/{certificate-version}"}

    @distributed_trace_async
    async def get_certificate(
        self, vault_base_url: str, certificate_name: str, certificate_version: str, **kwargs: Any
    ) -> _models.CertificateBundle:
        """Gets information about a certificate.

        Gets information about a specific certificate. This operation requires the certificates/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate in the given vault. Required.
        :type certificate_name: str
        :param certificate_version: The version of the certificate. Required.
        :type certificate_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        request = build_get_certificate_request(
            certificate_name=certificate_name,
            certificate_version=certificate_version,
            api_version=api_version,
            template_url=self.get_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate.metadata = {"url": "/certificates/{certificate-name}/{certificate-version}"}

    @overload
    async def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: _models.CertificateOperationUpdateParameter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation:
         ~azure.keyvault.v2016_10_01.models.CertificateOperationUpdateParameter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Required.
        :type certificate_operation: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_certificate_operation(
        self,
        vault_base_url: str,
        certificate_name: str,
        certificate_operation: Union[_models.CertificateOperationUpdateParameter, IO],
        **kwargs: Any
    ) -> _models.CertificateOperation:
        """Updates a certificate operation.

        Updates a certificate creation operation that is already in progress. This operation requires
        the certificates/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param certificate_operation: The certificate operation response. Is either a
         CertificateOperationUpdateParameter type or a IO type. Required.
        :type certificate_operation:
         ~azure.keyvault.v2016_10_01.models.CertificateOperationUpdateParameter or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_operation, (IO, bytes)):
            _content = certificate_operation
        else:
            _json = self._serialize.body(certificate_operation, "CertificateOperationUpdateParameter")

        request = build_update_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}

    @distributed_trace_async
    async def get_certificate_operation(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateOperation:
        """Gets the creation operation of a certificate.

        Gets the creation operation associated with a specified certificate. This operation requires
        the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        request = build_get_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}

    @distributed_trace_async
    async def delete_certificate_operation(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateOperation:
        """Deletes the creation operation for a specific certificate.

        Deletes the creation operation for a specified certificate that is in the process of being
        created. The certificate is no longer created. This operation requires the certificates/update
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateOperation or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateOperation] = kwargs.pop("cls", None)

        request = build_delete_certificate_operation_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.delete_certificate_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateOperation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_certificate_operation.metadata = {"url": "/certificates/{certificate-name}/pending"}

    @overload
    async def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: _models.CertificateMergeParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateMergeParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def merge_certificate(
        self,
        vault_base_url: str,
        certificate_name: str,
        parameters: Union[_models.CertificateMergeParameters, IO],
        **kwargs: Any
    ) -> _models.CertificateBundle:
        """Merges a certificate or a certificate chain with a key pair existing on the server.

        The MergeCertificate operation performs the merging of a certificate or certificate chain with
        a key pair currently available in the service. This operation requires the certificates/create
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :param parameters: The parameters to merge certificate. Is either a CertificateMergeParameters
         type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.CertificateMergeParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CertificateMergeParameters")

        request = build_merge_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.merge_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    merge_certificate.metadata = {"url": "/certificates/{certificate-name}/pending/merge"}

    @distributed_trace
    def get_deleted_certificates(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.DeletedCertificateItem"]:
        """Lists the deleted certificates in the specified vault currently available for recovery.

        The GetDeletedCertificates operation retrieves the certificates in the current vault which are
        in a deleted state and ready for recovery or purging. This operation includes deletion-specific
        information. This operation requires the certificates/get/list permission. This operation can
        only be enabled on soft-delete enabled vaults.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedCertificateItem or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.DeletedCertificateItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedCertificateListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_deleted_certificates_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_deleted_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeletedCertificateListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_deleted_certificates.metadata = {"url": "/deletedcertificates"}

    @distributed_trace_async
    async def get_deleted_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.DeletedCertificateBundle:
        """Retrieves information about the specified deleted certificate.

        The GetDeletedCertificate operation retrieves the deleted certificate information plus its
        attributes, such as retention interval, scheduled permanent deletion and the current deletion
        recovery level. This operation requires the certificates/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedCertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.DeletedCertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.DeletedCertificateBundle] = kwargs.pop("cls", None)

        request = build_get_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.get_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DeletedCertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}"}

    @distributed_trace_async
    async def purge_deleted_certificate(  # pylint: disable=inconsistent-return-statements
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> None:
        """Permanently deletes the specified deleted certificate.

        The PurgeDeletedCertificate operation performs an irreversible deletion of the specified
        certificate, without possibility for recovery. The operation is not available if the recovery
        level does not specify 'Purgeable'. This operation requires the certificate/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_purge_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.purge_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}"}

    @distributed_trace_async
    async def recover_deleted_certificate(
        self, vault_base_url: str, certificate_name: str, **kwargs: Any
    ) -> _models.CertificateBundle:
        """Recovers the deleted certificate back to its current version under /certificates.

        The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
        operation is applicable in vaults enabled for soft-delete, and must be issued during the
        retention interval (available in the deleted certificate's attributes). This operation requires
        the certificates/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param certificate_name: The name of the deleted certificate. Required.
        :type certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CertificateBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.CertificateBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.CertificateBundle] = kwargs.pop("cls", None)

        request = build_recover_deleted_certificate_request(
            certificate_name=certificate_name,
            api_version=api_version,
            template_url=self.recover_deleted_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CertificateBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    recover_deleted_certificate.metadata = {"url": "/deletedcertificates/{certificate-name}/recover"}

    @distributed_trace
    def get_storage_accounts(
        self, vault_base_url: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.StorageAccountItem"]:
        """List storage accounts managed by the specified key vault. This operation requires the
        storage/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either StorageAccountItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.StorageAccountItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.StorageListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_storage_accounts_request(
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_storage_accounts.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StorageListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_storage_accounts.metadata = {"url": "/storage"}

    @distributed_trace_async
    async def delete_storage_account(
        self, vault_base_url: str, storage_account_name: str, **kwargs: Any
    ) -> _models.StorageBundle:
        """Deletes a storage account. This operation requires the storage/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.StorageBundle] = kwargs.pop("cls", None)

        request = build_delete_storage_account_request(
            storage_account_name=storage_account_name,
            api_version=api_version,
            template_url=self.delete_storage_account.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("StorageBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_storage_account.metadata = {"url": "/storage/{storage-account-name}"}

    @distributed_trace_async
    async def get_storage_account(
        self, vault_base_url: str, storage_account_name: str, **kwargs: Any
    ) -> _models.StorageBundle:
        """Gets information about a specified storage account. This operation requires the storage/get
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.StorageBundle] = kwargs.pop("cls", None)

        request = build_get_storage_account_request(
            storage_account_name=storage_account_name,
            api_version=api_version,
            template_url=self.get_storage_account.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("StorageBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_storage_account.metadata = {"url": "/storage/{storage-account-name}"}

    @overload
    async def set_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: _models.StorageAccountCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Creates or updates a new storage account. This operation requires the storage/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to create a storage account. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Creates or updates a new storage account. This operation requires the storage/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to create a storage account. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: Union[_models.StorageAccountCreateParameters, IO],
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Creates or updates a new storage account. This operation requires the storage/set permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to create a storage account. Is either a
         StorageAccountCreateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "StorageAccountCreateParameters")

        request = build_set_storage_account_request(
            storage_account_name=storage_account_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_storage_account.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("StorageBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_storage_account.metadata = {"url": "/storage/{storage-account-name}"}

    @overload
    async def update_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: _models.StorageAccountUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Updates the specified attributes associated with the given storage account. This operation
        requires the storage/set/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to update a storage account. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Updates the specified attributes associated with the given storage account. This operation
        requires the storage/set/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to update a storage account. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_storage_account(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: Union[_models.StorageAccountUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Updates the specified attributes associated with the given storage account. This operation
        requires the storage/set/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to update a storage account. Is either a
         StorageAccountUpdateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "StorageAccountUpdateParameters")

        request = build_update_storage_account_request(
            storage_account_name=storage_account_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_storage_account.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("StorageBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_storage_account.metadata = {"url": "/storage/{storage-account-name}"}

    @overload
    async def regenerate_storage_account_key(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: _models.StorageAccountRegenerteKeyParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Regenerates the specified key value for the given storage account. This operation requires the
        storage/regeneratekey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to regenerate storage account key. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountRegenerteKeyParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def regenerate_storage_account_key(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Regenerates the specified key value for the given storage account. This operation requires the
        storage/regeneratekey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to regenerate storage account key. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def regenerate_storage_account_key(
        self,
        vault_base_url: str,
        storage_account_name: str,
        parameters: Union[_models.StorageAccountRegenerteKeyParameters, IO],
        **kwargs: Any
    ) -> _models.StorageBundle:
        """Regenerates the specified key value for the given storage account. This operation requires the
        storage/regeneratekey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param parameters: The parameters to regenerate storage account key. Is either a
         StorageAccountRegenerteKeyParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.StorageAccountRegenerteKeyParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StorageBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.StorageBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "StorageAccountRegenerteKeyParameters")

        request = build_regenerate_storage_account_key_request(
            storage_account_name=storage_account_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.regenerate_storage_account_key.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("StorageBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    regenerate_storage_account_key.metadata = {"url": "/storage/{storage-account-name}/regeneratekey"}

    @distributed_trace
    def get_sas_definitions(
        self, vault_base_url: str, storage_account_name: str, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncIterable["_models.SasDefinitionItem"]:
        """List storage SAS definitions for the given storage account. This operation requires the
        storage/listsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param maxresults: Specifies the maximum number of results to return in a page. Setting
         maxresults to a value less than 1 or greater than 25 results in error response code 400 (Bad
         Request). If there are additional results to return, then the service returns a nextLink
         containing a skip token for pagination. In certain cases, the service might return fewer
         results than specified by maxresults (even 0 results) and also return a nextLink. Clients
         should not make any assumptions on the minimum number of results per page, and should enumerate
         all pages until the nextLink becomes null. Default value is None.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SasDefinitionItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.keyvault.v2016_10_01.models.SasDefinitionItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SasDefinitionListResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_sas_definitions_request(
                    storage_account_name=storage_account_name,
                    maxresults=maxresults,
                    api_version=api_version,
                    template_url=self.get_sas_definitions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SasDefinitionListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_sas_definitions.metadata = {"url": "/storage/{storage-account-name}/sas"}

    @distributed_trace_async
    async def delete_sas_definition(
        self, vault_base_url: str, storage_account_name: str, sas_definition_name: str, **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Deletes a SAS definition from a specified storage account. This operation requires the
        storage/deletesas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SasDefinitionBundle] = kwargs.pop("cls", None)

        request = build_delete_sas_definition_request(
            storage_account_name=storage_account_name,
            sas_definition_name=sas_definition_name,
            api_version=api_version,
            template_url=self.delete_sas_definition.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SasDefinitionBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_sas_definition.metadata = {"url": "/storage/{storage-account-name}/sas/{sas-definition-name}"}

    @distributed_trace_async
    async def get_sas_definition(
        self, vault_base_url: str, storage_account_name: str, sas_definition_name: str, **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Gets information about a SAS definition for the specified storage account. This operation
        requires the storage/getsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        cls: ClsType[_models.SasDefinitionBundle] = kwargs.pop("cls", None)

        request = build_get_sas_definition_request(
            storage_account_name=storage_account_name,
            sas_definition_name=sas_definition_name,
            api_version=api_version,
            template_url=self.get_sas_definition.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SasDefinitionBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_sas_definition.metadata = {"url": "/storage/{storage-account-name}/sas/{sas-definition-name}"}

    @overload
    async def set_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: _models.SasDefinitionCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Creates or updates a new SAS definition for the specified storage account. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to create a SAS definition. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Creates or updates a new SAS definition for the specified storage account. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to create a SAS definition. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: Union[_models.SasDefinitionCreateParameters, IO],
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Creates or updates a new SAS definition for the specified storage account. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to create a SAS definition. Is either a
         SasDefinitionCreateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionCreateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SasDefinitionBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SasDefinitionCreateParameters")

        request = build_set_sas_definition_request(
            storage_account_name=storage_account_name,
            sas_definition_name=sas_definition_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_sas_definition.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SasDefinitionBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_sas_definition.metadata = {"url": "/storage/{storage-account-name}/sas/{sas-definition-name}"}

    @overload
    async def update_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: _models.SasDefinitionUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Updates the specified attributes associated with the given SAS definition. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to update a SAS definition. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Updates the specified attributes associated with the given SAS definition. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to update a SAS definition. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_sas_definition(
        self,
        vault_base_url: str,
        storage_account_name: str,
        sas_definition_name: str,
        parameters: Union[_models.SasDefinitionUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.SasDefinitionBundle:
        """Updates the specified attributes associated with the given SAS definition. This operation
        requires the storage/setsas permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net. Required.
        :type vault_base_url: str
        :param storage_account_name: The name of the storage account. Required.
        :type storage_account_name: str
        :param sas_definition_name: The name of the SAS definition. Required.
        :type sas_definition_name: str
        :param parameters: The parameters to update a SAS definition. Is either a
         SasDefinitionUpdateParameters type or a IO type. Required.
        :type parameters: ~azure.keyvault.v2016_10_01.models.SasDefinitionUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SasDefinitionBundle or the result of cls(response)
        :rtype: ~azure.keyvault.v2016_10_01.models.SasDefinitionBundle
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2016-10-01"] = kwargs.pop("api_version", _params.pop("api-version", "2016-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SasDefinitionBundle] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SasDefinitionUpdateParameters")

        request = build_update_sas_definition_request(
            storage_account_name=storage_account_name,
            sas_definition_name=sas_definition_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_sas_definition.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "vaultBaseUrl": self._serialize.url("vault_base_url", vault_base_url, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.KeyVaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("SasDefinitionBundle", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_sas_definition.metadata = {"url": "/storage/{storage-account-name}/sas/{sas-definition-name}"}
