/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.backend.shellcheck;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.sh.ShBundle;
import com.intellij.sh.backend.shellcheck.ShShellcheckExternalAnnotator;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ShQuickFixIntention
implements IntentionAction {
    @FileModifier.SafeFieldForPreview
    private final ShShellcheckExternalAnnotator.Fix fix;
    private final long timestamp;
    @IntentionName
    private final String message;

    public ShQuickFixIntention(@IntentionName String message, ShShellcheckExternalAnnotator.Fix fix, long timestamp) {
        this.timestamp = timestamp;
        this.message = message;
        this.fix = fix;
    }

    @NotNull
    public String getFamilyName() {
        String string = ShBundle.message((String)"sh.shell.script", (Object[])new Object[0]);
        if (string == null) {
            ShQuickFixIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ShQuickFixIntention.$$$reportNull$$$0(1);
        }
        return this.timestamp == psiFile.getModificationStamp();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.message;
        if (string == null) {
            ShQuickFixIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        class Replacement {
            final String replacement;
            final int startOffset;
            final int endOffset;

            Replacement(ShQuickFixIntention this$0, int startOffset, int endOffset, String replacement) {
                this.replacement = replacement;
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }
        }
        if (project == null) {
            ShQuickFixIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        Stream.of(this.fix.replacements).map(it -> {
            int startOffset = ShQuickFixIntention.calcOffset(document, it.line, it.column);
            int endOffset = ShQuickFixIntention.calcOffset(document, it.endLine, it.endColumn);
            return new Replacement(this, startOffset, endOffset, it.replacement);
        }).sorted(Comparator.comparingInt(it -> -it.endOffset)).forEach(it -> document.replaceString(it.startOffset, it.endOffset, (CharSequence)it.replacement));
    }

    private static int calcOffset(Document document, int line, int column) {
        return ShShellcheckUtil.calcOffset((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line - 1), (int)column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/backend/shellcheck/ShQuickFixIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/backend/shellcheck/ShQuickFixIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

