/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
final class PyUnitTestsDebuggingService {
    @NotNull
    private static final Map<XDebugSession, List<Inlay<FailedTestInlayRenderer>>> ourActiveInlays = new WeakHashMap<XDebugSession, List<Inlay<FailedTestInlayRenderer>>>();
    @NotNull
    private static final Map<Inlay<?>, ComponentListener> ourEditorListeners = Maps.newHashMap();
    @NotNull
    private static final Set<String> PYTEST_SET_UP_AND_TEAR_DOWN_FUNCTION_NAMES = ImmutableSet.of((Object)"call_fixture_func", (Object)"_eval_scope_callable", (Object)"_teardown_yield_fixture");
    @NotNull
    private static final Set<String> UNITTEST_SET_UP_AND_TEAR_DOWN_FUNCTION_NAMES = ImmutableSet.of((Object)"_callSetUp", (Object)"_callTearDown");
    @NotNull
    private static final Map<String, Set<String>> SET_UP_AND_TEAR_DOWN_FUNCTIONS_BY_FRAMEWORK = ImmutableMap.of((Object)"pytest", PYTEST_SET_UP_AND_TEAR_DOWN_FUNCTION_NAMES, (Object)"unittest", UNITTEST_SET_UP_AND_TEAR_DOWN_FUNCTION_NAMES);

    PyUnitTestsDebuggingService() {
    }

    public void showFailedTestInlay(@NotNull XDebugSession debugSession, @NotNull PyStackFrame frame, @NotNull String exceptionType, @NotNull String errorMessage, boolean isTestSetUpFail) {
        if (debugSession == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(1);
        }
        if (exceptionType == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(2);
        }
        if (errorMessage == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(3);
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)debugSession.getProject(), () -> {
            XSourcePosition position = frame.getPosition();
            if (position == null) {
                return;
            }
            Consumer<Editor> addInlayToEditor = this.makeAddInlayToEditorFunction(debugSession, frame, exceptionType, errorMessage, isTestSetUpFail);
            Arrays.stream(PyUnitTestsDebuggingService.getAllEditorsForFile(debugSession.getProject(), position.getFile())).forEach(editor2 -> addInlayToEditor.consume(editor2));
        });
    }

    private Consumer<Editor> makeAddInlayToEditorFunction(final @NotNull XDebugSession debugSession, @NotNull PyStackFrame frame, @NotNull String exceptionType, @NotNull String errorMessage, boolean isTestSetUpFail) {
        if (debugSession == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(4);
        }
        if (frame == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(5);
        }
        if (exceptionType == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(6);
        }
        if (errorMessage == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(7);
        }
        return editor2 -> {
            InlayModel inlayModel = editor2.getInlayModel();
            final Inlay inlay = inlayModel.addBlockElement(frame.getPosition().getOffset(), true, false, 0, (EditorCustomElementRenderer)new FailedTestInlayRenderer(exceptionType, errorMessage, isTestSetUpFail));
            if (inlay == null) {
                return;
            }
            ourActiveInlays.putIfAbsent(debugSession, new ArrayList());
            ourActiveInlays.get(debugSession).add((Inlay<FailedTestInlayRenderer>)inlay);
            ComponentAdapter listener2 = new ComponentAdapter(this){

                @Override
                public void componentResized(ComponentEvent e) {
                    Rectangle inlayBounds = inlay.getBounds();
                    if (inlayBounds != null && e.getComponent().getWidth() != inlay.getBounds().width) {
                        inlay.update();
                    }
                }
            };
            editor2.getComponent().addComponentListener(listener2);
            ourEditorListeners.put(inlay, listener2);
            if (isTestSetUpFail) {
                debugSession.addSessionListener(new XDebugSessionListener(){

                    public void sessionResumed() {
                        Disposer.dispose((Disposable)inlay);
                        debugSession.removeSessionListener((XDebugSessionListener)this);
                    }
                });
            }
        };
    }

    public static void removeInlaysAssociatedWithSession(XDebugSession session) {
        List inlays = ourActiveInlays.getOrDefault(session, null);
        if (inlays != null) {
            inlays.forEach(inlay -> {
                inlay.getEditor().getComponent().removeComponentListener(ourEditorListeners.get(inlay));
                ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)inlay));
            });
            ourActiveInlays.remove(session);
        }
    }

    public static boolean isErrorInTestSetUpOrTearDown(@NotNull List<PyStackFrameInfo> frames) {
        if (frames == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(8);
        }
        for (PyStackFrameInfo frameInfo : frames) {
            if (!ContainerUtil.exists(SET_UP_AND_TEAR_DOWN_FUNCTIONS_BY_FRAMEWORK.values(), names -> names.contains(frameInfo.getName()))) continue;
            return true;
        }
        return false;
    }

    private static Editor @NotNull [] getAllEditorsForFile(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor[] fileEditors;
        if (project == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(10);
        }
        if ((fileEditors = FileEditorManager.getInstance((Project)project).getAllEditors(file)).length == 0) {
            Editor[] editorArray;
            Editor editor2 = PyUnitTestsDebuggingService.openEditorForFile(project, file);
            if (editor2 == null) {
                editorArray = Editor.EMPTY_ARRAY;
            } else {
                Editor[] editorArray2 = new Editor[1];
                editorArray = editorArray2;
                editorArray2[0] = PyUnitTestsDebuggingService.openEditorForFile(project, file);
            }
            if (editorArray == null) {
                PyUnitTestsDebuggingService.$$$reportNull$$$0(11);
            }
            return editorArray;
        }
        Editor[] editorArray = (Editor[])Arrays.stream(fileEditors).map(fileEditor -> (TextEditor)fileEditor).map(textEditor -> textEditor.getEditor()).toArray(Editor[]::new);
        if (editorArray == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(12);
        }
        return editorArray;
    }

    @Nullable
    private static Editor openEditorForFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(14);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, 0);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    @NotNull
    private static Color getInlayBackgroundColor() {
        JBColor jBColor = JBColor.isBright() ? new JBColor((Color)Gray._240, (Color)Gray._192) : JBColor.WHITE;
        if (jBColor == null) {
            PyUnitTestsDebuggingService.$$$reportNull$$$0(15);
        }
        return jBColor;
    }

    @Nls
    private static String getFailedTestCaption() {
        return PyBundle.messagePointer("debugger.test.failed.caption", new Object[0]).get();
    }

    @Nls
    private static String getErrorInTestSetUpCaption() {
        return PyBundle.messagePointer("debugger.error.in.test.setup.or.teardown.caption", new Object[0]).get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyUnitTestsDebuggingService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyUnitTestsDebuggingService";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditorsForFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showFailedTestInlay";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeAddInlayToEditorFunction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isErrorInTestSetUpOrTearDown";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditorsForFile";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openEditorForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 15 -> new IllegalStateException(string);
        };
    }

    private static final class FailedTestInlayRenderer
    implements EditorCustomElementRenderer {
        private static final float HEIGHT_FACTOR = 0.5f;
        private static final short RIGHT_BAR_THICKNESS = 2;
        private static final short INLAY_TEXT_INDENT = 10;
        @NotNull
        private final String myExceptionType;
        @NotNull
        private final String myErrorMessage;
        private final boolean myIsTestSetUpFail;
        private int myCurrentLineNumber;

        private FailedTestInlayRenderer(@NotNull String exceptionType, @NotNull String errorMessage, boolean isTestSetUpFail) {
            if (exceptionType == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(0);
            }
            if (errorMessage == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(1);
            }
            this.myCurrentLineNumber = 1;
            this.myExceptionType = exceptionType;
            this.myErrorMessage = StringUtil.trimTrailing((String)errorMessage);
            this.myIsTestSetUpFail = isTestSetUpFail;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(2);
            }
            return inlay.getEditor().getComponent().getWidth();
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(3);
            }
            int lineHeight = inlay.getEditor().getLineHeight();
            return lineHeight + lineHeight * (StringUtil.countNewLines((CharSequence)this.myErrorMessage) + 1) + Math.round((float)lineHeight * 0.5f);
        }

        @NotNull
        public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
            if (inlay == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(4);
            }
            return new FailedTestGutterIconRenderer();
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            if (inlay == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(5);
            }
            if (g == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(6);
            }
            if (targetRegion == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(7);
            }
            if (textAttributes == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(8);
            }
            this.resetCurrentLineNumber();
            g.setColor(PyUnitTestsDebuggingService.getInlayBackgroundColor());
            g.fillRect(targetRegion.x, targetRegion.y, targetRegion.width, targetRegion.height);
            g.setColor(NamedColorUtil.getErrorForeground());
            g.fillRect(targetRegion.x, targetRegion.y, targetRegion.x + 2, this.calcHeightInPixels(inlay));
            g.setFont(FailedTestInlayRenderer.getFont(inlay.getEditor()));
            g.setColor(NamedColorUtil.getErrorForeground());
            this.drawStringToInlayBox((this.myIsTestSetUpFail ? PyUnitTestsDebuggingService.getErrorInTestSetUpCaption() : PyUnitTestsDebuggingService.getFailedTestCaption()) + ":", inlay, g, targetRegion);
            g.setColor(UIUtil.getToolTipForeground());
            String[] lines = StringUtil.splitByLines((String)this.myErrorMessage);
            this.drawStringToInlayBox(this.myExceptionType + ": " + lines[0], inlay, g, targetRegion);
            if (lines.length > 1) {
                for (int k = 1; k < lines.length; ++k) {
                    this.drawStringToInlayBox(lines[k], inlay, g, targetRegion);
                }
            }
        }

        @NotNull
        private static Font getFont(@NotNull Editor editor2) {
            if (editor2 == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(9);
            }
            String fontName = UIUtil.getToolTipFont().getFontName();
            int fontSize = editor2.getColorsScheme().getEditorFontSize();
            FontUIResource fontUIResource = UIUtil.getFontWithFallback((String)fontName, (int)0, (int)fontSize);
            if (fontUIResource == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(10);
            }
            return fontUIResource;
        }

        private void drawStringToInlayBox(@NotNull String str, @NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion) {
            if (str == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(11);
            }
            if (inlay == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(12);
            }
            if (g == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(13);
            }
            if (targetRegion == null) {
                FailedTestInlayRenderer.$$$reportNull$$$0(14);
            }
            g.drawString(str, targetRegion.x + 10, targetRegion.y + inlay.getEditor().getLineHeight() * this.myCurrentLineNumber);
            ++this.myCurrentLineNumber;
        }

        private void resetCurrentLineNumber() {
            this.myCurrentLineNumber = 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyUnitTestsDebuggingService$FailedTestInlayRenderer";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyUnitTestsDebuggingService$FailedTestInlayRenderer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFont";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcWidthInPixels";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcHeightInPixels";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calcGutterIconRenderer";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getFont";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "drawStringToInlayBox";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FailedTestGutterIconRenderer
    extends GutterIconRenderer {
        private static final FailedTestGutterIconRenderer INSTANCE = new FailedTestGutterIconRenderer();

        private FailedTestGutterIconRenderer() {
        }

        public static FailedTestGutterIconRenderer getInstance() {
            return INSTANCE;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
            if (icon == null) {
                FailedTestGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                FailedTestGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return alignment;
        }

        public boolean equals(Object obj) {
            return obj instanceof FailedTestGutterIconRenderer;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/debugger/PyUnitTestsDebuggingService$FailedTestGutterIconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

