/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;
import org.jspecify.annotations.Nullable;

class SerializedOperationProgress
implements SerializedOperation {
    final long id;
    final long time;
    final @Nullable Object details;
    final @Nullable String detailsClassName;

    SerializedOperationProgress(OperationIdentifier id, OperationProgressEvent progressEvent) {
        this.id = id.getId();
        this.time = progressEvent.getTime();
        this.details = BuildOperationTrace.toSerializableModel(progressEvent.getDetails());
        this.detailsClassName = this.details == null ? null : progressEvent.getDetails().getClass().getName();
    }

    SerializedOperationProgress(Map<String, ?> map) {
        this.id = ((Number)map.get("id")).longValue();
        this.time = ((Number)map.get("time")).longValue();
        this.details = map.get("details");
        this.detailsClassName = (String)map.get("detailsClassName");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (this.details != null) {
            map.put((Object)"details", this.details);
            map.put((Object)"detailsClassName", (Object)this.detailsClassName);
        }
        map.put((Object)"id", (Object)this.id);
        map.put((Object)"time", (Object)this.time);
        return map.build();
    }
}

