/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport;

import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.DefaultCacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.DefaultExternalResourceRepository;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ProgressLoggingExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ProgressLoggingExternalResourceLister;
import org.gradle.internal.resource.transfer.ProgressLoggingExternalResourceUploader;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class ResourceConnectorRepositoryTransport
extends AbstractRepositoryTransport {
    private final ExternalResourceRepository repository;
    private final DefaultCacheAwareExternalResourceAccessor resourceAccessor;

    public ResourceConnectorRepositoryTransport(String name, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator, ExternalResourceConnector connector, BuildOperationRunner buildOperationRunner, ExternalResourceCachePolicy cachePolicy, ProducerGuard<ExternalResourceName> producerGuard, FileResourceRepository fileResourceRepository, ChecksumService checksumService) {
        super(name);
        ProgressLoggingExternalResourceUploader loggingUploader = new ProgressLoggingExternalResourceUploader((ExternalResourceUploader)connector, buildOperationRunner);
        ProgressLoggingExternalResourceAccessor loggingAccessor = new ProgressLoggingExternalResourceAccessor((ExternalResourceAccessor)connector, buildOperationRunner);
        ProgressLoggingExternalResourceLister loggingLister = new ProgressLoggingExternalResourceLister((ExternalResourceLister)connector, buildOperationRunner);
        this.repository = new DefaultExternalResourceRepository(name, (ExternalResourceAccessor)loggingAccessor, (ExternalResourceUploader)loggingUploader, (ExternalResourceLister)loggingLister);
        this.resourceAccessor = new DefaultCacheAwareExternalResourceAccessor(this.repository, cachedExternalResourceIndex, timeProvider, temporaryFileProvider, cacheAccessCoordinator, cachePolicy, producerGuard, fileResourceRepository, checksumService);
    }

    @Override
    public ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public boolean isLocal() {
        return false;
    }
}

