/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CompleteComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ThisBuildTreeOnlyComponentResultSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class AdhocHandlingComponentResultSerializer
implements ComponentResultSerializer {
    private final ThisBuildTreeOnlyComponentResultSerializer thisBuildTreeOnlyComponentResultSerializer;
    private final CompleteComponentResultSerializer completeComponentResultSerializer;

    public AdhocHandlingComponentResultSerializer(ThisBuildTreeOnlyComponentResultSerializer thisBuildTreeOnlyComponentResultSerializer, CompleteComponentResultSerializer completeComponentResultSerializer) {
        this.thisBuildTreeOnlyComponentResultSerializer = thisBuildTreeOnlyComponentResultSerializer;
        this.completeComponentResultSerializer = completeComponentResultSerializer;
    }

    @Override
    public void writeComponentResult(Encoder encoder, ResolvedGraphComponent component, boolean includeAllSelectableVariantResults) throws Exception {
        boolean adHoc = component.getResolveState().isAdHoc();
        encoder.writeBoolean(adHoc);
        this.getSerializer(adHoc).writeComponentResult(encoder, component, includeAllSelectableVariantResults);
    }

    @Override
    public void readComponentResult(Decoder decoder, ResolvedComponentVisitor visitor) throws Exception {
        boolean adHoc = decoder.readBoolean();
        this.getSerializer(adHoc).readComponentResult(decoder, visitor);
    }

    private ComponentResultSerializer getSerializer(boolean adhoc) {
        if (adhoc) {
            return this.completeComponentResultSerializer;
        }
        return this.thisBuildTreeOnlyComponentResultSerializer;
    }
}

