/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results;

import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;

public class DefaultVisitedGraphResults
implements VisitedGraphResults {
    private final MinimalResolutionResult resolutionResult;
    private final Set<UnresolvedDependency> unresolvedDependencies;

    public DefaultVisitedGraphResults(MinimalResolutionResult resolutionResult, Set<UnresolvedDependency> unresolvedDependencies) {
        this.resolutionResult = resolutionResult;
        this.unresolvedDependencies = unresolvedDependencies;
    }

    @Override
    public boolean hasAnyFailure() {
        return !this.unresolvedDependencies.isEmpty();
    }

    @Override
    public void visitFailures(Consumer<Throwable> visitor) {
        for (UnresolvedDependency unresolvedDependency : this.unresolvedDependencies) {
            visitor.accept(unresolvedDependency.getProblem());
        }
    }

    @Override
    public MinimalResolutionResult getResolutionResult() {
        return this.resolutionResult;
    }

    @Override
    public Set<UnresolvedDependency> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }
}

