/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractNativeCompileTask
extends DefaultTask {
    private boolean positionIndependentCode;
    private boolean debug;
    private boolean optimize;
    private final ConfigurableFileCollection source;
    private final Map<String, String> macros = new LinkedHashMap<String, String>();
    private transient IncrementalCompilerBuilder.IncrementalCompiler incrementalCompiler;

    public AbstractNativeCompileTask() {
        this.dependsOn(new Object[]{this.getIncludes()});
        this.dependsOn(new Object[]{this.getSystemIncludes()});
        this.source = this.getTaskFileVarFactory().newInputFileCollection((Task)this);
    }

    private IncrementalCompilerBuilder.IncrementalCompiler getIncrementalCompiler() {
        if (this.incrementalCompiler == null) {
            this.incrementalCompiler = this.getIncrementalCompilerBuilder().newCompiler((TaskInternal)this, (FileCollection)this.source, this.getIncludes().plus((FileCollection)this.getSystemIncludes()), this.macros, (Provider<Boolean>)this.getToolChain().map(nativeToolChain -> nativeToolChain instanceof Gcc || nativeToolChain instanceof Clang));
        }
        return this.incrementalCompiler;
    }

    @Inject
    protected abstract TaskFileVarFactory getTaskFileVarFactory();

    @Inject
    protected abstract IncrementalCompilerBuilder getIncrementalCompilerBuilder();

    @Inject
    protected abstract BuildOperationLoggerFactory getOperationLoggerFactory();

    @Inject
    protected abstract FileCollectionFactory getFileCollectionFactory();

    @TaskAction
    protected void compile(InputChanges inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        NativeCompileSpec spec = this.createCompileSpec();
        spec.setTargetPlatform((NativePlatform)this.getTargetPlatform().get());
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.getObjectFileDir().get()).getAsFile());
        spec.include((Iterable)this.getIncludes());
        spec.systemInclude((Iterable)this.getSystemIncludes());
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setPositionIndependentCode(this.isPositionIndependentCode());
        spec.setDebuggable(this.isDebuggable());
        spec.setOptimized(this.isOptimized());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setOperationLogger(operationLogger);
        this.configureSpec(spec);
        NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)this.getToolChain().get();
        NativePlatformInternal nativePlatform = (NativePlatformInternal)this.getTargetPlatform().get();
        PlatformToolProvider platformToolProvider = nativeToolChain.select(nativePlatform);
        this.setDidWork(this.doCompile(spec, platformToolProvider).getDidWork());
    }

    protected void configureSpec(NativeCompileSpec spec) {
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        Compiler incrementalCompiler = this.getIncrementalCompiler().createCompiler(baseCompiler);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return loggingCompiler.execute(spec);
    }

    protected abstract NativeCompileSpec createCompileSpec();

    @Internal
    public abstract Property<NativeToolChain> getToolChain();

    @Nested
    public abstract Property<NativePlatform> getTargetPlatform();

    @Input
    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    @Input
    public boolean isDebuggable() {
        return this.debug;
    }

    public void setDebuggable(boolean debug) {
        this.debug = debug;
    }

    @Input
    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    @OutputDirectory
    public abstract DirectoryProperty getObjectFileDir();

    @Internal(value="The paths for include directories are tracked via the includePaths property, the contents are tracked via discovered inputs")
    public abstract ConfigurableFileCollection getIncludes();

    public void includes(Object includeRoots) {
        this.getIncludes().from(new Object[]{includeRoots});
    }

    @Internal(value="The paths for include directories are tracked via the includePaths property, the contents are tracked via discovered inputs")
    public abstract ConfigurableFileCollection getSystemIncludes();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros.clear();
        this.macros.putAll(macros);
    }

    @Input
    public abstract ListProperty<String> getCompilerArgs();

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    protected FileCollection getHeaderDependencies() {
        return this.getIncrementalCompiler().getHeaderFiles();
    }
}

