/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.problems.failure.StackTraceClassifier;
import org.gradle.internal.problems.failure.StackTraceRelevance;
import org.jspecify.annotations.Nullable;

public class CompositeStackTraceClassifier
implements StackTraceClassifier {
    private final List<StackTraceClassifier> classifiers;

    public CompositeStackTraceClassifier(StackTraceClassifier ... classifiers) {
        this.classifiers = ImmutableList.copyOf((Object[])classifiers);
    }

    public @Nullable StackTraceRelevance classify(StackTraceElement frame) {
        for (StackTraceClassifier classifier : this.classifiers) {
            StackTraceRelevance relevance = classifier.classify(frame);
            if (relevance == null) continue;
            return relevance;
        }
        return null;
    }
}

