/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.UncheckedException;

public class StreamBackedStandardOutputListener
implements StandardOutputListener {
    private final Appendable appendable;
    private final Flushable flushable;

    public StreamBackedStandardOutputListener(Appendable appendable) {
        this.appendable = appendable;
        this.flushable = appendable instanceof Flushable ? (Flushable)((Object)appendable) : new Flushable(){

            @Override
            public void flush() {
            }
        };
    }

    public StreamBackedStandardOutputListener(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream, Charset.defaultCharset()));
    }

    public void onOutput(CharSequence output) {
        try {
            this.appendable.append(output);
            this.flushable.flush();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

