/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.util.List;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.Cast;
import org.gradle.internal.buildprocess.BuildProcessState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConfigurableConnection;
import org.gradle.tooling.internal.protocol.ConnectionMetaDataVersion1;
import org.gradle.tooling.internal.protocol.ConnectionParameters;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalCancellationToken;
import org.gradle.tooling.internal.protocol.InternalInvalidatableVirtualFileSystemConnection;
import org.gradle.tooling.internal.protocol.InternalParameterAcceptingConnection;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.InternalPhasedActionConnection;
import org.gradle.tooling.internal.protocol.InternalStopWhenIdleConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;
import org.gradle.tooling.internal.protocol.ShutdownParameters;
import org.gradle.tooling.internal.protocol.StoppableConnection;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionConnection;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionRequest;
import org.gradle.tooling.internal.provider.ConnectionScopeServices;
import org.gradle.tooling.internal.provider.DefaultConnectionMetaData;
import org.gradle.tooling.internal.provider.InternalCancellationTokenAdapter;
import org.gradle.tooling.internal.provider.ProviderConnection;
import org.gradle.tooling.internal.provider.connection.BuildLogLevelMixIn;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.internal.provider.connection.ProviderConnectionParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.IncubationLogger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnection
implements ConnectionVersion4,
ConfigurableConnection,
InternalCancellableConnection,
InternalParameterAcceptingConnection,
StoppableConnection,
InternalTestExecutionConnection,
InternalPhasedActionConnection,
InternalInvalidatableVirtualFileSystemConnection,
InternalStopWhenIdleConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnection.class);
    private static final String MIN_CLIENT_VERSION_STR = DefaultGradleConnector.MINIMUM_SUPPORTED_GRADLE_VERSION.getVersion();
    public static final int GUARANTEED_TAPI_BACKWARDS_COMPATIBILITY = 5;
    private ProtocolToModelAdapter adapter;
    private BuildProcessState buildProcessState;
    private ProviderConnection connection;
    private @Nullable GradleVersion consumerVersion;

    public DefaultConnection() {
        LOGGER.debug("Tooling API provider {} created.", (Object)GradleVersion.current().getVersion());
    }

    public void configure(ConnectionParameters parameters) {
        ProviderConnectionParameters providerConnectionParameters = (ProviderConnectionParameters)new ProtocolToModelAdapter().adapt(ProviderConnectionParameters.class, (Object)parameters);
        File gradleUserHomeDir = providerConnectionParameters.getGradleUserHomeDir(null);
        if (gradleUserHomeDir == null) {
            gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        this.initializeServices(gradleUserHomeDir);
        this.consumerVersion = GradleVersion.version((String)providerConnectionParameters.getConsumerVersion());
        this.connection.configure(providerConnectionParameters, this.consumerVersion);
    }

    private void initializeServices(File gradleUserHomeDir) {
        NativeServices.initializeOnClient((File)gradleUserHomeDir, (NativeServices.NativeServicesMode)NativeServices.NativeServicesMode.fromSystemProperties());
        ServiceRegistry loggingServices = LoggingServiceRegistry.newEmbeddableLogging();
        this.buildProcessState = new BuildProcessState(true, AgentStatus.disabled(), ClassPath.EMPTY, CurrentGradleInstallation.locate(), new ServiceRegistry[]{loggingServices, NativeServices.getInstance()}){

            protected void addProviders(ServiceRegistryBuilder builder) {
                builder.provider((ServiceRegistrationProvider)new ConnectionScopeServices());
            }
        };
        this.adapter = (ProtocolToModelAdapter)this.buildProcessState.getServices().get(ProtocolToModelAdapter.class);
        this.connection = (ProviderConnection)this.buildProcessState.getServices().get(ProviderConnection.class);
    }

    public ConnectionMetaDataVersion1 getMetaData() {
        return new DefaultConnectionMetaData();
    }

    public void shutdown(ShutdownParameters parameters) {
        this.buildProcessState.close();
    }

    public BuildResult<?> getModel(ModelIdentifier modelIdentifier, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedModelException, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object result = this.connection.run(modelIdentifier.getName(), (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult(result);
    }

    public <T> BuildResult<T> run(InternalBuildAction<T> action, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.run(action, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult(Cast.uncheckedNonnullCast((Object)results));
    }

    public <T> BuildResult<T> run(InternalBuildActionVersion2<T> action, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.run(action, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult(Cast.uncheckedNonnullCast((Object)results));
    }

    public BuildResult<?> run(InternalPhasedAction phasedAction, PhasedActionResultListener listener, InternalCancellationToken cancellationToken, BuildParameters operationParameters) {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.runPhasedAction(phasedAction, listener, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult(results);
    }

    public BuildResult<?> runTests(InternalTestExecutionRequest testExecutionRequest, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        ProviderInternalTestExecutionRequest testExecutionRequestVersion2 = (ProviderInternalTestExecutionRequest)this.adapter.adapt(ProviderInternalTestExecutionRequest.class, (Object)testExecutionRequest);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.runTests(testExecutionRequestVersion2, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult(results);
    }

    private ProviderOperationParameters validateAndConvert(BuildParameters buildParameters) {
        LOGGER.info("Tooling API is using target Gradle version: {}.", (Object)GradleVersion.current().getVersion());
        this.checkUnsupportedTapiVersion();
        ProviderOperationParameters parameters = (ProviderOperationParameters)this.adapter.builder(ProviderOperationParameters.class).mixInTo(ProviderOperationParameters.class, BuildLogLevelMixIn.class).build((Object)buildParameters);
        DeprecationLogger.reset();
        IncubationLogger.reset();
        return parameters;
    }

    private UnsupportedVersionException unsupportedConnectionException() {
        return new UnsupportedVersionException(String.format("Support for clients using a tooling API version older than %s was removed in Gradle %d.0. %sYou should upgrade your tooling API client to version %s or later.", MIN_CLIENT_VERSION_STR, 9, this.createCurrentVersionMessage(), MIN_CLIENT_VERSION_STR));
    }

    private String createCurrentVersionMessage() {
        if (this.consumerVersion == null) {
            return "";
        }
        return String.format("You are currently using tooling API version %s. ", this.consumerVersion.getVersion());
    }

    private void checkUnsupportedTapiVersion() {
        if (this.consumerVersion == null || this.consumerVersion.compareTo(DefaultGradleConnector.MINIMUM_SUPPORTED_GRADLE_VERSION) < 0) {
            throw this.unsupportedConnectionException();
        }
    }

    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths, BuildParameters operationParameters) {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        this.connection.notifyDaemonsAboutChangedPaths(changedPaths, providerParameters);
    }

    public void stopWhenIdle(BuildParameters operationParameters) {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        this.connection.stopWhenIdle(providerParameters);
    }
}

