/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.jspecify.annotations.Nullable;

public class RuleContext {
    private static final ThreadLocal<Deque<ModelRuleDescriptor>> STACK = ThreadLocal.withInitial(ArrayDeque::new);

    public static @Nullable ModelRuleDescriptor get() {
        return STACK.get().peek();
    }

    public static void run(ModelRuleDescriptor descriptor, Runnable runnable) {
        STACK.get().push(descriptor);
        try {
            runnable.run();
        }
        finally {
            STACK.get().pop();
        }
    }
}

