/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.model.internal.type.ModelType;

public abstract class PrimitiveTypes {
    private static final Map<ModelType<?>, Object> TYPES_DEFAULT_VALUES = ImmutableMap.builder().put((Object)ModelType.of(Boolean.TYPE), (Object)false).put((Object)ModelType.of(Character.TYPE), (Object)Character.valueOf('\u0000')).put((Object)ModelType.of(Byte.TYPE), (Object)0).put((Object)ModelType.of(Short.TYPE), (Object)0).put((Object)ModelType.of(Integer.TYPE), (Object)0).put((Object)ModelType.of(Float.TYPE), (Object)Float.valueOf(0.0f)).put((Object)ModelType.of(Long.TYPE), (Object)0L).put((Object)ModelType.of(Double.TYPE), (Object)0.0).build();

    public static boolean isPrimitiveType(ModelType<?> modelType) {
        return TYPES_DEFAULT_VALUES.containsKey(modelType);
    }

    public static Object defaultValueOf(ModelType<?> primitiveModelType) {
        Object defaultValue = TYPES_DEFAULT_VALUES.get(primitiveModelType);
        if (defaultValue == null) {
            throw new IllegalArgumentException(primitiveModelType + " is not a primitive type.");
        }
        return defaultValue;
    }
}

