/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.model.ModelViewClosedException;
import org.gradle.model.ReadOnlyModelViewException;
import org.gradle.model.WriteOnlyModelViewException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

@NotThreadSafe
public class DefaultModelViewState
implements ModelViewState {
    private final ModelPath path;
    private final ModelType<?> type;
    private final ModelRuleDescriptor ruleDescriptor;
    private boolean closed;
    private final boolean mutable;
    private final boolean canReadChildren;

    public DefaultModelViewState(ModelPath path, ModelType<?> type, ModelRuleDescriptor ruleDescriptor, boolean mutable, boolean canReadChildren) {
        this.path = path;
        this.type = type;
        this.ruleDescriptor = ruleDescriptor;
        this.mutable = mutable;
        this.canReadChildren = canReadChildren;
    }

    public void close() {
        this.closed = true;
    }

    public Action<Object> closer() {
        return new Action<Object>(){

            public void execute(Object o) {
                DefaultModelViewState.this.close();
            }
        };
    }

    @Override
    public void assertCanMutate() {
        if (this.closed) {
            throw new ModelViewClosedException(this.path, this.type, this.ruleDescriptor);
        }
        if (!this.mutable) {
            throw new ReadOnlyModelViewException(this.path, this.type, this.ruleDescriptor);
        }
    }

    @Override
    public void assertCanReadChildren() {
        if (!this.canReadChildren) {
            throw new WriteOnlyModelViewException(null, this.path, this.type, this.ruleDescriptor);
        }
    }

    @Override
    public void assertCanReadChild(String name) {
        if (!this.canReadChildren) {
            throw new WriteOnlyModelViewException(name, this.path, this.type, this.ruleDescriptor);
        }
    }

    @Override
    public boolean isCanMutate() {
        return this.mutable && !this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

