/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.component.SoftwareComponentContainerInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.jvm.component.internal.DefaultJvmSoftwareComponent;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.testing.base.TestingExtension;

public abstract class JavaPlugin
implements Plugin<Project> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String COMPILE_ONLY_API_CONFIGURATION_NAME = "compileOnlyApi";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String JAVADOC_ELEMENTS_CONFIGURATION_NAME = "javadocElements";
    public static final String SOURCES_ELEMENTS_CONFIGURATION_NAME = "sourcesElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";

    @Inject
    public JavaPlugin() {
    }

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java-platform")) {
            throw new IllegalStateException("The \"java\" or \"java-library\" plugin cannot be applied together with the \"java-platform\" plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        ProjectInternal projectInternal = (ProjectInternal)project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        project.getPluginManager().apply("org.gradle.jvm-test-suite");
        SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
        project.getComponents().registerBinding(JvmSoftwareComponentInternal.class, DefaultJvmSoftwareComponent.class);
        JvmSoftwareComponentInternal javaComponent = JavaPlugin.createJavaComponent(projectInternal, sourceSets);
        JavaPlugin.configurePublishing(project.getPlugins(), project.getExtensions(), javaComponent.getMainFeature().getSourceSet());
        project.getConfigurations().named("default").configure(conf -> conf.extendsFrom(new Configuration[]{(Configuration)javaComponent.getMainFeature().getRuntimeElementsConfiguration().get()}));
        ((SoftwareComponentContainerInternal)project.getComponents()).getMainComponent().convention((Object)javaComponent);
        DeprecationLogger.whileDisabled(() -> project.getConfigurations().getByName("archives").getArtifacts().addAllLater(javaComponent.getMainFeature().getRuntimeElementsConfiguration().map(conf -> conf.getArtifacts())));
        JavaPlugin.configureTestTaskOrdering(project.getTasks());
        JavaPlugin.configureDiagnostics(project, javaComponent.getMainFeature());
        JavaPlugin.configureBuild(project);
    }

    private static JvmFeatureInternal createMainFeature(ProjectInternal project, SourceSetContainer sourceSets) {
        SourceSet sourceSet = (SourceSet)sourceSets.create("main");
        DefaultJvmFeature feature = new DefaultJvmFeature("main", sourceSet, Collections.emptySet(), project, false);
        feature.withSourceElements();
        return feature;
    }

    private static JvmSoftwareComponentInternal createJavaComponent(ProjectInternal project, SourceSetContainer sourceSets) {
        return (JvmSoftwareComponentInternal)project.getComponents().register("java", JvmSoftwareComponentInternal.class, component -> {
            JvmFeatureInternal mainFeature = JavaPlugin.createMainFeature(project, sourceSets);
            component.getFeatures().add((Object)mainFeature);
            ((DefaultJvmSoftwareComponent)((Object)component)).addVariantsFromConfiguration((Provider)mainFeature.getApiElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("compile", false, mainFeature.getCompileClasspathConfiguration()));
            ((DefaultJvmSoftwareComponent)((Object)component)).addVariantsFromConfiguration((Provider)mainFeature.getRuntimeElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("runtime", false, mainFeature.getRuntimeClasspathConfiguration()));
            JvmTestSuite defaultTestSuite = JavaPlugin.createDefaultTestSuite(mainFeature, (ConfigurationContainer)project.getConfigurations(), (TaskContainer)project.getTasks(), (ExtensionContainer)project.getExtensions(), project.getObjects());
            component.getTestSuites().add((Object)defaultTestSuite);
        }).get();
    }

    private static void configurePublishing(PluginContainer plugins, ExtensionContainer extensions, SourceSet sourceSet) {
        plugins.withType(PublishingPlugin.class, plugin -> {
            PublishingExtension publishing = (PublishingExtension)extensions.getByType(PublishingExtension.class);
            publishing.getPublications().withType(IvyPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
            publishing.getPublications().withType(MavenPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((PublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", sourceSet.getCompileClasspathConfigurationName());
                strategy.defaultResolutionConfiguration("java-runtime", sourceSet.getRuntimeClasspathConfigurationName());
            });
        });
    }

    private static void configureTestTaskOrdering(TaskContainer tasks) {
        TaskCollection jarTasks = tasks.withType(Jar.class);
        tasks.withType(Test.class).configureEach(test -> test.shouldRunAfter(new Object[]{jarTasks}));
    }

    private static JvmTestSuite createDefaultTestSuite(JvmFeatureInternal mainFeature, ConfigurationContainer configurations, TaskContainer tasks, ExtensionContainer extensions, ObjectFactory objectFactory) {
        TestingExtension testing = (TestingExtension)extensions.findByType(TestingExtension.class);
        NamedDomainObjectProvider testSuite = testing.getSuites().register(TEST_TASK_NAME, JvmTestSuite.class, suite -> {
            SourceSet testSourceSet = suite.getSources();
            Configuration testImplementationConfiguration = configurations.getByName(testSourceSet.getImplementationConfigurationName());
            Configuration testRuntimeOnlyConfiguration = configurations.getByName(testSourceSet.getRuntimeOnlyConfigurationName());
            Configuration testCompileClasspathConfiguration = configurations.getByName(testSourceSet.getCompileClasspathConfigurationName());
            Configuration testRuntimeClasspathConfiguration = configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName());
            SourceSet mainSourceSet = mainFeature.getSourceSet();
            SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
            SourceSetOutput testSourceSetOutput = testSourceSet.getOutput();
            testSourceSet.setCompileClasspath((FileCollection)objectFactory.fileCollection().from(new Object[]{mainSourceSetOutput, testCompileClasspathConfiguration}));
            testSourceSet.setRuntimeClasspath((FileCollection)objectFactory.fileCollection().from(new Object[]{testSourceSetOutput, mainSourceSetOutput, testRuntimeClasspathConfiguration}));
            testImplementationConfiguration.extendsFrom(new Configuration[]{configurations.getByName(mainSourceSet.getImplementationConfigurationName())});
            testRuntimeOnlyConfiguration.extendsFrom(new Configuration[]{configurations.getByName(mainSourceSet.getRuntimeOnlyConfigurationName())});
        });
        JvmTestSuite suite2 = (JvmTestSuite)testSuite.get();
        tasks.named("check", task -> task.dependsOn(new Object[]{testSuite}));
        return suite2;
    }

    private static void configureDiagnostics(Project project, JvmFeatureInternal mainFeature) {
        project.getTasks().withType(DependencyInsightReportTask.class).configureEach(task -> new DslObject(task).getConventionMapping().map("configuration", () -> ((JvmFeatureInternal)mainFeature).getCompileClasspathConfiguration()));
    }

    private static void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
        project.getTasks().named("buildDependents", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, false, "buildDependents", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
    }

    private static void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }
}

