/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.HasBuildModel;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.SoftwareFeatureApplicationContext;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.BoundSoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicationContextInternal;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.gradle.plugin.software.internal.SoftwareFeatureSupportInternal;
import org.jspecify.annotations.NullMarked;

public class DefaultSoftwareFeatureApplicator
implements SoftwareFeatureApplicator {
    private final SoftwareFeatureRegistry softwareFeatureRegistry;
    private final ModelDefaultsApplicator modelDefaultsApplicator;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;
    private final PluginManagerInternal pluginManager;
    private final ClassLoaderScope classLoaderScope;
    private final ObjectFactory objectFactory;

    public DefaultSoftwareFeatureApplicator(SoftwareFeatureRegistry softwareFeatureRegistry, ModelDefaultsApplicator modelDefaultsApplicator, InspectionScheme inspectionScheme, InternalProblems problems, PluginManagerInternal pluginManager, ClassLoaderScope classLoaderScope, ObjectFactory objectFactory) {
        this.softwareFeatureRegistry = softwareFeatureRegistry;
        this.modelDefaultsApplicator = modelDefaultsApplicator;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
        this.pluginManager = pluginManager;
        this.classLoaderScope = classLoaderScope;
        this.objectFactory = objectFactory;
    }

    public <T, V> T applyFeatureTo(DynamicObjectAware parentDefinition, SoftwareFeatureImplementation<T, V> softwareFeature) {
        SoftwareFeatureSupportInternal.ProjectFeatureDefinitionContext parentDefinitionContext = SoftwareFeatureSupportInternal.getContext((DynamicObjectAware)parentDefinition);
        SoftwareFeatureSupportInternal.ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult result = parentDefinitionContext.getOrAddChildDefinition(softwareFeature, () -> {
            if (parentDefinition instanceof Project) {
                DefaultSoftwareFeatureApplicator.checkSingleProjectTypeApplication(parentDefinitionContext, softwareFeature);
            }
            this.pluginManager.apply(softwareFeature.getPluginClass());
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(softwareFeature.getPluginClass());
            Object definition = softwareFeature instanceof BoundSoftwareFeatureImplementation ? this.instantiateBoundFeatureObjectsAndApply(parentDefinition, (BoundSoftwareFeatureImplementation)Cast.uncheckedCast((Object)softwareFeature)) : this.instantiateLegacySoftwareTypeDefinition(parentDefinition, softwareFeature, plugin);
            return Cast.uncheckedNonnullCast((Object)definition);
        });
        if (result.isNew) {
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(softwareFeature.getPluginClass());
            this.modelDefaultsApplicator.applyDefaultsTo((Object)parentDefinition, result.definition, (ModelDefaultsApplicator.ClassLoaderContext)new ClassLoaderContextFromScope(this.classLoaderScope), plugin, softwareFeature);
        }
        return (T)Cast.uncheckedNonnullCast((Object)result.definition);
    }

    private static <T, V> void checkSingleProjectTypeApplication(SoftwareFeatureSupportInternal.ProjectFeatureDefinitionContext context, SoftwareFeatureImplementation<T, V> softwareFeature) {
        context.childrenDefinitions().keySet().stream().findFirst().ifPresent(softwareTypeAlreadyApplied -> {
            throw new IllegalStateException("The project has already applied the '" + softwareTypeAlreadyApplied.getFeatureName() + "' software type and is also attempting to apply the '" + softwareFeature.getFeatureName() + "' software type.  Only one software type can be applied to a project.");
        });
    }

    private Object instantiateLegacySoftwareTypeDefinition(Object parentDefinition, SoftwareFeatureImplementation<?, ?> softwareFeature, Plugin<?> plugin) {
        this.applyAndMaybeRegisterExtension(parentDefinition, softwareFeature, plugin);
        return ((ExtensionAware)parentDefinition).getExtensions().getByName(softwareFeature.getFeatureName());
    }

    private <T extends HasBuildModel<V>, V extends BuildModel> T instantiateBoundFeatureObjectsAndApply(Object parentDefinition, BoundSoftwareFeatureImplementation<T, V> softwareFeature) {
        HasBuildModel definition = (HasBuildModel)this.createDefinitionObject(parentDefinition, (SoftwareFeatureImplementation<T, V>)softwareFeature);
        BuildModel buildModelInstance = SoftwareFeatureSupportInternal.createBuildModelInstance((ObjectFactory)this.objectFactory, (HasBuildModel)definition, softwareFeature);
        SoftwareFeatureSupportInternal.attachDefinitionContext((Object)definition, (BuildModel)buildModelInstance, (SoftwareFeatureApplicator)this, (SoftwareFeatureRegistry)this.softwareFeatureRegistry, (ObjectFactory)this.objectFactory);
        SoftwareFeatureApplicationContext applyActionContext = (SoftwareFeatureApplicationContext)this.objectFactory.newInstance(SoftwareFeatureApplicationContextInternal.class, new Object[0]);
        softwareFeature.getBindingTransform().transform(applyActionContext, (Object)definition, (Object)buildModelInstance, Cast.uncheckedCast((Object)parentDefinition));
        return (T)definition;
    }

    private <T, V> T createDefinitionObject(Object target, SoftwareFeatureImplementation<T, V> softwareFeature) {
        Class dslType = softwareFeature.getDefinitionImplementationType();
        if (Named.class.isAssignableFrom(dslType)) {
            if (target instanceof Named) {
                return (T)this.objectFactory.newInstance(softwareFeature.getDefinitionPublicType(), new Object[]{((Named)target).getName()});
            }
            throw new IllegalArgumentException("Cannot infer a name for definition " + dslType.getSimpleName() + " because the parent definition of type " + target.getClass().getSimpleName() + " does not implement Named.");
        }
        return (T)this.objectFactory.newInstance(dslType, new Object[0]);
    }

    private <T, V> void applyAndMaybeRegisterExtension(Object target, SoftwareFeatureImplementation<T, V> softwareFeature, Plugin<?> plugin) {
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType((Class)softwareFeature.getPluginClass(), (boolean)false, (InternalProblems)this.problems);
        ExtensionAddingVisitor extensionAddingVisitor = new ExtensionAddingVisitor((ExtensionAware)target, typeValidationContext, this.softwareFeatureRegistry, this, this.objectFactory);
        this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, extensionAddingVisitor);
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", DefaultSoftwareFeatureApplicator.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private static class ClassLoaderContextFromScope
    implements ModelDefaultsApplicator.ClassLoaderContext {
        private final ClassLoaderScope scope;

        public ClassLoaderContextFromScope(ClassLoaderScope scope) {
            this.scope = scope;
        }

        public ClassLoader getClassLoader() {
            return this.scope.getLocalClassLoader();
        }

        public ClassLoader getParentClassLoader() {
            return this.scope.getParent().getLocalClassLoader();
        }
    }

    @NullMarked
    public static class ExtensionAddingVisitor<T>
    implements PropertyVisitor {
        private final ExtensionAware target;
        private final DefaultTypeValidationContext validationContext;
        private final SoftwareFeatureApplicator applicator;
        private final SoftwareFeatureRegistry softwareFeatureRegistry;
        private final ObjectFactory objectFactory;

        public ExtensionAddingVisitor(ExtensionAware target, DefaultTypeValidationContext validationContext, SoftwareFeatureRegistry softwareFeatureRegistry, SoftwareFeatureApplicator applicator, ObjectFactory objectFactory) {
            this.target = target;
            this.validationContext = validationContext;
            this.softwareFeatureRegistry = softwareFeatureRegistry;
            this.applicator = applicator;
            this.objectFactory = objectFactory;
        }

        public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, Class<?> declaredPropertyType, SoftwareType softwareType) {
            Object publicModelObject = Cast.uncheckedNonnullCast((Object)Objects.requireNonNull(value.call()));
            SoftwareFeatureSupportInternal.attachLegacyDefinitionContext((Object)publicModelObject, (SoftwareFeatureApplicator)this.applicator, (SoftwareFeatureRegistry)this.softwareFeatureRegistry, (ObjectFactory)this.objectFactory);
            if (softwareType.disableModelManagement()) {
                Object extension = this.target.getExtensions().findByName(softwareType.name());
                if (extension == null) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("extension-not-registered-for-software-type", "was not registered as an extension", GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but no extension with name '" + softwareType.name() + "' was registered").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'.").solution("Set 'disableModelManagement' to false or remove the parameter from the @SoftwareType annotation."));
                } else if (extension != publicModelObject) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("mismatched-extension-registered-for-software-type", "does not match the extension registered as '" + softwareType.name(), GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but the extension with name '" + softwareType.name() + "' does not match the value of the property").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'."));
                }
            } else {
                this.target.getExtensions().add(this.publicTypeFrom(softwareType.modelPublicType(), declaredPropertyType), softwareType.name(), publicModelObject);
            }
        }

        private Class<? super T> publicTypeFrom(Class<?> fromAnnotation, Class<?> declaredPropertyType) {
            return (Class)Cast.uncheckedCast(fromAnnotation == Void.class ? declaredPropertyType : fromAnnotation);
        }
    }
}

