/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.net.URL;
import java.util.ArrayList;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class VisitableURLClassLoaderSpecSerializer
implements Serializer<VisitableURLClassLoader.Spec> {
    private static final byte VISITABLE_URL_CLASSLOADER_SPEC = 0;
    private static final byte MIXIN_CLASSLOADER_SPEC = 1;

    public void write(Encoder encoder, VisitableURLClassLoader.Spec spec) throws Exception {
        if (spec instanceof MixInLegacyTypesClassLoader.Spec) {
            encoder.writeByte((byte)1);
        } else {
            encoder.writeByte((byte)0);
        }
        encoder.writeString((CharSequence)spec.getName());
        encoder.writeInt(spec.getClasspath().size());
        for (URL url : spec.getClasspath()) {
            encoder.writeString((CharSequence)url.toString());
        }
    }

    public VisitableURLClassLoader.Spec read(Decoder decoder) throws Exception {
        byte typeTag = decoder.readByte();
        String name = decoder.readString();
        ArrayList<URL> classpath = new ArrayList<URL>();
        int classpathSize = decoder.readInt();
        for (int i = 0; i < classpathSize; ++i) {
            classpath.add(new URL(decoder.readString()));
        }
        switch (typeTag) {
            case 0: {
                return new VisitableURLClassLoader.Spec(name, classpath);
            }
            case 1: {
                return new MixInLegacyTypesClassLoader.Spec(name, classpath);
            }
        }
        throw new IllegalArgumentException("Unexpected payload type.");
    }
}

