/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.daemon.clientinput;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ReadStdInEvent;

class StdInStream
extends InputStream {
    private final OutputEventListener eventDispatch;
    private final Object lock = new Object();
    private byte[] buffer = new byte[0];
    private int readPos;
    private boolean waiting;
    private boolean closed;

    public StdInStream(OutputEventListener eventDispatch) {
        this.eventDispatch = eventDispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waitForContent();
            if (this.readPos != this.buffer.length) {
                return this.buffer[this.readPos++] & 0xFF;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] dest, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.waitForContent();
            if (this.readPos != this.buffer.length) {
                int count = Math.min(length, this.buffer.length - this.readPos);
                System.arraycopy(this.buffer, this.readPos, dest, offset, count);
                this.readPos += count;
                return count;
            }
            return -1;
        }
    }

    private void waitForContent() {
        if (this.readPos == this.buffer.length && !this.waiting && !this.closed) {
            this.eventDispatch.onOutput((OutputEvent)new ReadStdInEvent());
            this.waiting = true;
        }
        while (this.readPos == this.buffer.length && !this.closed) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(byte[] bytes) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.waiting) {
                throw new IllegalStateException();
            }
            this.waiting = false;
            this.readPos = 0;
            this.buffer = bytes;
            this.lock.notifyAll();
        }
    }
}

