/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import org.gradle.internal.DisplayName;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationsParameters;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WaitBuildOperationFiringSynchronizer;
import org.gradle.internal.work.WorkerLeaseService;

@ServiceScope(value={Scope.BuildSession.class})
public class StateTransitionControllerFactory {
    private final WorkerLeaseService workerLeaseService;
    private final BuildOperationsParameters buildOperationsParameters;
    private final BuildOperationRunner buildOperationRunner;

    public StateTransitionControllerFactory(WorkerLeaseService workerLeaseService, BuildOperationsParameters buildOperationsParameters, BuildOperationRunner buildOperationRunner) {
        this.workerLeaseService = workerLeaseService;
        this.buildOperationsParameters = buildOperationsParameters;
        this.buildOperationRunner = buildOperationRunner;
    }

    public <T extends StateTransitionController.State> StateTransitionController<T> newController(DisplayName displayName, T initialState) {
        Synchronizer synchronizer = this.workerLeaseService.newResource();
        if (this.buildOperationsParameters.emitLockingOperations()) {
            synchronizer = new WaitBuildOperationFiringSynchronizer(displayName, synchronizer, this.buildOperationRunner);
        }
        return new StateTransitionController<T>(displayName, initialState, synchronizer);
    }
}

