/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan.edges;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.edges.DependencySuccessorsOnlyNodeSet;

public interface DependencyNodesSet {
    public static final DependencyNodesSet EMPTY = new DependencyNodesSet(){

        @Override
        public Set<Node> getDependencySuccessors() {
            return ImmutableSortedSet.of();
        }

        @Override
        public DependencyNodesSet addDependency(Node toNode) {
            return new DependencySuccessorsOnlyNodeSet().addDependency(toNode);
        }

        @Override
        public Set<Node> getMustSuccessors() {
            return ImmutableSortedSet.of();
        }

        @Override
        public DependencyNodesSet addMustSuccessor(Node toNode) {
            return new DependencySuccessorsOnlyNodeSet().addMustSuccessor(toNode);
        }

        @Override
        public void onNodeComplete(Node node, Node dependency) {
        }

        @Override
        public Node.DependenciesState getState(Node node) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }

        @Override
        public void healthDiagnostics(StringBuilder builder) {
            builder.append("no dependencies");
        }
    };

    public Set<Node> getDependencySuccessors();

    public DependencyNodesSet addDependency(Node var1);

    public Set<Node> getMustSuccessors();

    public DependencyNodesSet addMustSuccessor(Node var1);

    public void onNodeComplete(Node var1, Node var2);

    public Node.DependenciesState getState(Node var1);

    public void healthDiagnostics(StringBuilder var1);
}

