/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.initialization.internal.SharedModelDefaultsInternal;
import org.gradle.api.internal.initialization.ActionBasedDefault;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.gradle.util.internal.ClosureBackedAction;

public class DefaultSharedModelDefaults
implements SharedModelDefaultsInternal,
MethodMixIn {
    private final SoftwareFeatureRegistry softwareFeatureRegistry;
    private final DynamicMethods dynamicMethods = new DynamicMethods();
    private final ThreadLocal<ProjectLayout> projectLayout = new ThreadLocal();

    @Inject
    public DefaultSharedModelDefaults(SoftwareFeatureRegistry softwareFeatureRegistry) {
        this.softwareFeatureRegistry = softwareFeatureRegistry;
    }

    public void setProjectLayout(ProjectLayout projectLayout) {
        this.projectLayout.set(projectLayout);
    }

    public void clearProjectLayout() {
        this.projectLayout.remove();
    }

    public ProjectLayout getLayout() {
        ProjectLayout instance = this.projectLayout.get();
        if (instance == null) {
            throw new GradleException("ProjectLayout should be referenced only inside of software type default configuration blocks");
        }
        return instance;
    }

    public <T> void add(String name, Class<T> publicType, Action<? super T> configureAction) {
        SoftwareFeatureImplementation softwareFeature;
        if (this.softwareFeatureRegistry.getSoftwareFeatureImplementations().containsKey(name)) {
            softwareFeature = (SoftwareFeatureImplementation)this.softwareFeatureRegistry.getSoftwareFeatureImplementations().get(name);
            if (!softwareFeature.getDefinitionPublicType().isAssignableFrom(publicType)) {
                throw new IllegalArgumentException(String.format("Cannot add convention for software type '%s' with public type '%s'. Expected public type to be assignable from '%s'.", name, publicType, softwareFeature.getDefinitionPublicType()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot add convention for unknown software type '%s'.", name));
        }
        softwareFeature.addModelDefault(new ActionBasedDefault<T>(configureAction));
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    class DynamicMethods
    implements MethodAccess {
        DynamicMethods() {
        }

        public boolean hasMethod(String name, Object ... arguments) {
            return arguments.length == 1 && (arguments[0] instanceof Action || arguments[0] instanceof Closure) && DefaultSharedModelDefaults.this.softwareFeatureRegistry.getSoftwareFeatureImplementations().containsKey(name);
        }

        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.hasMethod(name, arguments)) {
                SoftwareFeatureImplementation softwareFeature = (SoftwareFeatureImplementation)DefaultSharedModelDefaults.this.softwareFeatureRegistry.getSoftwareFeatureImplementations().get(name);
                DefaultSharedModelDefaults.this.add(name, softwareFeature.getDefinitionPublicType(), (Action)Cast.uncheckedNonnullCast(this.toAction(arguments[0])));
                return DynamicInvokeResult.found();
            }
            return DynamicInvokeResult.notFound();
        }

        private Action<?> toAction(Object argument) {
            if (argument instanceof Action) {
                return (Action)Cast.uncheckedNonnullCast((Object)argument);
            }
            if (argument instanceof Closure) {
                return ClosureBackedAction.of((Closure)((Closure)argument));
            }
            throw new IllegalArgumentException("Expected an Action or Closure, but received: " + argument);
        }
    }
}

