/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriberRegistry;
import org.gradle.api.internal.initialization.BuildLogicBuilder;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.initialization.ScriptClassPathResolutionContext;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.util.internal.ConfigureUtil;

@NonExtensible
public class DefaultScriptHandler
implements ScriptHandler,
ScriptHandlerInternal {
    public static final String DISABLE_RESET_CONFIGURATION_SYSTEM_PROPERTY = "org.gradle.incubating.reset-buildscript-classpath.disabled";
    private static final Logger LOGGER = Logging.getLogger(DefaultScriptHandler.class);
    private final ResourceLocation scriptResource;
    private final ClassLoaderScope classLoaderScope;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final BuildLogicBuilder buildLogicBuilder;
    private RepositoryHandler repositoryHandler;
    private DependencyHandler dependencyHandler;
    private DependencyLockingHandler dependencyLockingHandler;
    private RoleBasedConfigurationContainerInternal configContainer;
    private ScriptClassPathResolutionContext resolutionContext;
    private Configuration classpathConfiguration;
    private ClassPath resolvedClasspath;

    @Inject
    public DefaultScriptHandler(ScriptSource scriptSource, DependencyResolutionServices dependencyResolutionServices, ClassLoaderScope classLoaderScope, BuildLogicBuilder buildLogicBuilder) {
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.scriptResource = scriptSource.getResource().getLocation();
        this.classLoaderScope = classLoaderScope;
        this.buildLogicBuilder = buildLogicBuilder;
        JavaEcosystemSupport.configureServices((AttributesSchema)dependencyResolutionServices.getAttributesSchema(), (AttributeDescriberRegistry)dependencyResolutionServices.getAttributeDescribers(), (ObjectFactory)dependencyResolutionServices.getObjectFactory());
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencies());
    }

    @Override
    public void addScriptClassPathDependency(Dependency dependency) {
        this.defineConfiguration();
        this.classpathConfiguration.getDependencies().add((Object)dependency);
    }

    @Override
    public ClassPath getScriptClassPath() {
        return ClasspathUtil.getClasspath((ClassLoader)this.getClassLoader());
    }

    @Override
    public ClassPath getInstrumentedScriptClassPath() {
        if (this.resolvedClasspath == null) {
            if (this.classpathConfiguration != null) {
                Factory classPathFactory = () -> this.buildLogicBuilder.resolveClassPath(this.classpathConfiguration, this.resolutionContext);
                this.resolvedClasspath = Boolean.getBoolean(DISABLE_RESET_CONFIGURATION_SYSTEM_PROPERTY) ? (ClassPath)classPathFactory.create() : (ClassPath)((ResettableConfiguration)this.classpathConfiguration).callAndResetResolutionState(classPathFactory);
            } else {
                this.resolvedClasspath = ClassPath.EMPTY;
            }
        }
        return this.resolvedClasspath;
    }

    public DependencyHandler getDependencies() {
        this.defineConfiguration();
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        if (this.repositoryHandler == null) {
            this.repositoryHandler = this.dependencyResolutionServices.getResolveRepositoryHandler();
        }
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRepositories());
    }

    public ConfigurationContainer getConfigurations() {
        this.defineConfiguration();
        return this.configContainer;
    }

    public void configurations(Action<? super ConfigurationContainer> configureClosure) {
        configureClosure.execute((Object)this.getConfigurations());
    }

    private void defineConfiguration() {
        if (this.configContainer == null) {
            this.configContainer = (RoleBasedConfigurationContainerInternal)this.dependencyResolutionServices.getConfigurationContainer();
        }
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.dependencyResolutionServices.getDependencyHandler();
            this.resolutionContext = this.buildLogicBuilder.prepareDependencyHandler(this.dependencyHandler);
        }
        if (this.classpathConfiguration == null) {
            this.classpathConfiguration = this.configContainer.resolvableDependencyScopeLocked("classpath");
            this.configContainer.beforeCollectionChanges(methodName -> {
                throw new InvalidUserCodeException("Cannot mutate " + this.configContainer.getDisplayName() + " using " + methodName + ". Configurations cannot be added or removed from the buildscript configuration container.");
            });
            this.buildLogicBuilder.prepareClassPath(this.classpathConfiguration, this.resolutionContext);
        }
    }

    public void dependencyLocking(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencyLocking());
    }

    public DependencyLockingHandler getDependencyLocking() {
        if (this.dependencyLockingHandler == null) {
            this.dependencyLockingHandler = this.dependencyResolutionServices.getDependencyLockingHandler();
        }
        return this.dependencyLockingHandler;
    }

    public File getSourceFile() {
        return this.scriptResource.getFile();
    }

    public URI getSourceURI() {
        return this.scriptResource.getURI();
    }

    public ClassLoader getClassLoader() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", (Object)this.scriptResource.getDisplayName());
        }
        return this.classLoaderScope.getLocalClassLoader();
    }
}

