/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jansi;

import java.util.HashMap;
import java.util.Map;

public enum JansiOperatingSystemSupport {
    MAC_OS_X("osx"),
    LINUX("linux"),
    WINDOWS("windows");

    private static final Map<String, JansiOperatingSystemSupport> MAPPING;
    private final String identifier;

    private JansiOperatingSystemSupport(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static JansiOperatingSystemSupport forIdentifier(String identifier) {
        return MAPPING.get(identifier);
    }

    static {
        MAPPING = new HashMap<String, JansiOperatingSystemSupport>();
        for (JansiOperatingSystemSupport osSupport : JansiOperatingSystemSupport.values()) {
            MAPPING.put(osSupport.identifier, osSupport);
        }
    }
}

