// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory_h
#define vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory_h

#include "vtkPVVTKExtensionsIOParallelCGNSWriterModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKPVVTKEXTENSIONSIOPARALLELCGNSWRITER_EXPORT vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory : public vtkObjectFactory
{
public:
  static vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory * New();
  vtkTypeMacro(vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkPVVTKExtensionsIOParallelCGNSWriter factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory();

private:
  vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory(const vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory&) = delete;
  void operator=(const vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory_h
