//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/service/ext_proc/v3/external_processor.proto

package ext_procv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/envoyproxy/go-control-plane/envoy/extensions/filters/http/ext_proc/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.ProcessingMode_BodySendMode(0)
)

// Validate checks the field values on ProtocolConfiguration with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ProtocolConfiguration) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProtocolConfiguration with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProtocolConfigurationMultiError, or nil if none found.
func (m *ProtocolConfiguration) ValidateAll() error {
	return m.validate(true)
}

func (m *ProtocolConfiguration) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := v3.ProcessingMode_BodySendMode_name[int32(m.GetRequestBodyMode())]; !ok {
		err := ProtocolConfigurationValidationError{
			field:  "RequestBodyMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := v3.ProcessingMode_BodySendMode_name[int32(m.GetResponseBodyMode())]; !ok {
		err := ProtocolConfigurationValidationError{
			field:  "ResponseBodyMode",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SendBodyWithoutWaitingForHeaderResponse

	if len(errors) > 0 {
		return ProtocolConfigurationMultiError(errors)
	}

	return nil
}

// ProtocolConfigurationMultiError is an error wrapping multiple validation
// errors returned by ProtocolConfiguration.ValidateAll() if the designated
// constraints aren't met.
type ProtocolConfigurationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProtocolConfigurationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProtocolConfigurationMultiError) AllErrors() []error { return m }

// ProtocolConfigurationValidationError is the validation error returned by
// ProtocolConfiguration.Validate if the designated constraints aren't met.
type ProtocolConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProtocolConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProtocolConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProtocolConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProtocolConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProtocolConfigurationValidationError) ErrorName() string {
	return "ProtocolConfigurationValidationError"
}

// Error satisfies the builtin error interface
func (e ProtocolConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProtocolConfiguration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProtocolConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProtocolConfigurationValidationError{}

// Validate checks the field values on ProcessingRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ProcessingRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProcessingRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProcessingRequestMultiError, or nil if none found.
func (m *ProcessingRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ProcessingRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMetadataContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessingRequestValidationError{
					field:  "MetadataContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessingRequestValidationError{
					field:  "MetadataContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessingRequestValidationError{
				field:  "MetadataContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetAttributes()))
		i := 0
		for key := range m.GetAttributes() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetAttributes()[key]
			_ = val

			// no validation rules for Attributes[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, ProcessingRequestValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, ProcessingRequestValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return ProcessingRequestValidationError{
						field:  fmt.Sprintf("Attributes[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	// no validation rules for ObservabilityMode

	if all {
		switch v := interface{}(m.GetProtocolConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessingRequestValidationError{
					field:  "ProtocolConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessingRequestValidationError{
					field:  "ProtocolConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProtocolConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessingRequestValidationError{
				field:  "ProtocolConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofRequestPresent := false
	switch v := m.Request.(type) {
	case *ProcessingRequest_RequestHeaders:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetRequestHeaders()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "RequestHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingRequest_ResponseHeaders:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetResponseHeaders()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "ResponseHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingRequest_RequestBody:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetRequestBody()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestBody()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "RequestBody",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingRequest_ResponseBody:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetResponseBody()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseBody()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "ResponseBody",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingRequest_RequestTrailers:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetRequestTrailers()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "RequestTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestTrailers()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "RequestTrailers",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingRequest_ResponseTrailers:
		if v == nil {
			err := ProcessingRequestValidationError{
				field:  "Request",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRequestPresent = true

		if all {
			switch v := interface{}(m.GetResponseTrailers()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingRequestValidationError{
						field:  "ResponseTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseTrailers()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingRequestValidationError{
					field:  "ResponseTrailers",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRequestPresent {
		err := ProcessingRequestValidationError{
			field:  "Request",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ProcessingRequestMultiError(errors)
	}

	return nil
}

// ProcessingRequestMultiError is an error wrapping multiple validation errors
// returned by ProcessingRequest.ValidateAll() if the designated constraints
// aren't met.
type ProcessingRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProcessingRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProcessingRequestMultiError) AllErrors() []error { return m }

// ProcessingRequestValidationError is the validation error returned by
// ProcessingRequest.Validate if the designated constraints aren't met.
type ProcessingRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProcessingRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProcessingRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProcessingRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProcessingRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProcessingRequestValidationError) ErrorName() string {
	return "ProcessingRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ProcessingRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProcessingRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProcessingRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProcessingRequestValidationError{}

// Validate checks the field values on ProcessingResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ProcessingResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProcessingResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProcessingResponseMultiError, or nil if none found.
func (m *ProcessingResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ProcessingResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetDynamicMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "DynamicMetadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "DynamicMetadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDynamicMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessingResponseValidationError{
				field:  "DynamicMetadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetModeOverride()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "ModeOverride",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "ModeOverride",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetModeOverride()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessingResponseValidationError{
				field:  "ModeOverride",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOverrideMessageTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "OverrideMessageTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ProcessingResponseValidationError{
					field:  "OverrideMessageTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOverrideMessageTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ProcessingResponseValidationError{
				field:  "OverrideMessageTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofResponsePresent := false
	switch v := m.Response.(type) {
	case *ProcessingResponse_RequestHeaders:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetRequestHeaders()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "RequestHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_ResponseHeaders:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetResponseHeaders()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseHeaders",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "ResponseHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_RequestBody:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetRequestBody()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestBody()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "RequestBody",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_ResponseBody:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetResponseBody()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseBody",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseBody()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "ResponseBody",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_RequestTrailers:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetRequestTrailers()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "RequestTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequestTrailers()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "RequestTrailers",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_ResponseTrailers:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetResponseTrailers()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ResponseTrailers",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetResponseTrailers()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "ResponseTrailers",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ProcessingResponse_ImmediateResponse:
		if v == nil {
			err := ProcessingResponseValidationError{
				field:  "Response",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofResponsePresent = true

		if all {
			switch v := interface{}(m.GetImmediateResponse()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ImmediateResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ProcessingResponseValidationError{
						field:  "ImmediateResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetImmediateResponse()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ProcessingResponseValidationError{
					field:  "ImmediateResponse",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofResponsePresent {
		err := ProcessingResponseValidationError{
			field:  "Response",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ProcessingResponseMultiError(errors)
	}

	return nil
}

// ProcessingResponseMultiError is an error wrapping multiple validation errors
// returned by ProcessingResponse.ValidateAll() if the designated constraints
// aren't met.
type ProcessingResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProcessingResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProcessingResponseMultiError) AllErrors() []error { return m }

// ProcessingResponseValidationError is the validation error returned by
// ProcessingResponse.Validate if the designated constraints aren't met.
type ProcessingResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProcessingResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProcessingResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProcessingResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProcessingResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProcessingResponseValidationError) ErrorName() string {
	return "ProcessingResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ProcessingResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProcessingResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProcessingResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProcessingResponseValidationError{}

// Validate checks the field values on HttpHeaders with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpHeaders) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpHeaders with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HttpHeadersMultiError, or
// nil if none found.
func (m *HttpHeaders) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpHeaders) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHeaders()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpHeadersValidationError{
					field:  "Headers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpHeadersValidationError{
					field:  "Headers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeaders()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpHeadersValidationError{
				field:  "Headers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetAttributes()))
		i := 0
		for key := range m.GetAttributes() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetAttributes()[key]
			_ = val

			// no validation rules for Attributes[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, HttpHeadersValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, HttpHeadersValidationError{
							field:  fmt.Sprintf("Attributes[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return HttpHeadersValidationError{
						field:  fmt.Sprintf("Attributes[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	// no validation rules for EndOfStream

	if len(errors) > 0 {
		return HttpHeadersMultiError(errors)
	}

	return nil
}

// HttpHeadersMultiError is an error wrapping multiple validation errors
// returned by HttpHeaders.ValidateAll() if the designated constraints aren't met.
type HttpHeadersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpHeadersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpHeadersMultiError) AllErrors() []error { return m }

// HttpHeadersValidationError is the validation error returned by
// HttpHeaders.Validate if the designated constraints aren't met.
type HttpHeadersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpHeadersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpHeadersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpHeadersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpHeadersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpHeadersValidationError) ErrorName() string { return "HttpHeadersValidationError" }

// Error satisfies the builtin error interface
func (e HttpHeadersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpHeaders.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpHeadersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpHeadersValidationError{}

// Validate checks the field values on HttpBody with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpBody) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpBody with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HttpBodyMultiError, or nil
// if none found.
func (m *HttpBody) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpBody) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Body

	// no validation rules for EndOfStream

	if len(errors) > 0 {
		return HttpBodyMultiError(errors)
	}

	return nil
}

// HttpBodyMultiError is an error wrapping multiple validation errors returned
// by HttpBody.ValidateAll() if the designated constraints aren't met.
type HttpBodyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpBodyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpBodyMultiError) AllErrors() []error { return m }

// HttpBodyValidationError is the validation error returned by
// HttpBody.Validate if the designated constraints aren't met.
type HttpBodyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpBodyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpBodyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpBodyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpBodyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpBodyValidationError) ErrorName() string { return "HttpBodyValidationError" }

// Error satisfies the builtin error interface
func (e HttpBodyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpBody.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpBodyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpBodyValidationError{}

// Validate checks the field values on HttpTrailers with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HttpTrailers) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HttpTrailers with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HttpTrailersMultiError, or
// nil if none found.
func (m *HttpTrailers) ValidateAll() error {
	return m.validate(true)
}

func (m *HttpTrailers) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTrailers()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HttpTrailersValidationError{
					field:  "Trailers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HttpTrailersValidationError{
					field:  "Trailers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTrailers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HttpTrailersValidationError{
				field:  "Trailers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HttpTrailersMultiError(errors)
	}

	return nil
}

// HttpTrailersMultiError is an error wrapping multiple validation errors
// returned by HttpTrailers.ValidateAll() if the designated constraints aren't met.
type HttpTrailersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HttpTrailersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HttpTrailersMultiError) AllErrors() []error { return m }

// HttpTrailersValidationError is the validation error returned by
// HttpTrailers.Validate if the designated constraints aren't met.
type HttpTrailersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HttpTrailersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HttpTrailersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HttpTrailersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HttpTrailersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HttpTrailersValidationError) ErrorName() string { return "HttpTrailersValidationError" }

// Error satisfies the builtin error interface
func (e HttpTrailersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHttpTrailers.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HttpTrailersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HttpTrailersValidationError{}

// Validate checks the field values on HeadersResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *HeadersResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeadersResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HeadersResponseMultiError, or nil if none found.
func (m *HeadersResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *HeadersResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetResponse()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HeadersResponseValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HeadersResponseValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponse()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeadersResponseValidationError{
				field:  "Response",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HeadersResponseMultiError(errors)
	}

	return nil
}

// HeadersResponseMultiError is an error wrapping multiple validation errors
// returned by HeadersResponse.ValidateAll() if the designated constraints
// aren't met.
type HeadersResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeadersResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeadersResponseMultiError) AllErrors() []error { return m }

// HeadersResponseValidationError is the validation error returned by
// HeadersResponse.Validate if the designated constraints aren't met.
type HeadersResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeadersResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeadersResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeadersResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeadersResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeadersResponseValidationError) ErrorName() string { return "HeadersResponseValidationError" }

// Error satisfies the builtin error interface
func (e HeadersResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeadersResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeadersResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeadersResponseValidationError{}

// Validate checks the field values on BodyResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BodyResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BodyResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BodyResponseMultiError, or
// nil if none found.
func (m *BodyResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BodyResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetResponse()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BodyResponseValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BodyResponseValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponse()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BodyResponseValidationError{
				field:  "Response",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return BodyResponseMultiError(errors)
	}

	return nil
}

// BodyResponseMultiError is an error wrapping multiple validation errors
// returned by BodyResponse.ValidateAll() if the designated constraints aren't met.
type BodyResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BodyResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BodyResponseMultiError) AllErrors() []error { return m }

// BodyResponseValidationError is the validation error returned by
// BodyResponse.Validate if the designated constraints aren't met.
type BodyResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BodyResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BodyResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BodyResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BodyResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BodyResponseValidationError) ErrorName() string { return "BodyResponseValidationError" }

// Error satisfies the builtin error interface
func (e BodyResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBodyResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BodyResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BodyResponseValidationError{}

// Validate checks the field values on TrailersResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TrailersResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TrailersResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TrailersResponseMultiError, or nil if none found.
func (m *TrailersResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *TrailersResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHeaderMutation()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TrailersResponseValidationError{
					field:  "HeaderMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TrailersResponseValidationError{
					field:  "HeaderMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeaderMutation()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TrailersResponseValidationError{
				field:  "HeaderMutation",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TrailersResponseMultiError(errors)
	}

	return nil
}

// TrailersResponseMultiError is an error wrapping multiple validation errors
// returned by TrailersResponse.ValidateAll() if the designated constraints
// aren't met.
type TrailersResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TrailersResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TrailersResponseMultiError) AllErrors() []error { return m }

// TrailersResponseValidationError is the validation error returned by
// TrailersResponse.Validate if the designated constraints aren't met.
type TrailersResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TrailersResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TrailersResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TrailersResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TrailersResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TrailersResponseValidationError) ErrorName() string { return "TrailersResponseValidationError" }

// Error satisfies the builtin error interface
func (e TrailersResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTrailersResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TrailersResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TrailersResponseValidationError{}

// Validate checks the field values on CommonResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CommonResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CommonResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CommonResponseMultiError,
// or nil if none found.
func (m *CommonResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *CommonResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := CommonResponse_ResponseStatus_name[int32(m.GetStatus())]; !ok {
		err := CommonResponseValidationError{
			field:  "Status",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetHeaderMutation()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "HeaderMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "HeaderMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeaderMutation()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CommonResponseValidationError{
				field:  "HeaderMutation",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetBodyMutation()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "BodyMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "BodyMutation",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBodyMutation()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CommonResponseValidationError{
				field:  "BodyMutation",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTrailers()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "Trailers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CommonResponseValidationError{
					field:  "Trailers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTrailers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CommonResponseValidationError{
				field:  "Trailers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ClearRouteCache

	if len(errors) > 0 {
		return CommonResponseMultiError(errors)
	}

	return nil
}

// CommonResponseMultiError is an error wrapping multiple validation errors
// returned by CommonResponse.ValidateAll() if the designated constraints
// aren't met.
type CommonResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CommonResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CommonResponseMultiError) AllErrors() []error { return m }

// CommonResponseValidationError is the validation error returned by
// CommonResponse.Validate if the designated constraints aren't met.
type CommonResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CommonResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CommonResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CommonResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CommonResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CommonResponseValidationError) ErrorName() string { return "CommonResponseValidationError" }

// Error satisfies the builtin error interface
func (e CommonResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCommonResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CommonResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CommonResponseValidationError{}

// Validate checks the field values on ImmediateResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ImmediateResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ImmediateResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ImmediateResponseMultiError, or nil if none found.
func (m *ImmediateResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ImmediateResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetStatus() == nil {
		err := ImmediateResponseValidationError{
			field:  "Status",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetStatus()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "Status",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "Status",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStatus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ImmediateResponseValidationError{
				field:  "Status",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHeaders()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "Headers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "Headers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHeaders()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ImmediateResponseValidationError{
				field:  "Headers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Body

	if all {
		switch v := interface{}(m.GetGrpcStatus()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "GrpcStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ImmediateResponseValidationError{
					field:  "GrpcStatus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcStatus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ImmediateResponseValidationError{
				field:  "GrpcStatus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Details

	if len(errors) > 0 {
		return ImmediateResponseMultiError(errors)
	}

	return nil
}

// ImmediateResponseMultiError is an error wrapping multiple validation errors
// returned by ImmediateResponse.ValidateAll() if the designated constraints
// aren't met.
type ImmediateResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ImmediateResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ImmediateResponseMultiError) AllErrors() []error { return m }

// ImmediateResponseValidationError is the validation error returned by
// ImmediateResponse.Validate if the designated constraints aren't met.
type ImmediateResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ImmediateResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ImmediateResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ImmediateResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ImmediateResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ImmediateResponseValidationError) ErrorName() string {
	return "ImmediateResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ImmediateResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sImmediateResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ImmediateResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ImmediateResponseValidationError{}

// Validate checks the field values on GrpcStatus with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GrpcStatus) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GrpcStatus with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GrpcStatusMultiError, or
// nil if none found.
func (m *GrpcStatus) ValidateAll() error {
	return m.validate(true)
}

func (m *GrpcStatus) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Status

	if len(errors) > 0 {
		return GrpcStatusMultiError(errors)
	}

	return nil
}

// GrpcStatusMultiError is an error wrapping multiple validation errors
// returned by GrpcStatus.ValidateAll() if the designated constraints aren't met.
type GrpcStatusMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GrpcStatusMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GrpcStatusMultiError) AllErrors() []error { return m }

// GrpcStatusValidationError is the validation error returned by
// GrpcStatus.Validate if the designated constraints aren't met.
type GrpcStatusValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GrpcStatusValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GrpcStatusValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GrpcStatusValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GrpcStatusValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GrpcStatusValidationError) ErrorName() string { return "GrpcStatusValidationError" }

// Error satisfies the builtin error interface
func (e GrpcStatusValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGrpcStatus.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GrpcStatusValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GrpcStatusValidationError{}

// Validate checks the field values on HeaderMutation with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *HeaderMutation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HeaderMutation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in HeaderMutationMultiError,
// or nil if none found.
func (m *HeaderMutation) ValidateAll() error {
	return m.validate(true)
}

func (m *HeaderMutation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetSetHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  fmt.Sprintf("SetHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, HeaderMutationValidationError{
						field:  fmt.Sprintf("SetHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMutationValidationError{
					field:  fmt.Sprintf("SetHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return HeaderMutationMultiError(errors)
	}

	return nil
}

// HeaderMutationMultiError is an error wrapping multiple validation errors
// returned by HeaderMutation.ValidateAll() if the designated constraints
// aren't met.
type HeaderMutationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HeaderMutationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HeaderMutationMultiError) AllErrors() []error { return m }

// HeaderMutationValidationError is the validation error returned by
// HeaderMutation.Validate if the designated constraints aren't met.
type HeaderMutationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMutationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMutationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMutationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMutationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMutationValidationError) ErrorName() string { return "HeaderMutationValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMutationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMutation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMutationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMutationValidationError{}

// Validate checks the field values on StreamedBodyResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *StreamedBodyResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StreamedBodyResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StreamedBodyResponseMultiError, or nil if none found.
func (m *StreamedBodyResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *StreamedBodyResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Body

	// no validation rules for EndOfStream

	if len(errors) > 0 {
		return StreamedBodyResponseMultiError(errors)
	}

	return nil
}

// StreamedBodyResponseMultiError is an error wrapping multiple validation
// errors returned by StreamedBodyResponse.ValidateAll() if the designated
// constraints aren't met.
type StreamedBodyResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StreamedBodyResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StreamedBodyResponseMultiError) AllErrors() []error { return m }

// StreamedBodyResponseValidationError is the validation error returned by
// StreamedBodyResponse.Validate if the designated constraints aren't met.
type StreamedBodyResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StreamedBodyResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StreamedBodyResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StreamedBodyResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StreamedBodyResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StreamedBodyResponseValidationError) ErrorName() string {
	return "StreamedBodyResponseValidationError"
}

// Error satisfies the builtin error interface
func (e StreamedBodyResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStreamedBodyResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StreamedBodyResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StreamedBodyResponseValidationError{}

// Validate checks the field values on BodyMutation with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BodyMutation) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BodyMutation with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BodyMutationMultiError, or
// nil if none found.
func (m *BodyMutation) ValidateAll() error {
	return m.validate(true)
}

func (m *BodyMutation) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Mutation.(type) {
	case *BodyMutation_Body:
		if v == nil {
			err := BodyMutationValidationError{
				field:  "Mutation",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Body
	case *BodyMutation_ClearBody:
		if v == nil {
			err := BodyMutationValidationError{
				field:  "Mutation",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for ClearBody
	case *BodyMutation_StreamedResponse:
		if v == nil {
			err := BodyMutationValidationError{
				field:  "Mutation",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetStreamedResponse()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BodyMutationValidationError{
						field:  "StreamedResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BodyMutationValidationError{
						field:  "StreamedResponse",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetStreamedResponse()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BodyMutationValidationError{
					field:  "StreamedResponse",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return BodyMutationMultiError(errors)
	}

	return nil
}

// BodyMutationMultiError is an error wrapping multiple validation errors
// returned by BodyMutation.ValidateAll() if the designated constraints aren't met.
type BodyMutationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BodyMutationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BodyMutationMultiError) AllErrors() []error { return m }

// BodyMutationValidationError is the validation error returned by
// BodyMutation.Validate if the designated constraints aren't met.
type BodyMutationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BodyMutationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BodyMutationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BodyMutationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BodyMutationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BodyMutationValidationError) ErrorName() string { return "BodyMutationValidationError" }

// Error satisfies the builtin error interface
func (e BodyMutationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBodyMutation.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BodyMutationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BodyMutationValidationError{}
