// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: workloadapi/security/authorization.proto

package security

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Scope int32

const (
	// ALL means that the authorization policy will be applied to all workloads
	// in the mesh (any namespace).
	Scope_GLOBAL Scope = 0
	// NAMESPACE means that the policy will only be applied to workloads in a
	// specific namespace.
	Scope_NAMESPACE Scope = 1
	// WORKLOAD_SELECTOR means that the policy will only be applied to specific
	// workloads that were selected by their labels.
	Scope_WORKLOAD_SELECTOR Scope = 2
)

// Enum value maps for Scope.
var (
	Scope_name = map[int32]string{
		0: "GLOBAL",
		1: "NAMESPACE",
		2: "WORKLOAD_SELECTOR",
	}
	Scope_value = map[string]int32{
		"GLOBAL":            0,
		"NAMESPACE":         1,
		"WORKLOAD_SELECTOR": 2,
	}
)

func (x Scope) Enum() *Scope {
	p := new(Scope)
	*p = x
	return p
}

func (x Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_security_authorization_proto_enumTypes[0].Descriptor()
}

func (Scope) Type() protoreflect.EnumType {
	return &file_workloadapi_security_authorization_proto_enumTypes[0]
}

func (x Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scope.Descriptor instead.
func (Scope) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{0}
}

type Action int32

const (
	// Allow the request if it matches with the rules.
	Action_ALLOW Action = 0
	// Deny the request if it matches with the rules.
	Action_DENY Action = 1
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0: "ALLOW",
		1: "DENY",
	}
	Action_value = map[string]int32{
		"ALLOW": 0,
		"DENY":  1,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_security_authorization_proto_enumTypes[1].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_workloadapi_security_authorization_proto_enumTypes[1]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{1}
}

type Authorization struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Name      string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Determine the scope of this RBAC policy.
	// If set to NAMESPACE, the 'namespace' field value will be used.
	Scope Scope `protobuf:"varint,3,opt,name=scope,proto3,enum=istio.security.Scope" json:"scope,omitempty"`
	// The action to take if the request is matched with the rules.
	// Default is ALLOW if not specified.
	Action Action `protobuf:"varint,4,opt,name=action,proto3,enum=istio.security.Action" json:"action,omitempty"`
	// Set of RBAC policy groups each containing its rules.
	// If at least one of the groups is matched the policy action will
	// take place.
	// Groups are OR-ed.
	Groups        []*Group `protobuf:"bytes,5,rep,name=groups,proto3" json:"groups,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Authorization) Reset() {
	*x = Authorization{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Authorization) ProtoMessage() {}

func (x *Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Authorization.ProtoReflect.Descriptor instead.
func (*Authorization) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{0}
}

func (x *Authorization) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Authorization) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Authorization) GetScope() Scope {
	if x != nil {
		return x.Scope
	}
	return Scope_GLOBAL
}

func (x *Authorization) GetAction() Action {
	if x != nil {
		return x.Action
	}
	return Action_ALLOW
}

func (x *Authorization) GetGroups() []*Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

type Group struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Rules are AND-ed
	// This is a generic form of the authz policy's to, from and when
	Rules         []*Rules `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Group) Reset() {
	*x = Group{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{1}
}

func (x *Group) GetRules() []*Rules {
	if x != nil {
		return x.Rules
	}
	return nil
}

type Rules struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Conditions within a rule are AND-ed (e.g. ALL conditions must be true)
	Matches       []*Match `protobuf:"bytes,2,rep,name=matches,proto3" json:"matches,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rules) Reset() {
	*x = Rules{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rules) ProtoMessage() {}

func (x *Rules) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rules.ProtoReflect.Descriptor instead.
func (*Rules) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{2}
}

func (x *Rules) GetMatches() []*Match {
	if x != nil {
		return x.Matches
	}
	return nil
}

type Match struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Namespaces          []*StringMatch         `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	NotNamespaces       []*StringMatch         `protobuf:"bytes,2,rep,name=not_namespaces,json=notNamespaces,proto3" json:"not_namespaces,omitempty"`
	ServiceAccounts     []*ServiceAccountMatch `protobuf:"bytes,11,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	NotServiceAccounts  []*ServiceAccountMatch `protobuf:"bytes,12,rep,name=not_service_accounts,json=notServiceAccounts,proto3" json:"not_service_accounts,omitempty"`
	Principals          []*StringMatch         `protobuf:"bytes,3,rep,name=principals,proto3" json:"principals,omitempty"`
	NotPrincipals       []*StringMatch         `protobuf:"bytes,4,rep,name=not_principals,json=notPrincipals,proto3" json:"not_principals,omitempty"`
	SourceIps           []*Address             `protobuf:"bytes,5,rep,name=source_ips,json=sourceIps,proto3" json:"source_ips,omitempty"`
	NotSourceIps        []*Address             `protobuf:"bytes,6,rep,name=not_source_ips,json=notSourceIps,proto3" json:"not_source_ips,omitempty"`
	DestinationIps      []*Address             `protobuf:"bytes,7,rep,name=destination_ips,json=destinationIps,proto3" json:"destination_ips,omitempty"`
	NotDestinationIps   []*Address             `protobuf:"bytes,8,rep,name=not_destination_ips,json=notDestinationIps,proto3" json:"not_destination_ips,omitempty"`
	DestinationPorts    []uint32               `protobuf:"varint,9,rep,packed,name=destination_ports,json=destinationPorts,proto3" json:"destination_ports,omitempty"`
	NotDestinationPorts []uint32               `protobuf:"varint,10,rep,packed,name=not_destination_ports,json=notDestinationPorts,proto3" json:"not_destination_ports,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Match) Reset() {
	*x = Match{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Match) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Match) ProtoMessage() {}

func (x *Match) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Match.ProtoReflect.Descriptor instead.
func (*Match) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{3}
}

func (x *Match) GetNamespaces() []*StringMatch {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

func (x *Match) GetNotNamespaces() []*StringMatch {
	if x != nil {
		return x.NotNamespaces
	}
	return nil
}

func (x *Match) GetServiceAccounts() []*ServiceAccountMatch {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (x *Match) GetNotServiceAccounts() []*ServiceAccountMatch {
	if x != nil {
		return x.NotServiceAccounts
	}
	return nil
}

func (x *Match) GetPrincipals() []*StringMatch {
	if x != nil {
		return x.Principals
	}
	return nil
}

func (x *Match) GetNotPrincipals() []*StringMatch {
	if x != nil {
		return x.NotPrincipals
	}
	return nil
}

func (x *Match) GetSourceIps() []*Address {
	if x != nil {
		return x.SourceIps
	}
	return nil
}

func (x *Match) GetNotSourceIps() []*Address {
	if x != nil {
		return x.NotSourceIps
	}
	return nil
}

func (x *Match) GetDestinationIps() []*Address {
	if x != nil {
		return x.DestinationIps
	}
	return nil
}

func (x *Match) GetNotDestinationIps() []*Address {
	if x != nil {
		return x.NotDestinationIps
	}
	return nil
}

func (x *Match) GetDestinationPorts() []uint32 {
	if x != nil {
		return x.DestinationPorts
	}
	return nil
}

func (x *Match) GetNotDestinationPorts() []uint32 {
	if x != nil {
		return x.NotDestinationPorts
	}
	return nil
}

type Address struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Address       []byte                 `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	Length        uint32                 `protobuf:"varint,2,opt,name=length,proto3" json:"length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{4}
}

func (x *Address) GetAddress() []byte {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *Address) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

type ServiceAccountMatch struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Namespace      string                 `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	ServiceAccount string                 `protobuf:"bytes,2,opt,name=serviceAccount,proto3" json:"serviceAccount,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ServiceAccountMatch) Reset() {
	*x = ServiceAccountMatch{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAccountMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountMatch) ProtoMessage() {}

func (x *ServiceAccountMatch) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountMatch.ProtoReflect.Descriptor instead.
func (*ServiceAccountMatch) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{5}
}

func (x *ServiceAccountMatch) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ServiceAccountMatch) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

type StringMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to MatchType:
	//
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Suffix
	//	*StringMatch_Presence
	MatchType     isStringMatch_MatchType `protobuf_oneof:"match_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StringMatch) Reset() {
	*x = StringMatch{}
	mi := &file_workloadapi_security_authorization_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringMatch) ProtoMessage() {}

func (x *StringMatch) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_security_authorization_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringMatch.ProtoReflect.Descriptor instead.
func (*StringMatch) Descriptor() ([]byte, []int) {
	return file_workloadapi_security_authorization_proto_rawDescGZIP(), []int{6}
}

func (x *StringMatch) GetMatchType() isStringMatch_MatchType {
	if x != nil {
		return x.MatchType
	}
	return nil
}

func (x *StringMatch) GetExact() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Exact); ok {
			return x.Exact
		}
	}
	return ""
}

func (x *StringMatch) GetPrefix() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Prefix); ok {
			return x.Prefix
		}
	}
	return ""
}

func (x *StringMatch) GetSuffix() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Suffix); ok {
			return x.Suffix
		}
	}
	return ""
}

func (x *StringMatch) GetPresence() *emptypb.Empty {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Presence); ok {
			return x.Presence
		}
	}
	return nil
}

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
}

type StringMatch_Exact struct {
	// exact string match
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}

type StringMatch_Prefix struct {
	// prefix-based match
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}

type StringMatch_Suffix struct {
	// suffix-based match
	Suffix string `protobuf:"bytes,3,opt,name=suffix,proto3,oneof"`
}

type StringMatch_Presence struct {
	Presence *emptypb.Empty `protobuf:"bytes,4,opt,name=presence,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType() {}

func (*StringMatch_Prefix) isStringMatch_MatchType() {}

func (*StringMatch_Suffix) isStringMatch_MatchType() {}

func (*StringMatch_Presence) isStringMatch_MatchType() {}

var File_workloadapi_security_authorization_proto protoreflect.FileDescriptor

const file_workloadapi_security_authorization_proto_rawDesc = "" +
	"\n" +
	"(workloadapi/security/authorization.proto\x12\x0eistio.security\x1a\x1bgoogle/protobuf/empty.proto\"\xcd\x01\n" +
	"\rAuthorization\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\x12+\n" +
	"\x05scope\x18\x03 \x01(\x0e2\x15.istio.security.ScopeR\x05scope\x12.\n" +
	"\x06action\x18\x04 \x01(\x0e2\x16.istio.security.ActionR\x06action\x12-\n" +
	"\x06groups\x18\x05 \x03(\v2\x15.istio.security.GroupR\x06groups\"4\n" +
	"\x05Group\x12+\n" +
	"\x05rules\x18\x01 \x03(\v2\x15.istio.security.RulesR\x05rules\"8\n" +
	"\x05Rules\x12/\n" +
	"\amatches\x18\x02 \x03(\v2\x15.istio.security.MatchR\amatches\"\x93\x06\n" +
	"\x05Match\x12;\n" +
	"\n" +
	"namespaces\x18\x01 \x03(\v2\x1b.istio.security.StringMatchR\n" +
	"namespaces\x12B\n" +
	"\x0enot_namespaces\x18\x02 \x03(\v2\x1b.istio.security.StringMatchR\rnotNamespaces\x12N\n" +
	"\x10service_accounts\x18\v \x03(\v2#.istio.security.ServiceAccountMatchR\x0fserviceAccounts\x12U\n" +
	"\x14not_service_accounts\x18\f \x03(\v2#.istio.security.ServiceAccountMatchR\x12notServiceAccounts\x12;\n" +
	"\n" +
	"principals\x18\x03 \x03(\v2\x1b.istio.security.StringMatchR\n" +
	"principals\x12B\n" +
	"\x0enot_principals\x18\x04 \x03(\v2\x1b.istio.security.StringMatchR\rnotPrincipals\x126\n" +
	"\n" +
	"source_ips\x18\x05 \x03(\v2\x17.istio.security.AddressR\tsourceIps\x12=\n" +
	"\x0enot_source_ips\x18\x06 \x03(\v2\x17.istio.security.AddressR\fnotSourceIps\x12@\n" +
	"\x0fdestination_ips\x18\a \x03(\v2\x17.istio.security.AddressR\x0edestinationIps\x12G\n" +
	"\x13not_destination_ips\x18\b \x03(\v2\x17.istio.security.AddressR\x11notDestinationIps\x12+\n" +
	"\x11destination_ports\x18\t \x03(\rR\x10destinationPorts\x122\n" +
	"\x15not_destination_ports\x18\n" +
	" \x03(\rR\x13notDestinationPorts\";\n" +
	"\aAddress\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\fR\aaddress\x12\x16\n" +
	"\x06length\x18\x02 \x01(\rR\x06length\"[\n" +
	"\x13ServiceAccountMatch\x12\x1c\n" +
	"\tnamespace\x18\x01 \x01(\tR\tnamespace\x12&\n" +
	"\x0eserviceAccount\x18\x02 \x01(\tR\x0eserviceAccount\"\x9d\x01\n" +
	"\vStringMatch\x12\x16\n" +
	"\x05exact\x18\x01 \x01(\tH\x00R\x05exact\x12\x18\n" +
	"\x06prefix\x18\x02 \x01(\tH\x00R\x06prefix\x12\x18\n" +
	"\x06suffix\x18\x03 \x01(\tH\x00R\x06suffix\x124\n" +
	"\bpresence\x18\x04 \x01(\v2\x16.google.protobuf.EmptyH\x00R\bpresenceB\f\n" +
	"\n" +
	"match_type*9\n" +
	"\x05Scope\x12\n" +
	"\n" +
	"\x06GLOBAL\x10\x00\x12\r\n" +
	"\tNAMESPACE\x10\x01\x12\x15\n" +
	"\x11WORKLOAD_SELECTOR\x10\x02*\x1d\n" +
	"\x06Action\x12\t\n" +
	"\x05ALLOW\x10\x00\x12\b\n" +
	"\x04DENY\x10\x01B\x1aZ\x18pkg/workloadapi/securityb\x06proto3"

var (
	file_workloadapi_security_authorization_proto_rawDescOnce sync.Once
	file_workloadapi_security_authorization_proto_rawDescData []byte
)

func file_workloadapi_security_authorization_proto_rawDescGZIP() []byte {
	file_workloadapi_security_authorization_proto_rawDescOnce.Do(func() {
		file_workloadapi_security_authorization_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_workloadapi_security_authorization_proto_rawDesc), len(file_workloadapi_security_authorization_proto_rawDesc)))
	})
	return file_workloadapi_security_authorization_proto_rawDescData
}

var file_workloadapi_security_authorization_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_workloadapi_security_authorization_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_workloadapi_security_authorization_proto_goTypes = []any{
	(Scope)(0),                  // 0: istio.security.Scope
	(Action)(0),                 // 1: istio.security.Action
	(*Authorization)(nil),       // 2: istio.security.Authorization
	(*Group)(nil),               // 3: istio.security.Group
	(*Rules)(nil),               // 4: istio.security.Rules
	(*Match)(nil),               // 5: istio.security.Match
	(*Address)(nil),             // 6: istio.security.Address
	(*ServiceAccountMatch)(nil), // 7: istio.security.ServiceAccountMatch
	(*StringMatch)(nil),         // 8: istio.security.StringMatch
	(*emptypb.Empty)(nil),       // 9: google.protobuf.Empty
}
var file_workloadapi_security_authorization_proto_depIdxs = []int32{
	0,  // 0: istio.security.Authorization.scope:type_name -> istio.security.Scope
	1,  // 1: istio.security.Authorization.action:type_name -> istio.security.Action
	3,  // 2: istio.security.Authorization.groups:type_name -> istio.security.Group
	4,  // 3: istio.security.Group.rules:type_name -> istio.security.Rules
	5,  // 4: istio.security.Rules.matches:type_name -> istio.security.Match
	8,  // 5: istio.security.Match.namespaces:type_name -> istio.security.StringMatch
	8,  // 6: istio.security.Match.not_namespaces:type_name -> istio.security.StringMatch
	7,  // 7: istio.security.Match.service_accounts:type_name -> istio.security.ServiceAccountMatch
	7,  // 8: istio.security.Match.not_service_accounts:type_name -> istio.security.ServiceAccountMatch
	8,  // 9: istio.security.Match.principals:type_name -> istio.security.StringMatch
	8,  // 10: istio.security.Match.not_principals:type_name -> istio.security.StringMatch
	6,  // 11: istio.security.Match.source_ips:type_name -> istio.security.Address
	6,  // 12: istio.security.Match.not_source_ips:type_name -> istio.security.Address
	6,  // 13: istio.security.Match.destination_ips:type_name -> istio.security.Address
	6,  // 14: istio.security.Match.not_destination_ips:type_name -> istio.security.Address
	9,  // 15: istio.security.StringMatch.presence:type_name -> google.protobuf.Empty
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_workloadapi_security_authorization_proto_init() }
func file_workloadapi_security_authorization_proto_init() {
	if File_workloadapi_security_authorization_proto != nil {
		return
	}
	file_workloadapi_security_authorization_proto_msgTypes[6].OneofWrappers = []any{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Suffix)(nil),
		(*StringMatch_Presence)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_workloadapi_security_authorization_proto_rawDesc), len(file_workloadapi_security_authorization_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_workloadapi_security_authorization_proto_goTypes,
		DependencyIndexes: file_workloadapi_security_authorization_proto_depIdxs,
		EnumInfos:         file_workloadapi_security_authorization_proto_enumTypes,
		MessageInfos:      file_workloadapi_security_authorization_proto_msgTypes,
	}.Build()
	File_workloadapi_security_authorization_proto = out.File
	file_workloadapi_security_authorization_proto_goTypes = nil
	file_workloadapi_security_authorization_proto_depIdxs = nil
}
