/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
	v1 "sigs.k8s.io/gateway-api/apis/v1"
	apisv1 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1"
)

// ListenerEntryStatusApplyConfiguration represents a declarative configuration of the ListenerEntryStatus type for use
// with apply.
type ListenerEntryStatusApplyConfiguration struct {
	Name           *v1.SectionName                           `json:"name,omitempty"`
	Port           *v1.PortNumber                            `json:"port,omitempty"`
	SupportedKinds []apisv1.RouteGroupKindApplyConfiguration `json:"supportedKinds,omitempty"`
	AttachedRoutes *int32                                    `json:"attachedRoutes,omitempty"`
	Conditions     []metav1.ConditionApplyConfiguration      `json:"conditions,omitempty"`
}

// ListenerEntryStatusApplyConfiguration constructs a declarative configuration of the ListenerEntryStatus type for use with
// apply.
func ListenerEntryStatus() *ListenerEntryStatusApplyConfiguration {
	return &ListenerEntryStatusApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ListenerEntryStatusApplyConfiguration) WithName(value v1.SectionName) *ListenerEntryStatusApplyConfiguration {
	b.Name = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *ListenerEntryStatusApplyConfiguration) WithPort(value v1.PortNumber) *ListenerEntryStatusApplyConfiguration {
	b.Port = &value
	return b
}

// WithSupportedKinds adds the given value to the SupportedKinds field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SupportedKinds field.
func (b *ListenerEntryStatusApplyConfiguration) WithSupportedKinds(values ...*apisv1.RouteGroupKindApplyConfiguration) *ListenerEntryStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSupportedKinds")
		}
		b.SupportedKinds = append(b.SupportedKinds, *values[i])
	}
	return b
}

// WithAttachedRoutes sets the AttachedRoutes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AttachedRoutes field is set to the value of the last call.
func (b *ListenerEntryStatusApplyConfiguration) WithAttachedRoutes(value int32) *ListenerEntryStatusApplyConfiguration {
	b.AttachedRoutes = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *ListenerEntryStatusApplyConfiguration) WithConditions(values ...*metav1.ConditionApplyConfiguration) *ListenerEntryStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}
