// Copyright 2018 The gRPC Authors
// All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// The canonical version of this proto can be found at
// https://github.com/grpc/grpc-proto/blob/master/grpc/binlog/v1/binarylog.proto

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.27.1
// source: grpc/binlog/v1/binarylog.proto

package grpc_binarylog_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumerates the type of event
// Note the terminology is different from the RPC semantics
// definition, but the same meaning is expressed here.
type GrpcLogEntry_EventType int32

const (
	GrpcLogEntry_EVENT_TYPE_UNKNOWN GrpcLogEntry_EventType = 0
	// Header sent from client to server
	GrpcLogEntry_EVENT_TYPE_CLIENT_HEADER GrpcLogEntry_EventType = 1
	// Header sent from server to client
	GrpcLogEntry_EVENT_TYPE_SERVER_HEADER GrpcLogEntry_EventType = 2
	// Message sent from client to server
	GrpcLogEntry_EVENT_TYPE_CLIENT_MESSAGE GrpcLogEntry_EventType = 3
	// Message sent from server to client
	GrpcLogEntry_EVENT_TYPE_SERVER_MESSAGE GrpcLogEntry_EventType = 4
	// A signal that client is done sending
	GrpcLogEntry_EVENT_TYPE_CLIENT_HALF_CLOSE GrpcLogEntry_EventType = 5
	// Trailer indicates the end of the RPC.
	// On client side, this event means a trailer was either received
	// from the network or the gRPC library locally generated a status
	// to inform the application about a failure.
	// On server side, this event means the server application requested
	// to send a trailer. Note: EVENT_TYPE_CANCEL may still arrive after
	// this due to races on server side.
	GrpcLogEntry_EVENT_TYPE_SERVER_TRAILER GrpcLogEntry_EventType = 6
	// A signal that the RPC is cancelled. On client side, this
	// indicates the client application requests a cancellation.
	// On server side, this indicates that cancellation was detected.
	// Note: This marks the end of the RPC. Events may arrive after
	// this due to races. For example, on client side a trailer
	// may arrive even though the application requested to cancel the RPC.
	GrpcLogEntry_EVENT_TYPE_CANCEL GrpcLogEntry_EventType = 7
)

// Enum value maps for GrpcLogEntry_EventType.
var (
	GrpcLogEntry_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNKNOWN",
		1: "EVENT_TYPE_CLIENT_HEADER",
		2: "EVENT_TYPE_SERVER_HEADER",
		3: "EVENT_TYPE_CLIENT_MESSAGE",
		4: "EVENT_TYPE_SERVER_MESSAGE",
		5: "EVENT_TYPE_CLIENT_HALF_CLOSE",
		6: "EVENT_TYPE_SERVER_TRAILER",
		7: "EVENT_TYPE_CANCEL",
	}
	GrpcLogEntry_EventType_value = map[string]int32{
		"EVENT_TYPE_UNKNOWN":           0,
		"EVENT_TYPE_CLIENT_HEADER":     1,
		"EVENT_TYPE_SERVER_HEADER":     2,
		"EVENT_TYPE_CLIENT_MESSAGE":    3,
		"EVENT_TYPE_SERVER_MESSAGE":    4,
		"EVENT_TYPE_CLIENT_HALF_CLOSE": 5,
		"EVENT_TYPE_SERVER_TRAILER":    6,
		"EVENT_TYPE_CANCEL":            7,
	}
)

func (x GrpcLogEntry_EventType) Enum() *GrpcLogEntry_EventType {
	p := new(GrpcLogEntry_EventType)
	*p = x
	return p
}

func (x GrpcLogEntry_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GrpcLogEntry_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_binlog_v1_binarylog_proto_enumTypes[0].Descriptor()
}

func (GrpcLogEntry_EventType) Type() protoreflect.EnumType {
	return &file_grpc_binlog_v1_binarylog_proto_enumTypes[0]
}

func (x GrpcLogEntry_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GrpcLogEntry_EventType.Descriptor instead.
func (GrpcLogEntry_EventType) EnumDescriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{0, 0}
}

// Enumerates the entity that generates the log entry
type GrpcLogEntry_Logger int32

const (
	GrpcLogEntry_LOGGER_UNKNOWN GrpcLogEntry_Logger = 0
	GrpcLogEntry_LOGGER_CLIENT  GrpcLogEntry_Logger = 1
	GrpcLogEntry_LOGGER_SERVER  GrpcLogEntry_Logger = 2
)

// Enum value maps for GrpcLogEntry_Logger.
var (
	GrpcLogEntry_Logger_name = map[int32]string{
		0: "LOGGER_UNKNOWN",
		1: "LOGGER_CLIENT",
		2: "LOGGER_SERVER",
	}
	GrpcLogEntry_Logger_value = map[string]int32{
		"LOGGER_UNKNOWN": 0,
		"LOGGER_CLIENT":  1,
		"LOGGER_SERVER":  2,
	}
)

func (x GrpcLogEntry_Logger) Enum() *GrpcLogEntry_Logger {
	p := new(GrpcLogEntry_Logger)
	*p = x
	return p
}

func (x GrpcLogEntry_Logger) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GrpcLogEntry_Logger) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_binlog_v1_binarylog_proto_enumTypes[1].Descriptor()
}

func (GrpcLogEntry_Logger) Type() protoreflect.EnumType {
	return &file_grpc_binlog_v1_binarylog_proto_enumTypes[1]
}

func (x GrpcLogEntry_Logger) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GrpcLogEntry_Logger.Descriptor instead.
func (GrpcLogEntry_Logger) EnumDescriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{0, 1}
}

type Address_Type int32

const (
	Address_TYPE_UNKNOWN Address_Type = 0
	// address is in 1.2.3.4 form
	Address_TYPE_IPV4 Address_Type = 1
	// address is in IPv6 canonical form (RFC5952 section 4)
	// The scope is NOT included in the address string.
	Address_TYPE_IPV6 Address_Type = 2
	// address is UDS string
	Address_TYPE_UNIX Address_Type = 3
)

// Enum value maps for Address_Type.
var (
	Address_Type_name = map[int32]string{
		0: "TYPE_UNKNOWN",
		1: "TYPE_IPV4",
		2: "TYPE_IPV6",
		3: "TYPE_UNIX",
	}
	Address_Type_value = map[string]int32{
		"TYPE_UNKNOWN": 0,
		"TYPE_IPV4":    1,
		"TYPE_IPV6":    2,
		"TYPE_UNIX":    3,
	}
)

func (x Address_Type) Enum() *Address_Type {
	p := new(Address_Type)
	*p = x
	return p
}

func (x Address_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_binlog_v1_binarylog_proto_enumTypes[2].Descriptor()
}

func (Address_Type) Type() protoreflect.EnumType {
	return &file_grpc_binlog_v1_binarylog_proto_enumTypes[2]
}

func (x Address_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Type.Descriptor instead.
func (Address_Type) EnumDescriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{7, 0}
}

// Log entry we store in binary logs
type GrpcLogEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The timestamp of the binary log message
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Uniquely identifies a call. The value must not be 0 in order to disambiguate
	// from an unset value.
	// Each call may have several log entries, they will all have the same call_id.
	// Nothing is guaranteed about their value other than they are unique across
	// different RPCs in the same gRPC process.
	CallId uint64 `protobuf:"varint,2,opt,name=call_id,json=callId,proto3" json:"call_id,omitempty"`
	// The entry sequence id for this call. The first GrpcLogEntry has a
	// value of 1, to disambiguate from an unset value. The purpose of
	// this field is to detect missing entries in environments where
	// durability or ordering is not guaranteed.
	SequenceIdWithinCall uint64                 `protobuf:"varint,3,opt,name=sequence_id_within_call,json=sequenceIdWithinCall,proto3" json:"sequence_id_within_call,omitempty"`
	Type                 GrpcLogEntry_EventType `protobuf:"varint,4,opt,name=type,proto3,enum=grpc.binarylog.v1.GrpcLogEntry_EventType" json:"type,omitempty"`
	Logger               GrpcLogEntry_Logger    `protobuf:"varint,5,opt,name=logger,proto3,enum=grpc.binarylog.v1.GrpcLogEntry_Logger" json:"logger,omitempty"` // One of the above Logger enum
	// The logger uses one of the following fields to record the payload,
	// according to the type of the log entry.
	//
	// Types that are valid to be assigned to Payload:
	//
	//	*GrpcLogEntry_ClientHeader
	//	*GrpcLogEntry_ServerHeader
	//	*GrpcLogEntry_Message
	//	*GrpcLogEntry_Trailer
	Payload isGrpcLogEntry_Payload `protobuf_oneof:"payload"`
	// true if payload does not represent the full message or metadata.
	PayloadTruncated bool `protobuf:"varint,10,opt,name=payload_truncated,json=payloadTruncated,proto3" json:"payload_truncated,omitempty"`
	// Peer address information, will only be recorded on the first
	// incoming event. On client side, peer is logged on
	// EVENT_TYPE_SERVER_HEADER normally or EVENT_TYPE_SERVER_TRAILER in
	// the case of trailers-only. On server side, peer is always
	// logged on EVENT_TYPE_CLIENT_HEADER.
	Peer          *Address `protobuf:"bytes,11,opt,name=peer,proto3" json:"peer,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GrpcLogEntry) Reset() {
	*x = GrpcLogEntry{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GrpcLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcLogEntry) ProtoMessage() {}

func (x *GrpcLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcLogEntry.ProtoReflect.Descriptor instead.
func (*GrpcLogEntry) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{0}
}

func (x *GrpcLogEntry) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *GrpcLogEntry) GetCallId() uint64 {
	if x != nil {
		return x.CallId
	}
	return 0
}

func (x *GrpcLogEntry) GetSequenceIdWithinCall() uint64 {
	if x != nil {
		return x.SequenceIdWithinCall
	}
	return 0
}

func (x *GrpcLogEntry) GetType() GrpcLogEntry_EventType {
	if x != nil {
		return x.Type
	}
	return GrpcLogEntry_EVENT_TYPE_UNKNOWN
}

func (x *GrpcLogEntry) GetLogger() GrpcLogEntry_Logger {
	if x != nil {
		return x.Logger
	}
	return GrpcLogEntry_LOGGER_UNKNOWN
}

func (x *GrpcLogEntry) GetPayload() isGrpcLogEntry_Payload {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *GrpcLogEntry) GetClientHeader() *ClientHeader {
	if x != nil {
		if x, ok := x.Payload.(*GrpcLogEntry_ClientHeader); ok {
			return x.ClientHeader
		}
	}
	return nil
}

func (x *GrpcLogEntry) GetServerHeader() *ServerHeader {
	if x != nil {
		if x, ok := x.Payload.(*GrpcLogEntry_ServerHeader); ok {
			return x.ServerHeader
		}
	}
	return nil
}

func (x *GrpcLogEntry) GetMessage() *Message {
	if x != nil {
		if x, ok := x.Payload.(*GrpcLogEntry_Message); ok {
			return x.Message
		}
	}
	return nil
}

func (x *GrpcLogEntry) GetTrailer() *Trailer {
	if x != nil {
		if x, ok := x.Payload.(*GrpcLogEntry_Trailer); ok {
			return x.Trailer
		}
	}
	return nil
}

func (x *GrpcLogEntry) GetPayloadTruncated() bool {
	if x != nil {
		return x.PayloadTruncated
	}
	return false
}

func (x *GrpcLogEntry) GetPeer() *Address {
	if x != nil {
		return x.Peer
	}
	return nil
}

type isGrpcLogEntry_Payload interface {
	isGrpcLogEntry_Payload()
}

type GrpcLogEntry_ClientHeader struct {
	ClientHeader *ClientHeader `protobuf:"bytes,6,opt,name=client_header,json=clientHeader,proto3,oneof"`
}

type GrpcLogEntry_ServerHeader struct {
	ServerHeader *ServerHeader `protobuf:"bytes,7,opt,name=server_header,json=serverHeader,proto3,oneof"`
}

type GrpcLogEntry_Message struct {
	// Used by EVENT_TYPE_CLIENT_MESSAGE, EVENT_TYPE_SERVER_MESSAGE
	Message *Message `protobuf:"bytes,8,opt,name=message,proto3,oneof"`
}

type GrpcLogEntry_Trailer struct {
	Trailer *Trailer `protobuf:"bytes,9,opt,name=trailer,proto3,oneof"`
}

func (*GrpcLogEntry_ClientHeader) isGrpcLogEntry_Payload() {}

func (*GrpcLogEntry_ServerHeader) isGrpcLogEntry_Payload() {}

func (*GrpcLogEntry_Message) isGrpcLogEntry_Payload() {}

func (*GrpcLogEntry_Trailer) isGrpcLogEntry_Payload() {}

type ClientHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This contains only the metadata from the application.
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The name of the RPC method, which looks something like:
	// /<service>/<method>
	// Note the leading "/" character.
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// A single process may be used to run multiple virtual
	// servers with different identities.
	// The authority is the name of such a server identity.
	// It is typically a portion of the URI in the form of
	// <host> or <host>:<port> .
	Authority string `protobuf:"bytes,3,opt,name=authority,proto3" json:"authority,omitempty"`
	// the RPC timeout
	Timeout       *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClientHeader) Reset() {
	*x = ClientHeader{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientHeader) ProtoMessage() {}

func (x *ClientHeader) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientHeader.ProtoReflect.Descriptor instead.
func (*ClientHeader) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{1}
}

func (x *ClientHeader) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ClientHeader) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *ClientHeader) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *ClientHeader) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

type ServerHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This contains only the metadata from the application.
	Metadata      *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServerHeader) Reset() {
	*x = ServerHeader{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerHeader) ProtoMessage() {}

func (x *ServerHeader) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerHeader.ProtoReflect.Descriptor instead.
func (*ServerHeader) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{2}
}

func (x *ServerHeader) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type Trailer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This contains only the metadata from the application.
	Metadata *Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The gRPC status code.
	StatusCode uint32 `protobuf:"varint,2,opt,name=status_code,json=statusCode,proto3" json:"status_code,omitempty"`
	// An original status message before any transport specific
	// encoding.
	StatusMessage string `protobuf:"bytes,3,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// The value of the 'grpc-status-details-bin' metadata key. If
	// present, this is always an encoded 'google.rpc.Status' message.
	StatusDetails []byte `protobuf:"bytes,4,opt,name=status_details,json=statusDetails,proto3" json:"status_details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Trailer) Reset() {
	*x = Trailer{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Trailer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trailer) ProtoMessage() {}

func (x *Trailer) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trailer.ProtoReflect.Descriptor instead.
func (*Trailer) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{3}
}

func (x *Trailer) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Trailer) GetStatusCode() uint32 {
	if x != nil {
		return x.StatusCode
	}
	return 0
}

func (x *Trailer) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Trailer) GetStatusDetails() []byte {
	if x != nil {
		return x.StatusDetails
	}
	return nil
}

// Message payload, used by CLIENT_MESSAGE and SERVER_MESSAGE
type Message struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Length of the message. It may not be the same as the length of the
	// data field, as the logging payload can be truncated or omitted.
	Length uint32 `protobuf:"varint,1,opt,name=length,proto3" json:"length,omitempty"`
	// May be truncated or omitted.
	Data          []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Message) Reset() {
	*x = Message{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{4}
}

func (x *Message) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *Message) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// A list of metadata pairs, used in the payload of client header,
// server header, and server trailer.
// Implementations may omit some entries to honor the header limits
// of GRPC_BINARY_LOG_CONFIG.
//
// Header keys added by gRPC are omitted. To be more specific,
// implementations will not log the following entries, and this is
// not to be treated as a truncation:
//   - entries handled by grpc that are not user visible, such as those
//     that begin with 'grpc-' (with exception of grpc-trace-bin)
//     or keys like 'lb-token'
//   - transport specific entries, including but not limited to:
//     ':path', ':authority', 'content-encoding', 'user-agent', 'te', etc
//   - entries added for call credentials
//
// Implementations must always log grpc-trace-bin if it is present.
// Practically speaking it will only be visible on server side because
// grpc-trace-bin is managed by low level client side mechanisms
// inaccessible from the application level. On server side, the
// header is just a normal metadata key.
// The pair will not count towards the size limit.
type Metadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entry         []*MetadataEntry       `protobuf:"bytes,1,rep,name=entry,proto3" json:"entry,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{5}
}

func (x *Metadata) GetEntry() []*MetadataEntry {
	if x != nil {
		return x.Entry
	}
	return nil
}

// A metadata key value pair
type MetadataEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           string                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         []byte                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetadataEntry) Reset() {
	*x = MetadataEntry{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataEntry) ProtoMessage() {}

func (x *MetadataEntry) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataEntry.ProtoReflect.Descriptor instead.
func (*MetadataEntry) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{6}
}

func (x *MetadataEntry) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *MetadataEntry) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Address information
type Address struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Type    Address_Type           `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.binarylog.v1.Address_Type" json:"type,omitempty"`
	Address string                 `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// only for TYPE_IPV4 and TYPE_IPV6
	IpPort        uint32 `protobuf:"varint,3,opt,name=ip_port,json=ipPort,proto3" json:"ip_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_binlog_v1_binarylog_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_grpc_binlog_v1_binarylog_proto_rawDescGZIP(), []int{7}
}

func (x *Address) GetType() Address_Type {
	if x != nil {
		return x.Type
	}
	return Address_TYPE_UNKNOWN
}

func (x *Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Address) GetIpPort() uint32 {
	if x != nil {
		return x.IpPort
	}
	return 0
}

var File_grpc_binlog_v1_binarylog_proto protoreflect.FileDescriptor

const file_grpc_binlog_v1_binarylog_proto_rawDesc = "" +
	"\n" +
	"\x1egrpc/binlog/v1/binarylog.proto\x12\x11grpc.binarylog.v1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xbb\a\n" +
	"\fGrpcLogEntry\x128\n" +
	"\ttimestamp\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\ttimestamp\x12\x17\n" +
	"\acall_id\x18\x02 \x01(\x04R\x06callId\x125\n" +
	"\x17sequence_id_within_call\x18\x03 \x01(\x04R\x14sequenceIdWithinCall\x12=\n" +
	"\x04type\x18\x04 \x01(\x0e2).grpc.binarylog.v1.GrpcLogEntry.EventTypeR\x04type\x12>\n" +
	"\x06logger\x18\x05 \x01(\x0e2&.grpc.binarylog.v1.GrpcLogEntry.LoggerR\x06logger\x12F\n" +
	"\rclient_header\x18\x06 \x01(\v2\x1f.grpc.binarylog.v1.ClientHeaderH\x00R\fclientHeader\x12F\n" +
	"\rserver_header\x18\a \x01(\v2\x1f.grpc.binarylog.v1.ServerHeaderH\x00R\fserverHeader\x126\n" +
	"\amessage\x18\b \x01(\v2\x1a.grpc.binarylog.v1.MessageH\x00R\amessage\x126\n" +
	"\atrailer\x18\t \x01(\v2\x1a.grpc.binarylog.v1.TrailerH\x00R\atrailer\x12+\n" +
	"\x11payload_truncated\x18\n" +
	" \x01(\bR\x10payloadTruncated\x12.\n" +
	"\x04peer\x18\v \x01(\v2\x1a.grpc.binarylog.v1.AddressR\x04peer\"\xf5\x01\n" +
	"\tEventType\x12\x16\n" +
	"\x12EVENT_TYPE_UNKNOWN\x10\x00\x12\x1c\n" +
	"\x18EVENT_TYPE_CLIENT_HEADER\x10\x01\x12\x1c\n" +
	"\x18EVENT_TYPE_SERVER_HEADER\x10\x02\x12\x1d\n" +
	"\x19EVENT_TYPE_CLIENT_MESSAGE\x10\x03\x12\x1d\n" +
	"\x19EVENT_TYPE_SERVER_MESSAGE\x10\x04\x12 \n" +
	"\x1cEVENT_TYPE_CLIENT_HALF_CLOSE\x10\x05\x12\x1d\n" +
	"\x19EVENT_TYPE_SERVER_TRAILER\x10\x06\x12\x15\n" +
	"\x11EVENT_TYPE_CANCEL\x10\a\"B\n" +
	"\x06Logger\x12\x12\n" +
	"\x0eLOGGER_UNKNOWN\x10\x00\x12\x11\n" +
	"\rLOGGER_CLIENT\x10\x01\x12\x11\n" +
	"\rLOGGER_SERVER\x10\x02B\t\n" +
	"\apayload\"\xbb\x01\n" +
	"\fClientHeader\x127\n" +
	"\bmetadata\x18\x01 \x01(\v2\x1b.grpc.binarylog.v1.MetadataR\bmetadata\x12\x1f\n" +
	"\vmethod_name\x18\x02 \x01(\tR\n" +
	"methodName\x12\x1c\n" +
	"\tauthority\x18\x03 \x01(\tR\tauthority\x123\n" +
	"\atimeout\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\atimeout\"G\n" +
	"\fServerHeader\x127\n" +
	"\bmetadata\x18\x01 \x01(\v2\x1b.grpc.binarylog.v1.MetadataR\bmetadata\"\xb1\x01\n" +
	"\aTrailer\x127\n" +
	"\bmetadata\x18\x01 \x01(\v2\x1b.grpc.binarylog.v1.MetadataR\bmetadata\x12\x1f\n" +
	"\vstatus_code\x18\x02 \x01(\rR\n" +
	"statusCode\x12%\n" +
	"\x0estatus_message\x18\x03 \x01(\tR\rstatusMessage\x12%\n" +
	"\x0estatus_details\x18\x04 \x01(\fR\rstatusDetails\"5\n" +
	"\aMessage\x12\x16\n" +
	"\x06length\x18\x01 \x01(\rR\x06length\x12\x12\n" +
	"\x04data\x18\x02 \x01(\fR\x04data\"B\n" +
	"\bMetadata\x126\n" +
	"\x05entry\x18\x01 \x03(\v2 .grpc.binarylog.v1.MetadataEntryR\x05entry\"7\n" +
	"\rMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\fR\x05value\"\xb8\x01\n" +
	"\aAddress\x123\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1f.grpc.binarylog.v1.Address.TypeR\x04type\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\x12\x17\n" +
	"\aip_port\x18\x03 \x01(\rR\x06ipPort\"E\n" +
	"\x04Type\x12\x10\n" +
	"\fTYPE_UNKNOWN\x10\x00\x12\r\n" +
	"\tTYPE_IPV4\x10\x01\x12\r\n" +
	"\tTYPE_IPV6\x10\x02\x12\r\n" +
	"\tTYPE_UNIX\x10\x03B\\\n" +
	"\x14io.grpc.binarylog.v1B\x0eBinaryLogProtoP\x01Z2google.golang.org/grpc/binarylog/grpc_binarylog_v1b\x06proto3"

var (
	file_grpc_binlog_v1_binarylog_proto_rawDescOnce sync.Once
	file_grpc_binlog_v1_binarylog_proto_rawDescData []byte
)

func file_grpc_binlog_v1_binarylog_proto_rawDescGZIP() []byte {
	file_grpc_binlog_v1_binarylog_proto_rawDescOnce.Do(func() {
		file_grpc_binlog_v1_binarylog_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_grpc_binlog_v1_binarylog_proto_rawDesc), len(file_grpc_binlog_v1_binarylog_proto_rawDesc)))
	})
	return file_grpc_binlog_v1_binarylog_proto_rawDescData
}

var file_grpc_binlog_v1_binarylog_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_grpc_binlog_v1_binarylog_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_grpc_binlog_v1_binarylog_proto_goTypes = []any{
	(GrpcLogEntry_EventType)(0),   // 0: grpc.binarylog.v1.GrpcLogEntry.EventType
	(GrpcLogEntry_Logger)(0),      // 1: grpc.binarylog.v1.GrpcLogEntry.Logger
	(Address_Type)(0),             // 2: grpc.binarylog.v1.Address.Type
	(*GrpcLogEntry)(nil),          // 3: grpc.binarylog.v1.GrpcLogEntry
	(*ClientHeader)(nil),          // 4: grpc.binarylog.v1.ClientHeader
	(*ServerHeader)(nil),          // 5: grpc.binarylog.v1.ServerHeader
	(*Trailer)(nil),               // 6: grpc.binarylog.v1.Trailer
	(*Message)(nil),               // 7: grpc.binarylog.v1.Message
	(*Metadata)(nil),              // 8: grpc.binarylog.v1.Metadata
	(*MetadataEntry)(nil),         // 9: grpc.binarylog.v1.MetadataEntry
	(*Address)(nil),               // 10: grpc.binarylog.v1.Address
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 12: google.protobuf.Duration
}
var file_grpc_binlog_v1_binarylog_proto_depIdxs = []int32{
	11, // 0: grpc.binarylog.v1.GrpcLogEntry.timestamp:type_name -> google.protobuf.Timestamp
	0,  // 1: grpc.binarylog.v1.GrpcLogEntry.type:type_name -> grpc.binarylog.v1.GrpcLogEntry.EventType
	1,  // 2: grpc.binarylog.v1.GrpcLogEntry.logger:type_name -> grpc.binarylog.v1.GrpcLogEntry.Logger
	4,  // 3: grpc.binarylog.v1.GrpcLogEntry.client_header:type_name -> grpc.binarylog.v1.ClientHeader
	5,  // 4: grpc.binarylog.v1.GrpcLogEntry.server_header:type_name -> grpc.binarylog.v1.ServerHeader
	7,  // 5: grpc.binarylog.v1.GrpcLogEntry.message:type_name -> grpc.binarylog.v1.Message
	6,  // 6: grpc.binarylog.v1.GrpcLogEntry.trailer:type_name -> grpc.binarylog.v1.Trailer
	10, // 7: grpc.binarylog.v1.GrpcLogEntry.peer:type_name -> grpc.binarylog.v1.Address
	8,  // 8: grpc.binarylog.v1.ClientHeader.metadata:type_name -> grpc.binarylog.v1.Metadata
	12, // 9: grpc.binarylog.v1.ClientHeader.timeout:type_name -> google.protobuf.Duration
	8,  // 10: grpc.binarylog.v1.ServerHeader.metadata:type_name -> grpc.binarylog.v1.Metadata
	8,  // 11: grpc.binarylog.v1.Trailer.metadata:type_name -> grpc.binarylog.v1.Metadata
	9,  // 12: grpc.binarylog.v1.Metadata.entry:type_name -> grpc.binarylog.v1.MetadataEntry
	2,  // 13: grpc.binarylog.v1.Address.type:type_name -> grpc.binarylog.v1.Address.Type
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_grpc_binlog_v1_binarylog_proto_init() }
func file_grpc_binlog_v1_binarylog_proto_init() {
	if File_grpc_binlog_v1_binarylog_proto != nil {
		return
	}
	file_grpc_binlog_v1_binarylog_proto_msgTypes[0].OneofWrappers = []any{
		(*GrpcLogEntry_ClientHeader)(nil),
		(*GrpcLogEntry_ServerHeader)(nil),
		(*GrpcLogEntry_Message)(nil),
		(*GrpcLogEntry_Trailer)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_grpc_binlog_v1_binarylog_proto_rawDesc), len(file_grpc_binlog_v1_binarylog_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grpc_binlog_v1_binarylog_proto_goTypes,
		DependencyIndexes: file_grpc_binlog_v1_binarylog_proto_depIdxs,
		EnumInfos:         file_grpc_binlog_v1_binarylog_proto_enumTypes,
		MessageInfos:      file_grpc_binlog_v1_binarylog_proto_msgTypes,
	}.Build()
	File_grpc_binlog_v1_binarylog_proto = out.File
	file_grpc_binlog_v1_binarylog_proto_goTypes = nil
	file_grpc_binlog_v1_binarylog_proto_depIdxs = nil
}
