package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_AllowedFlexVolume = map[string]string{
	"":       "AllowedFlexVolume represents a single Flexvolume that is allowed to be used.",
	"driver": "driver is the name of the Flexvolume driver.",
}

func (AllowedFlexVolume) SwaggerDoc() map[string]string {
	return map_AllowedFlexVolume
}

var map_FSGroupStrategyOptions = map[string]string{
	"":       "FSGroupStrategyOptions defines the strategy type and options used to create the strategy.",
	"type":   "type is the strategy that will dictate what FSGroup is used in the SecurityContext.",
	"ranges": "ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end.",
}

func (FSGroupStrategyOptions) SwaggerDoc() map[string]string {
	return map_FSGroupStrategyOptions
}

var map_IDRange = map[string]string{
	"":    "IDRange provides a min/max of an allowed range of IDs.",
	"min": "min is the start of the range, inclusive.",
	"max": "max is the end of the range, inclusive.",
}

func (IDRange) SwaggerDoc() map[string]string {
	return map_IDRange
}

var map_PodSecurityPolicyReview = map[string]string{
	"":         "PodSecurityPolicyReview checks which service accounts (not users, since that would be cluster-wide) can create the `PodTemplateSpec` in question.\n\nCompatibility level 2: Stable within a major release for a minimum of 9 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec is the PodSecurityPolicy to check.",
	"status":   "status represents the current information/status for the PodSecurityPolicyReview.",
}

func (PodSecurityPolicyReview) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicyReview
}

var map_PodSecurityPolicyReviewSpec = map[string]string{
	"":                    "PodSecurityPolicyReviewSpec defines specification for PodSecurityPolicyReview",
	"template":            "template is the PodTemplateSpec to check. The template.spec.serviceAccountName field is used if serviceAccountNames is empty, unless the template.spec.serviceAccountName is empty, in which case \"default\" is used. If serviceAccountNames is specified, template.spec.serviceAccountName is ignored.",
	"serviceAccountNames": "serviceAccountNames is an optional set of ServiceAccounts to run the check with. If serviceAccountNames is empty, the template.spec.serviceAccountName is used, unless it's empty, in which case \"default\" is used instead. If serviceAccountNames is specified, template.spec.serviceAccountName is ignored.",
}

func (PodSecurityPolicyReviewSpec) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicyReviewSpec
}

var map_PodSecurityPolicyReviewStatus = map[string]string{
	"":                       "PodSecurityPolicyReviewStatus represents the status of PodSecurityPolicyReview.",
	"allowedServiceAccounts": "allowedServiceAccounts returns the list of service accounts in *this* namespace that have the power to create the PodTemplateSpec.",
}

func (PodSecurityPolicyReviewStatus) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicyReviewStatus
}

var map_PodSecurityPolicySelfSubjectReview = map[string]string{
	"":         "PodSecurityPolicySelfSubjectReview checks whether this user/SA tuple can create the PodTemplateSpec\n\nCompatibility level 2: Stable within a major release for a minimum of 9 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec defines specification the PodSecurityPolicySelfSubjectReview.",
	"status":   "status represents the current information/status for the PodSecurityPolicySelfSubjectReview.",
}

func (PodSecurityPolicySelfSubjectReview) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicySelfSubjectReview
}

var map_PodSecurityPolicySelfSubjectReviewSpec = map[string]string{
	"":         "PodSecurityPolicySelfSubjectReviewSpec contains specification for PodSecurityPolicySelfSubjectReview.",
	"template": "template is the PodTemplateSpec to check.",
}

func (PodSecurityPolicySelfSubjectReviewSpec) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicySelfSubjectReviewSpec
}

var map_PodSecurityPolicySubjectReview = map[string]string{
	"":         "PodSecurityPolicySubjectReview checks whether a particular user/SA tuple can create the PodTemplateSpec.\n\nCompatibility level 2: Stable within a major release for a minimum of 9 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec defines specification for the PodSecurityPolicySubjectReview.",
	"status":   "status represents the current information/status for the PodSecurityPolicySubjectReview.",
}

func (PodSecurityPolicySubjectReview) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicySubjectReview
}

var map_PodSecurityPolicySubjectReviewSpec = map[string]string{
	"":         "PodSecurityPolicySubjectReviewSpec defines specification for PodSecurityPolicySubjectReview",
	"template": "template is the PodTemplateSpec to check. If template.spec.serviceAccountName is empty it will not be defaulted. If its non-empty, it will be checked.",
	"user":     "user is the user you're testing for. If you specify \"user\" but not \"group\", then is it interpreted as \"What if user were not a member of any groups. If user and groups are empty, then the check is performed using *only* the serviceAccountName in the template.",
	"groups":   "groups is the groups you're testing for.",
}

func (PodSecurityPolicySubjectReviewSpec) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicySubjectReviewSpec
}

var map_PodSecurityPolicySubjectReviewStatus = map[string]string{
	"":          "PodSecurityPolicySubjectReviewStatus contains information/status for PodSecurityPolicySubjectReview.",
	"allowedBy": "allowedBy is a reference to the rule that allows the PodTemplateSpec. A rule can be a SecurityContextConstraint or a PodSecurityPolicy A `nil`, indicates that it was denied.",
	"reason":    "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available.",
	"template":  "template is the PodTemplateSpec after the defaulting is applied.",
}

func (PodSecurityPolicySubjectReviewStatus) SwaggerDoc() map[string]string {
	return map_PodSecurityPolicySubjectReviewStatus
}

var map_RangeAllocation = map[string]string{
	"":         "RangeAllocation is used so we can easily expose a RangeAllocation typed for security group\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"range":    "range is a string representing a unique label for a range of uids, \"1000000000-2000000000/10000\".",
	"data":     "data is a byte array representing the serialized state of a range allocation.  It is a bitmap with each bit set to one to represent a range is taken.",
}

func (RangeAllocation) SwaggerDoc() map[string]string {
	return map_RangeAllocation
}

var map_RangeAllocationList = map[string]string{
	"":         "RangeAllocationList is a list of RangeAllocations objects\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "List of RangeAllocations.",
}

func (RangeAllocationList) SwaggerDoc() map[string]string {
	return map_RangeAllocationList
}

var map_RunAsUserStrategyOptions = map[string]string{
	"":            "RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.",
	"type":        "type is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
	"uid":         "uid is the user id that containers must run as.  Required for the MustRunAs strategy if not using namespace/service account allocated uids.",
	"uidRangeMin": "uidRangeMin defines the min value for a strategy that allocates by range.",
	"uidRangeMax": "uidRangeMax defines the max value for a strategy that allocates by range.",
}

func (RunAsUserStrategyOptions) SwaggerDoc() map[string]string {
	return map_RunAsUserStrategyOptions
}

var map_SELinuxContextStrategyOptions = map[string]string{
	"":               "SELinuxContextStrategyOptions defines the strategy type and any options used to create the strategy.",
	"type":           "type is the strategy that will dictate what SELinux context is used in the SecurityContext.",
	"seLinuxOptions": "seLinuxOptions required to run as; required for MustRunAs",
}

func (SELinuxContextStrategyOptions) SwaggerDoc() map[string]string {
	return map_SELinuxContextStrategyOptions
}

var map_SecurityContextConstraints = map[string]string{
	"":                                "SecurityContextConstraints governs the ability to make requests that affect the SecurityContext that will be applied to a container. For historical reasons SCC was exposed under the core Kubernetes API group. That exposure is deprecated and will be removed in a future release - users should instead use the security.openshift.io group to manage SecurityContextConstraints.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata":                        "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"priority":                        "priority influences the sort order of SCCs when evaluating which SCCs to try first for a given pod request based on access in the Users and Groups fields.  The higher the int, the higher priority. An unset value is considered a 0 priority. If scores for multiple SCCs are equal they will be sorted from most restrictive to least restrictive. If both priorities and restrictions are equal the SCCs will be sorted by name.",
	"allowPrivilegedContainer":        "allowPrivilegedContainer determines if a container can request to be run as privileged.",
	"defaultAddCapabilities":          "defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capabiility in both DefaultAddCapabilities and RequiredDropCapabilities.",
	"requiredDropCapabilities":        "requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.",
	"allowedCapabilities":             "allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field maybe added at the pod author's discretion. You must not list a capability in both AllowedCapabilities and RequiredDropCapabilities. To allow all capabilities you may use '*'.",
	"allowHostDirVolumePlugin":        "allowHostDirVolumePlugin determines if the policy allow containers to use the HostDir volume plugin",
	"volumes":                         "volumes is a white list of allowed volume plugins.  FSType corresponds directly with the field names of a VolumeSource (azureFile, configMap, emptyDir).  To allow all volumes you may use \"*\". To allow no volumes, set to [\"none\"].",
	"allowedFlexVolumes":              "allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the \"Volumes\" field.",
	"allowHostNetwork":                "allowHostNetwork determines if the policy allows the use of HostNetwork in the pod spec.",
	"allowHostPorts":                  "allowHostPorts determines if the policy allows host ports in the containers.",
	"allowHostPID":                    "allowHostPID determines if the policy allows host pid in the containers.",
	"allowHostIPC":                    "allowHostIPC determines if the policy allows host ipc in the containers.",
	"userNamespaceLevel":              "userNamespaceLevel determines if the policy allows host users in containers. Valid values are \"AllowHostLevel\", \"RequirePodLevel\", and omitted. When \"AllowHostLevel\" is set, a pod author may set `hostUsers` to either `true` or `false`. When \"RequirePodLevel\" is set, a pod author must set `hostUsers` to `false`. When omitted, the default value is \"AllowHostLevel\".",
	"defaultAllowPrivilegeEscalation": "defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.",
	"allowPrivilegeEscalation":        "allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.",
	"seLinuxContext":                  "seLinuxContext is the strategy that will dictate what labels will be set in the SecurityContext.",
	"runAsUser":                       "runAsUser is the strategy that will dictate what RunAsUser is used in the SecurityContext.",
	"supplementalGroups":              "supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.",
	"fsGroup":                         "fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.",
	"readOnlyRootFilesystem":          "readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the SCC should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.",
	"users":                           "The users who have permissions to use this security context constraints",
	"groups":                          "The groups that have permission to use this security context constraints",
	"seccompProfiles":                 "seccompProfiles lists the allowed profiles that may be set for the pod or container's seccomp annotations.  An unset (nil) or empty value means that no profiles may be specifid by the pod or container.\tThe wildcard '*' may be used to allow all profiles.  When used to generate a value for a pod the first non-wildcard profile will be used as the default.",
	"allowedUnsafeSysctls":            "allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in \"*\" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.\n\nExamples: e.g. \"foo/*\" allows \"foo/bar\", \"foo/baz\", etc. e.g. \"foo.*\" allows \"foo.bar\", \"foo.baz\", etc.",
	"forbiddenSysctls":                "forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in \"*\" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.\n\nExamples: e.g. \"foo/*\" forbids \"foo/bar\", \"foo/baz\", etc. e.g. \"foo.*\" forbids \"foo.bar\", \"foo.baz\", etc.",
}

func (SecurityContextConstraints) SwaggerDoc() map[string]string {
	return map_SecurityContextConstraints
}

var map_SecurityContextConstraintsList = map[string]string{
	"":         "SecurityContextConstraintsList is a list of SecurityContextConstraints objects\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "List of security context constraints.",
}

func (SecurityContextConstraintsList) SwaggerDoc() map[string]string {
	return map_SecurityContextConstraintsList
}

var map_ServiceAccountPodSecurityPolicyReviewStatus = map[string]string{
	"":     "ServiceAccountPodSecurityPolicyReviewStatus represents ServiceAccount name and related review status",
	"name": "name contains the allowed and the denied ServiceAccount name",
}

func (ServiceAccountPodSecurityPolicyReviewStatus) SwaggerDoc() map[string]string {
	return map_ServiceAccountPodSecurityPolicyReviewStatus
}

var map_SupplementalGroupsStrategyOptions = map[string]string{
	"":       "SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.",
	"type":   "type is the strategy that will dictate what supplemental groups is used in the SecurityContext.",
	"ranges": "ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end.",
}

func (SupplementalGroupsStrategyOptions) SwaggerDoc() map[string]string {
	return map_SupplementalGroupsStrategyOptions
}

// AUTO-GENERATED FUNCTIONS END HERE
